;+
;NAME:
;	TEXT_READ1.PRO
;
;LAST CHANGED: ----------------------------------- 23-Jul-14
;
;PURPOSE:
;	TEXT_READ1 - simple text file read-in (single block)
;
;CATEGORY:
;	STAND ALONE: utilities
;
;CALLING SEQUENCE:
;	Result = text_READ1(FILNENAME)
;
;CALLED FROM AXIS:
;	many procedures
;
;ROUTINES
;	function 	TEXT_READ1, FNAME, print=print
; reads simple text files consisting of 1 block plus a header
; KEYWORDS
;	PRINT - if set, then print header information
;
;COMMON BLOCKS: none
;
;-----------------
; FILE ROUTINES -- eli's text format
;-----------------
;file structure-
;line 0: number of items
;line 1: string=name of first item
;line 2: size(item)
;line 3: item, space-delimited
;line 4: string=name of next item
;    :
;    :
;
;MODIFICATION HISTORY:
; (25-may-99 aph) activated print option in textread1 to work with ascii read-in
; (26-feb-00 aph) AXIS standard documentation
; (11-nov-00 cgz) migrated from former FILE.PRO
; (21-Apr-14 aph) tried to desensitize to  not-number characters at the end-of-file
;                 but failed. Should probably modify parsestring.pro to deal with those
; (23-Apr-14 aph) desensitize to not-number characters at the end-of-file using isnumber check on string
;-
; *******************************************************************************

function text_read1,fname, PRINT=print
   ;reads simple files which only consist of header info and one block
   on_error,2
   s='' & s2=''
   openr,unit,fname,/get_lun
   while not eof(unit) do begin
      readf,unit,s
;      print, s
      fa=parsestring(s) & sfa=size(fa)
      if keyword_set(print) and sfa(0) EQ 0 then print, s
      if sfa(0) gt 0 then begin
        ;line contains numbers
		nrows=6000					; this sets maximum length of data read in
        ans=fltarr(sfa(1), nrows)
        ans(*,0)=fa
        if keyword_set(print) then print, '           0    ',fa
        j=long(1)
        while not eof(unit) do begin
           ;if j/100 eq j/100. then print,j
           readf,unit,s2
           tmp = parsestring(s2)
           if size(tmp,/type) EQ 4 then begin 	; value must be a float
	           ans(*,j)=tmp
	           if keyword_set(print) then print, j, '    ', tmp
	           j=j+1
			endif else print, 'non-number encountered in reading file ', fname
        endwhile
;        j=j-1
      endif
   endwhile
   close,unit
   free_lun,unit
   return,ans(*,0:j-1)
end


