; Copyright (c) 1998-2002 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_IMG_line
;
;LAST CHANGED: ----------------------------------- 20-Jan-05
;
; PURPOSE:
;	This procedure replaces all pixels in a user-selected line
; with those of another user-selected line.
;
; CATEGORY:
;	AXIS: image analysis
;
; CALLING SEQUENCE:
;	AX_IMG_line
;
;CALLED FROM AXIS:
;	->Images->Delete region, after user clicks on a line

; INPUTS:
;	All input parameters are passed as keywords or through AXIS_COM
;
; KEYWORDS: none
;
; OUTPUTS:
;	Modified image placed in buffer 0.
;
; COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
 ; RESTRICTIONS:
;	only executable from AXIS
;
; MODIFICATION HISTORY:
; (29-dec-01 aph) first written
; (20-Jan-05 aph) add ability to define the y-index of line to be changed
;-

PRO ax_img_line

@axis_com
on_error,2

HANDLE_VALUE, Data(CurBuf), tmp
IF n_tags(tmp) EQ 0 THEN RETURN
IF tmp.t EQ '2d' THEN BEGIN
;  use cursor to identify line
;   WIDGET_CONTROL, Uprompt, SET_VALUE='use cursor to select line to be replaced'
;	CURSOR, xc, yc, /UP, /Data
;	ind = Dindex(xc,yc,tmp)
	badrow = CurY
; ---------------- confirm line number to modify ---------------
	badrow = get_num(prompt = 'line to replace ?', val = badrow, group = axis_ID)
; ---------- decide which line to use for replqcement ----------------
	avg_lin = dialog_message(/question,'Average adjacent lines ? ', title='Line replacement')
	if avg_lin  EQ 'Yes' then begin
		tmp.d(*,badrow) = (tmp.d(*,badrow-1)+ tmp.d(*,badrow+1))/2
		print, 'replaced line', badrow, ' with average of adjacent lines'
	endif else begin
		goodrow = get_num(prompt = 'replacement line ?', val = badrow+1, group = axis_ID)
		tmp.d(*,badrow) = tmp.d(*,goodrow)
		print, 'replaced line', badrow, ' with line ', goodrow
	endelse
	ax_color
	CurBuf = 0
	tmp.dl = 'RL ' + tmp.dl
	HANDLE_VALUE, Data(CurBuf), tmp, /set
	PlotBuf, CurBuf
	Label(CurBuf) = tmp.dl
	img_rep_line = 0
ENDIF ELSE WIDGET_CONTROL, Uprompt, Set_Value = 'Image~replace line: only for images'
END
