; Copyright (c) 1998-2006 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		AX_GEN_STACK
;
;LAST CHANGED: ----------------------------------- 10-Jun-06 (aph)
;
; PURPOSE:
;	This function processes a set of folders containing multi-images stacks for tomography read-in
;
; CATEGORY:
;	Input / output utilty; stand alone
;
; CALLING SEQUENCE:
;	Result = AX_GEN_STACK(GROUP=GROUP, CHANNEL=CHANNEL)
;
; INPUTS: none  [*.lst is a file giving path then a set of {name, angle}]
;
; KEYWORDS
;	GROUP 	ID of calling program
;	CHANNEL	number of data channel (default = 1)
;
; OUTPUTS: binary format (*.ncb) stack written
;
; COMMON:
;	AXIS
;	BSIF
;	ANAL
;   VOLUME_DATA
;
; USAGE:
;
; format of list file for tomography applications is
; path
; name1, angle1
; name2, angle2
; . . . .
;
; MODIFICATION HISTORY:
; (09-Jun-06 gaj) first version for use in axis and stand alone (for tomography)
; (10-jun-06 aph) linked into aXis2000
;-

Function ax_gen_stack, group=group, channel=channel

@axis_com
@bsif_com
@analcom
COMMON volume_data, image_stack
on_error,2

axis_on=0
if NOT keyword_set(group) then group = 0 else begin
	t = size(axis_ID, /type)
	if t NE 0 then begin
		group = axis_ID
		axis_on=1
	endif else begin
		axis_on=0
	endelse
endelse

; --------- read list of folders and angles ------------
list_filename=pickfile2(title = "List of files", filter='*.lst', /LPATH, DEFPATH=defpath)
get_lun,lun
openr,lun,list_filename
sl_path = ''
readf, lun, sl_path		; read first line as path
t = ax_name(sl_path)
filebase=t(0)+t(1)

widget_control,hourglass=1

; ------ determine number of files to process
got_started = 0

while ~ EOF(lun) do begin
	text = ' '
    readf, lun, text
    this_filename = strmid(text, 0, strpos(text,','))
    this_angle = strmid(text, strpos(text,',')+1)
    if (got_started eq 0) then begin
; ------ OK the first line is a path .... but is it the right one ? !!!!
       filename_list = [string(this_filename)]
       angle = [float(this_angle)]
       got_started = 1
    endif else begin
        filename_list = [filename_list,string(this_filename)]
        angle = [angle, float(this_angle)]
    endelse
 endwhile
nfiles=n_elements(filename_list)
filename_ev_msec_list = strarr(nfiles)
close,lun  &  free_lun,lun


; ---- define data channel (if not defined in keyword)
if NOT keyword_set(channel) then channel = 1

; ------------- read a single image to set up stack dimension
; read a single file to determine the size of image_stack
sep= ax_sep()
file = sl_path + filename_list(0) + '.hdr'
tmp = read_sdf(file, channel=channel, /silent, /no_interpolate )
energy = tmp.e
nx = n_elements(tmp.x)
ny = n_elements(tmp.y)
image_stack = fltarr(nx, ny, nfiles)
t =ax_name(list_filename)
file_short = t(1)
axis_log, 'converting  ' + file_short

; ------------- read a single image for each angle
file = sl_path + filename_list(0) + '.hdr'
;print, 'first read in file: ', file
tmp = read_sdf(file, channel=fix(channel), /silent, /no_interpolate)
axis_log, 'Energy ' + string(energy)
for i = 0, nfiles-1 do begin
	file = sl_path +  filename_list(i) + '.hdr'
	print, file
	tmp=read_sdf(file, channel=fix(channel), /silent, /no_interpolate)
	tmp.e = angle(i)
	t = ax_name(file)
	filename_ev_msec_list(i) = filename_list(i) + ' ' + strtrim(string(angle(i)), 2)
	axis_log, strtrim(string(i),2) + ': angle: ' + strtrim(string(tmp.e, format='(f5.1)'),2) + ' file: ' + t(1)
	image_stack(*,*,i) = tmp.d
endfor

; -------- write stack
svec = size(image_stack)
n_cols = nx  & n_rows = ny
x_start = tmp.x(0)
x_stop = tmp.x(n_elements(tmp.x)-1)
y_start = tmp.y(0)
y_stop = tmp.y(n_elements(tmp.y)-1)
xstep = (x_stop - x_start)/n_cols
ystep = (y_stop - y_start)/n_rows

;  ------------ set default filename
t = ax_name(list_filename)
filename = t(0) + t(1) + '.ncb'
filename = pickfile2(/write, filter='*.ncb', /Lpath, $
       defpath = WritePath) ;, get_path=WritePath)
; ---- force extension
t = ax_name(filename)
filename = t(0) + t(1) + '.ncb'
ev = angle
stack_wb, filename
widget_control,hourglass=0

return, filename
END
