; Copyright (c) 1998-2001 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_sdf_EARLY
;
;LAST CHANGED: ----------------------------------- 21-aug-01
;
;PURPOSE:
;	This set of procedures constitute a widget to read in files
; in the ascii self defining format (SDF). The widget uses
; read_sdfe and parse_sdf to actually do the file input.
;
;CATEGORY:
;	AXIS: utility
;
; AX_sdfE_EVENT ROUTINES:
; TEXT_sdfE_FNAME		modify filename; when changed, execute read_sdfe
; BUT_sdfE_FNAME_BROWSE 	browse for new filename
; BUT_sdfE_OK			proceed with loading SDF file into AXIS
; BUT_sdfE_CANCEL		abort read in
; WIDE_DLIST_CHANNEL		drop list used to display and select the data channel
; ax_sdfE_eventcb		auto loading stub
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;	sdfE_EVENT, SDF	structure with header info
;
;MODIFICATION HISTORY:
; (25-feb-01 aph) first written using IDL 5.2 GUIBuilder
; (21-aug-01 aph) rescued to enable readin of early files
;-

pro TEXT_sdfE_FNAME, Event
on_error,2
@axis_com
COMMON sdfE_EVENT, sdf, sdfE_Channel_List, sdfE_ch
; get the changed name
id = widget_info(Event.top, FIND_BY_UNAME = 'TEXT_sdfE_FNAME')
WIDGET_CONTROL,id, Sensitive=1, Get_value = fname

BUT_sdfE_FNAME_BROWSE, Event

end

;-----------------------------------------------------------------
pro BUT_sdfE_FNAME_BROWSE, Event, file=file
on_error,2
@axis_com
COMMON sdfE_EVENT, sdf, sdfE_Channel_List, sdfE_ch

; get new filename
if NOT keyword_set(file) then begin
	fname = dialog_pickfile(Title='Select SDF file', Filter = '*.hdr', PATH=DefPath, $
	  GET_PATH=DefPath, GROUP = BASE_SDF)
endif else fname = file
if strlen(fname) GT 0 then begin
; update name in the text box
	id = widget_info(Event.top, FIND_BY_UNAME = 'TEXT_sdfE_FNAME')
	WIDGET_CONTROL,id, Set_value = fname
; read file and update type
	widget_control, /hourglass
	sdf = read_sdfe(fname, /header_only)
; update the type
	id = widget_info(Event.top, FIND_BY_UNAME = 'TEXT_sdfE_TYPE')
	WIDGET_CONTROL,id, Sensitive=1, Set_value = sdf.ScanDefinition.Type
; update data channel information
	nchnl = n_elements(sdf.ScanDefinition.Channels)
	sdfE_Channel_List = strarr(nchnl)
	for i = 0, nchnl-1 do sdfE_Channel_List(i) = sdf.ScanDefinition.Channels[i].Name
	id = widget_info(Event.top, FIND_BY_UNAME = 'WIDE_DLIST_CHANNEL')
	WIDGET_CONTROL,id, Set_VALUE = sdfE_Channel_List
endif
end

pro WIDE_DLIST_CHANNEL, Event
on_error,2
@axis_com
COMMON sdfE_EVENT, sdf, sdfE_Channel_List, sdfE_ch

; get the changed data channel
id = widget_info(Event.top, FIND_BY_UNAME = 'WIDE_DLIST_CHANNEL')
WIDGET_CONTROL,id, Sensitive=1, Get_value = sdfE_ch
WIDGET_CONTROL,id, SET_DROPLIST_SELECT = sdfE_ch
end

;-----------------------------------------------------------------
pro BUT_sdfE_DISPLAY_HDR, Event, group=wGroup
on_error,2
@axis_com
COMMON sdfE_EVENT, sdf, sdfE_Channel_List, sdfE_ch

; get the header filename
id = widget_info(Event.top, FIND_BY_UNAME = 'TEXT_sdfE_FNAME')
WIDGET_CONTROL,id, Get_value = fname
if strlen(fname(0)) GT 0 then begin
	t = ax_name(fname(0))
	fname = t(0) + t(1) + '.hdr'
	XDisplayfile,fname, group = wGroup
endif
end

;-----------------------------------------------------------------
pro BUT_sdfE_OK, Event
on_error,2
@axis_com
COMMON sdfE_EVENT, sdf, sdfE_Channel_List, sdfE_ch
; get the  name
id = widget_info(Event.top, FIND_BY_UNAME = 'TEXT_sdfE_FNAME')
WIDGET_CONTROL,id, Sensitive=1, Get_value = fname
; get the data channel
id = widget_info(Event.top, FIND_BY_UNAME = 'WIDE_DLIST_CHANNEL')
sdfE_ch = WIDGET_INFO(id, /Droplist_select)
; read the data file
widget_control, /hourglass
sdf = read_sdfe(fname(0), channel=sdfE_ch(0)+1)
WIDGET_CONTROL, Event.Top, /DESTROY
return
end

;-----------------------------------------------------------------

pro BUT_sdfE_CANCEL, Event
on_error,2
WIDGET_CONTROL, Event.Top, /DESTROY
end

; ----------------------
; Empty stub procedure used for autoloading.
;
pro ax_sdfE_eventcb
end

;-----------------------------------------------------------------
; ****************************************************************
;-----------------------------------------------------------------

pro BASE_sdfE_event, Event
COMMON sdfE_EVENT, sdf, sdfE_Channel_List, sdfE_ch

  wWidget =  Event.top

  case Event.id of

    Widget_Info(wWidget, FIND_BY_UNAME='TEXT_sdfE_FNAME'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_TEXT_STR' )then $
        TEXT_sdfE_FNAME, Event
    end
      Widget_Info(wWidget, FIND_BY_UNAME='TEXT_sdfE_CHANNEL'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_TEXT_STR' )then $
        TEXT_sdfE_CHANNEL, Event
    end

    Widget_Info(wWidget, FIND_BY_UNAME='BUT_sdfE_FNAME_BROWSE'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        BUT_sdfE_FNAME_BROWSE, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='TEXT_sdfE_TYPE_TITLE_0'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_TEXT_DEL' )then $
        BUT_sdfE_FNAME_BROWSE, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='BUT_sdfE_DISPLAY_HDR'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        BUT_sdfE_DISPLAY_HDR, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='BUT_sdfE_OK'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        BUT_sdfE_OK, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='BUT_sdfE_CANCEL'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        BUT_sdfE_CANCEL, Event
    end
    else:
  endcase

end

pro BASE_SDFe, GROUP_LEADER=wGroup,  file=file, _EXTRA=_VWBExtra_

COMMON sdfE_EVENT, sdf, sdfE_Channel_List, sdfE_ch

  Resolve_Routine, 'ax_sdfE_eventcb'     ; Load event callback routines
t = size(wGroup)
IF t(1) EQ 0 THEN modal_val=0 else modal_val=1

;print, wgroup, 'modal_val = ' , modal_val

  BASE_SDFE = Widget_Base( GROUP_LEADER=wGroup, UNAME='BASE_SDFE'  $
      ,SCR_XSIZE=521 ,SCR_YSIZE=126 ,TITLE='Read Self Defining Format'+ $
      ' files' ,SPACE=3 ,XPAD=3 ,YPAD=3,  modal = modal_val)


  TEXT_sdfE_FNAME = Widget_Text(BASE_SDFE, UNAME='TEXT_sdfE_FNAME'  $
      ,FRAME=1 ,XOFFSET=110 ,YOFFSET=11 ,SCR_XSIZE=234 ,SCR_YSIZE=20  $
      ,/EDITABLE ,/ALL_EVENTS ,XSIZE=20 ,YSIZE=1)


  TEXT_sdfE_FNAME_TITLE = Widget_Text(BASE_SDFE,  $
      UNAME='TEXT_sdfE_FNAME_TITLE' ,XOFFSET=26 ,YOFFSET=12  $
      ,SCR_XSIZE=75 ,SCR_YSIZE=18 ,/ALL_EVENTS ,VALUE=[ 'File name' ]  $
      ,XSIZE=20 ,YSIZE=1)


  BUT_sdfE_FNAME_BROWSE = Widget_Button(BASE_SDFE,  $
      UNAME='BUT_sdfE_FNAME_BROWSE' ,XOFFSET=357 ,YOFFSET=10  $
      ,SCR_XSIZE=73 ,SCR_YSIZE=23 ,/ALIGN_CENTER ,VALUE='Browse')


  TEXT_sdfE_TYPE_TITLE_0 = Widget_Text(BASE_SDFE,  $
      UNAME='TEXT_sdfE_TYPE_TITLE_0' ,XOFFSET=24 ,YOFFSET=45  $
      ,SCR_XSIZE=75 ,SCR_YSIZE=18 ,/ALL_EVENTS ,VALUE=[ 'Type', '',  $
      '', '' ] ,XSIZE=20 ,YSIZE=1)


  TEXT_sdfE_TYPE = Widget_Text(BASE_SDFE, UNAME='TEXT_sdfE_TYPE'  $
      ,XOFFSET=113 ,YOFFSET=46 ,SCR_XSIZE=189 ,SCR_YSIZE=18  $
      ,/EDITABLE ,/ALL_EVENTS ,VALUE=[ 'Type', '', '', '' ] ,XSIZE=20  $
      ,YSIZE=1)


  BUT_sdfE_DISPLAY_HDR = Widget_Button(BASE_SDFE,  $
      UNAME='BUT_sdfE_DISPLAY_HDR' ,XOFFSET=320 ,YOFFSET=42  $
      ,SCR_XSIZE=112 ,SCR_YSIZE=28 ,/ALIGN_CENTER ,VALUE='Show'+ $
      ' parameters')


  BUT_sdfE_OK = Widget_Button(BASE_SDFE, UNAME='BUT_sdfE_OK'  $
      ,XOFFSET=454 ,YOFFSET=12 ,SCR_XSIZE=50 ,SCR_YSIZE=48  $
      ,/ALIGN_CENTER ,VALUE='OK')


  BUT_sdfE_CANCEL = Widget_Button(BASE_SDFE, UNAME='BUT_sdfE_CANCEL'  $
      ,XOFFSET=454 ,YOFFSET=66 ,SCR_XSIZE=50 ,SCR_YSIZE=30  $
      ,/ALIGN_CENTER ,VALUE='Cancel')

  sdfE_Channel_List =['Counter 0','Counter 1','Analog']
  sdfE_Ch = 1
  WIDE_DLIST_CHANNEL = Widget_Droplist(BASE_SDFE,  $
      /DYNAMIC_RESIZE, VALUE = sdfE_Channel_List, $
      UNAME='WIDE_DLIST_CHANNEL' ,XOFFSET=21 ,YOFFSET=72,  $
      TITLE='Data Channel')

  Widget_Control, /REALIZE, BASE_SDFe

  XManager, 'BASE_SDFe', BASE_SDFe

  if keyword_set(file) then begin
	print, 'still cannot preload files'
  endif

end

; ------------------

function ax_sdfe, file = file, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_
on_error,2
@axis_com
COMMON sdfE_EVENT, sdf, sdfE_Channel_List, sdfE_ch

; BASE_SDFE, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_

if keyword_set(file) then begin
	BASE_SDFe, GROUP_LEADER=wGroup, file=file, _EXTRA=_VWBExtra_
endif else begin
	BASE_SDFe, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_
endelse

return, sdf
end
