; Copyright (c) 1998-2004 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		AXIS_COMPILE
;
;LAST CHANGED: ----------------------------------- 	26-mar-04
;
; PURPOSE:
;	This batch file compiles all aXis2000 code as a check for errors
;
; CATEGORY:
;	utility
;
; CALLING SEQUENCE:   BATCH FILE
;	@AXIS_COMPILE
;
; INPUTS: none
;
; KEYWORDS: none
;
; OUTPUTS: time for compilation provided
;
; COMMON BLOCKS: none
;
; MODIFICATION HISTORY:
; (26-mar-04 aph) AXIS standard header added; systematic check for all files
;-

cd, 'c:\axis2000'        ; LOCATION WHERE AXIS code resides - PC version *****************
;cd,  Marvin HD:RSI:IDL 5.2:local:AXIS  ;  Zimba MacIntosh versio n

; NB ******** sequence of loading is critical *******
;  - therefore this alphabetized list is for documentation ONLY
;
; .run file
; .run gen_read
; .run graph		; retired 15-apr-00
; .run io
; .run math
; .run misc
; .run pick2
; .run print
; .run read_a_n
; .run read_abs
; .run read_als
; .run read_xas
; .run splota
; .run readstringbig
; .run spectra
; .run srotate
; .run struct
; .run window

T = systime(1)

; common stuff (BSIF format) needed for nsls and some conversion
@axis_com
@bsif_com

;.run math			; retired 15-nov-00 cgz
.run interp
				; interp newly defined from math.pro
.run interspline
				; interspline newly defined from math.pro
;.run file			; retired 11-nov-00 cgz
.run parsestring
				; parsestring newly defined from file.pro
.run chkfileblocks
				; chkfileblocks newly defined from file.pro
.run text_read
				; text_read newly defined from file.pro
.run text_read1
				; text_read1 newly defined from file.pro
;.run structure		; retired 11-nov-00 cgz
.run stag
				; stag newly defined from structure.pro
.run copy_bytes
;.run io			; retired 11-nov-00 cgz
.run read_img
				; read_img newly defined from io.pro
;.run misc			; retired 14-nov-00 cgz
;.run graph		; retired 15-apr-00 aph
;.run window		; retired 04-dec-00 cgz - BUT INCOMPLETE (aph 29-dec-00)
; --- extracted contents of window.pro
.run readwin
;.run win2tif 		; retired 04-jan-01 cgz
.run win2tiff

;.run print		; retired 29-nov-00 cgz

;.run splota		; retired 14-nov-00 cgz

.run splot
				; splot newly defined from splota.pro
.run splot2d
				; splot2d newly defined from splota.pro
.run splot3d
				; splot3d newly defined from splota.pro
.run read_als
.run read_a_n
.run readstringbig
.run read_untilstring
.run read_until_nochar
.run read_numbers
.run parsebytes
				; modified 15-nov-00 cgz
.run gen_read
.run spectra
.run srotate

; ********************
; developed for AXIS package (aph)
; ********************
; basic functions used in later pro's
.run dindex
;@bsif_com

; Fanning code for colorbar
.run colorbar
.run ax_colorbar
;.run ax_colorbar_zimba

; tools
.run align
.run als2ncdf
.run als_specin
.run als_spectra
; .run als_spectra_eventcb   incorporated into als_spectra
.run ax_bin
.run ax_cgo
.run ax_clear
;.run ax_clear_zimba
.run ax_color
;.run ax_color_zimba
.run ax_conv
.run ax_copy
.run ax_curvfit
.run ax_fix_rollover
.run ax_image_add
.run ax_image_append
.run ax_img_avg
.run ax_img_del
.run ax_imscl
.run ax_interp
.run ax_load_logo
;.run ax_load_logo_zimba
.run ax_mesh
.run ax_name
;.run ax_name_zimba
.run ax_nc2gif
.run ax_order
.run ax_particles
;.run ax_particles_zimba
.run ax_pc
.run ax_peem_read
.run ax_prof_rad
.run ax_read_xas
.run ax_rd_im
.run ax_sdf
.run ax_sep
.run ax_spec_delete
.run ax_stxm4nc
.run ax_svd
.run ax_switch
.run ax_wait
.run ax_write_xas
.run ax_xycal
.run ax_xydis
.run ax_xyscl
.run ax_zoom_cursor
.run ax_zoom_cut
.run ax_zoom_pan
.run axb_load
.run axb_save
.run axis_add
.run axis_app
.run axis_ini
;.run axis_ini_zimba
.run axis_options
;.run axis_options_zimba
.run axis_options_eventcb
;.run axis_options_eventcb_zimba
.run axis_read_image
.run axis_web
.run bnl_load
.run buffer
.run box
.run bx_cursor
.run cg_optimize
.run clean
.run clip
.run copy_bytes
.run cryo_to_stxm
.run deglitch
.run disp3col
.run distance
.run edgegauss
.run file_overwrite
.run file2string
.run get_num
.run get_path
.run get_text
.run img_algn
.run img_asav
.run img_load
.run img_warp
.run info
.run init_sd
.run init_stxm_sd
.run join_string
.run line_fit
.run lineclear
.run ln_add
.run ln_align
.run ln_load
.run ln_locat
.run ln_norm
.run ln_subsp
.run load_nex
.run load_spm
;.run loadspem
				; 15-nov-00 retired cgz
.run make_square
.run mbuf
.run ncdf2als
.run parse_sdf
.run pem_load
.run pickfile2
.run plot2d
.run plotbuf
.run plotsect
.run randomfile
.run rd_peem
.run rd_spem
.run read_a_n
.run read_als
.run read_axm
.run read_sdf
.run read_stxm4
.run read_bnl
.run read_bsp
.run read_cryo
.run read_cryo4
.run read_csv
.run read_mapper
.run read_mef
.run read_phi
.run read_sdf
.run read_sm
.run read_stxm
.run read_sxm
.run read_tof
.run read_xas
.run refresh
.run resetplots
.run sav_als
.run sav_hdf
.run sav_hdfm
.run setgraf
.run sav_nsls
.run spc_load
.run spc_save
.run sm_fixclock
.run sm_ipar
.run split_string
.run srotate
.run stack_align
.run stack_analyze
.run stack_buildlist
.run stack_fit
.run stack_list
.run stack_make
.run stack_movie
.run stack_plot_spectrum
.run stack_rb
.run stack_readlist
.run stack_wb
.run stack_writelist
.run str_columns
.run string2file
.run sxm_fileexists
.run sxm_ipar
.run sxm_readfile
.run sxm_strclean
.run thumblbls
.run thumbzoom
.run tif_load
.run tif2ncdf
.run tifrd_im
.run tri_fit
.run tweak
.run win2tif
.run win2tiff
.run write_ncdf
.run write_spectrum
.run write_xas
.run write_stxm
.run wrstx_ax
.run wt_spec
.run xas1
.run xas2
.run xmload
.run xm1_load

; ********************
; stuff for Z_stacks (Zimba files)
; ********************
.run box_cursor
;.run zimba_run
.run zstack_analyze
; NB zstack_color must come before zstack_color
.run zstack_color
.run zstack_buildlist
.run zstack_readlist
.run zstack_align_images
.run zstack_shift
.run zstack_tune
.run zstack_align
.run zstack_save
.run zstack_profile
.run zstack_spectra

; ********************
; stuff to load SF (Henke calculator for X-ray absorption parameters)
; ********************
;.run photon_conv		; retired 14-nov-00 cgz
.run wvlen2en
				; wvlen2en newly defined from photon_conv.pro
.run en2wvlen
				; en2wvlen newly defined from photon_conv.pro
.run string2file
.run uniq
.run sf_init
.run sf

;.run axis_dialog
;.run axis_c_zimba
;.run axis_zimba

print,string((systime(1) - T))+' seconds'

;END