;+ 
; ************************** axis.PRO *********************************** 
; start-up file for AXIS_C.PRO: 
; IDL4.0 WIDGET for analysing X-ray microscopy spectral and image data 
; @Hitchcock Enterprises unlimited 
; ======================================== LAST CHANGED: (aph 14-Jun-98) 
;- 
; AXIS.PRO is a batch file used to load routines needed by AXIS_C 
; 
; ------------ Development History ----------------------------- 
; (aph    Aug-97) first used when merged spectral & image 
; (aph    Mar-98) added extend path - needed for UNIX systems 
; (aph 13-Jun-98) incorporated stack pros in start-up 
; (aph 14-jun-98) adapted all {*.pro} to use @--_com includes (not e.g. axis_com.mon) 
;                   due to incompatibility with Linux 5.03 version of IDL 
; 
; ********************   SET STARTING DIRECTORY ********************************* 
; MODIFY the next command to set the default directory to the one with AXIS code 
; ALSO . . . change the corresponding line in the file RESTART.PRO 
; NB when the default directory is changed and axis is then restarted 
; by executing axis_c there is an error (can't find the logo file AXIS.BMP) which 
; the @recover procedure does not correct. In this case, execute RESTART. 
; This will kill the damaged AXIS widget; change to the axis source directory and run axis_c. 
; ******************** 
cd, '/data/stxm/axis'     ; for McMaster Linux  
; ******************** 
; NOTE about PATHS: 
; a subdirectory containing PRO files that AXIS requires can be appended to the existing 
; PATH that IDL is using by executing the command: 
;              !path = !path + EXPAND_PATH('NEW_directory') 
; IF you wish to have IDL search ALL DIRECTORIES contained within a given directory: 
;              !path = !path + EXPAND_PATH('+NEW_directory') 
; on Windows systems: the PATH searched by IDL to find PRO filescan modified in the 
;                     "Preferences" command in the File pull-down menu 
; on UNIX systems:   the PATH must be controlled by using EXPAND_PATH in this start-up file. 
; 
; *************** 
 
!path=!path+':'+expand_path('+/data/stxm/axis')  ; include axisdir and subdirectories in path (UNIX) 
 
.size 60000 10000  ; default of 32K, 8K is exceeded when compiling AXIS_C.PRO !! 
 
; ******************** 
; adapted from als (jdd) 
; ******************** 
; NB sequence of loading is critical - therefore this alphabetized list 
					; is for documentation ONLY 
; .run file 
; .run graph 
; .run io 
; .run math 
; .run misc 
; .run pick2 
; .run print 
; .run read_a_n 
; .run read_abs 
; .run read_als 
; .run read_xas 
; .run splota 
; .run struct 
; .run window 
 
.run math, file, struct 
.run io, misc, graph ,window, print 
.run splota, pick2 
.comp read_als, read_a_n 
 
; ******************** 
; developed for AXIS package (aph) 
; ******************** 
; basic functions used in later pro's 
.comp dindex 
 
; tools 
.comp aloadct 
.comp als2ncdf 
.comp ax_rd_im 
.comp ax_xycal 
.comp ax_xydis 
.comp ax_xyscl 
.comp ax_zoom 
.comp axb_load 
.comp axb_save 
.comp axis_add 
.comp axis_app 
.comp axis_ini 
.comp bnl_load 
.comp buffer 
.comp bx_curs 
.comp get_num 
.comp get_text 
.comp img_algn 
.comp img_asav 
.comp img_load 
.comp linenorm 
.comp ln_align 
.comp mbuf 
.comp mk_squar 
.comp plotbuf 
.comp plotsect 
.comp rdstx_ax 
.comp read_mef 
.comp read_phi 
.comp read_re 
.comp read_tof 
.comp sav_als 
.comp sav_hdf 
.comp sav_hdfm 
.comp sav_nsls 
.comp spc_load 
.comp spc_save 
.comp thumbs 
.comp tif_load 
.comp wrstx_ax 
.comp xas1 
.comp xas2 
 
; ******************** 
; stuff for nsls files: adapted from nsls (cj) (NB .comp bsif_common may work) 
; ******************** 
@bsif_common 
.comp copy_byt 
.comp init_sd 
.comp init_stx 
.comp read_bnl 
.comp read_bsp 
 
; ******************** 
; stuff for stacks (cjj) 
; ******************** 
.comp align 
.comp read_bl7 
.comp read_stx 
.comp stack_mo 
.comp stack_al 
.comp stack_an 
.comp stack_re 
.comp stack_bu 
.comp stack_pl 
.comp stack_wr 
.comp write_sp 
.comp write_nc 
.comp wt_spec 
 
; ******************** 
; files that use things in axis_c 
; NB AXIS (and other files)contains several PRO's and FUNCTION's which need to be loaded 
; ******************** 
.comp axis_c 
 
; ******************** 
; run the main code 
; ******************** 
axis_c, start_file =  'axis.ini' 
