; Copyright (c) 1999,2000 Adam Hitchcock 
; 
; FUNCTION file_overwrite, GROUP=Group, VAL=val, PROMPT = prompt 
; ************************************ ---------- last changed: 26-feb-00 
;+ 
; NAME: 
;      FILE_OVERWRITE 
; 
; LAST CHANGED ---------------------------- 27-feb-00 
; 
; PURPOSE: 
;      widget to warn user if file over writing is occurring. 
;	'0 = change name, 1 = overwrite, 2 = overwrite all' - call from PICKFILE2 
; 
; CATEGORY: 
;       Input/Output. 
; 
; CALLING SEQUENCE: 
;	Result = FILE_OVERWRITE(PROMPT = 'prompt', VAL = 1, GROUP = AxisID) 
; 
; INPUTS: none 
; 
; KEYWORDS: 
;   	PROMPT = prompt to user 
;       VAL = current (default) value (0 = no overwrite, 1 = overwrite) 
;		GROUP = Widget_Id of group leader (must be set to force modal) 
; 
; OUTPUTS: 
;       The function returns a FLOAT value which is either 
;		the existing value (user hits <enter>) 
;		or the first number in the string the user types 
; 
; ROUTINES 
;	OWRITE_EVENT, event - event processing procedure 
;	FILE_OVERWRITE - function 
; 
; COMMON BLOCKS: 
;       Owrite_com, text 
; 
; SIDE EFFECTS: None. 
; 
; RESTRICTIONS: 
;       See DESCRIPTION. 
; 
; DESCRIPTION: 
;       This routine handles a user prompt when a file is found to exist. 
; If the top level group ID is supplied, the function widget is 
; put into modal mode (the dialog box stays on top until user completes input 
; and disables other functions of AXIS) 
; 
; MODIFICATION HISTORY: 
; (31-dec-99 aph) first written 
; (27-feb-00 aph) documented 
;- 
 
PRO Owrite_Event, Event 
Common Owrite_com, text 
 
WIDGET_CONTROL,Event.Id,GET_UVALUE=Ev 
 
CASE Ev OF 
  'owrite': BEGIN 
	   	 WIDGET_CONTROL, Event.Id, GET_VALUE = text 
	   	 WIDGET_CONTROL, Event.Top, /DESTROY 
     END 
       ELSE: message, 'Invalid event call in file_overwrite' 
ENDCASE 
END 
 
 
FUNCTION file_overwrite, GROUP=Group, VAL=val, PROMPT = prompt 
 
Common Owrite_com, text 
 
modal_val=1 
IF N_ELEMENTS(Group) EQ 0 THEN begin 
;  	test_valid = widget_event(AXIS, bad_id=bad_id) ;, FIND_BY_UNAME = 'AXIS') 
;  	print, 'test_valid',test_valid 
;	if group EQ 0 then				; attempt to auto-test if in AXIS - no go yet 
	group=0 
	modal_val=0 
ENDIF 
 
junk   = { CW_PDMENU_S, flags:0, name:'' } 
 
 
Owrite = WIDGET_BASE(GROUP_LEADER=Group, $ 
      ROW=2, $ 
      MAP=1, $ 
      modal = modal_val, $ 
      TITLE='File exists!', $ 
      UVALUE='Owrite') 
 
prompt_text = '0 = change name, 1 = overwrite, 2 = overwrite all' 
if keyword_set(prompt) then prompt_text = prompt 
 
LABEL2 = WIDGET_LABEL( Owrite, $ 
;      DYNAMIC_RESIZE=1, $ 
      UVALUE='prompt', $ 
      VALUE=prompt_text) 
 
num_text = '' 
IF KEYWORD_SET(val) THEN num_text = strcompress(string(val)) 
text = num_text 
 
TEXT2 = WIDGET_TEXT( Owrite,VALUE=num_text, $ 
      EDITABLE=1, $ 
      UVALUE='owrite', $ 
      YSIZE=1) 
 
WIDGET_CONTROL, Owrite, /REALIZE 
WIDGET_CONTROL, TEXT2, /INPUT_FOCUS 
XMANAGER, 'Owrite', Owrite 
tval = float(text) 
val = float(0) 
val = tval(0) 
Return, val 
END 
