;+
;NAME:
;	REMOVE_ZEROS.PRO
;
;LAST CHANGED: ----------------------------------- 10-Apr-04
;
;PURPOSE:
;	This function replaces all zeros in an image file
;    with the adjacent non-zero data
;
;CATEGORY:
;	STAND ALONE: utilities
;
;CALLING SEQUENCE:
;	Result = REMOVE_ZEROS(2d_structure.pro)
;
;CALLED FROM AXIS:
;	stack_analyze
;
;COMMON BLOCKS:
; axis_com
;
;MODIFICATION HISTORY:
; (10-Apr-04 aph) first version
;-
; *******************************************************************************
function remove_zeros, image, silent=silent
@axis_com
on_Error,2
tmp = image
count_all = 0
count = 1
test = 5
 while (count NE 0) do begin
	index_zero = where(tmp EQ 0, count)
;	print, index_zero
	IF count NE 0 THEN begin
		for i = 0, n_elements(index_zero)-1 do begin
		  	if index_zero(i) NE 0 then tmp(index_zero(i)) = tmp(index_zero(i)-1) else $
		  	    tmp(index_zero(i)) =  tmp(1)
		endfor
	endif
	count_all = count_all + count
	test = test - 1
	if test EQ 0 then count = 0
 endwhile
if NOT keyword_set(silent) then print, 'Remove_zeros has removed ', strtrim(string(count_all),2),' zeros'
return, tmp
end
