; Copyright (c) 1996, ALS SpectroMicroscopy Facility, jdd ; 1996-2006 A.P. Hitchcock
;  **** *********** splot3d removed ****** rel to jdd's version (splot) *******
;+
; FILE: splota.pro
;
; last changed: ------------------------------  22-Mar-06
;
; REQUIREMENTS:  graph.pro MUST be compiled prior
;
; CONTENTS:
;  pro SPLOT, s1 [, opt, _extra=e]
;      options: /O - overplot
;               /DN - plot dn: field (data norm)
;               /WB - white on black
;               /ZERO - autoscale y from 0
;               _extra=e - pass along PLOT options
;
; INPUTS
;     basic input data structure: s1={d:, x:}
;     optional axis and title label fields include {xl:, yl:, dl:}
;
; COMMON: axis_com
;
; REVISIONS
; 2/19/96  initial creation
; 6/15/96  jdd added generalized interpretation of structures
;              in SPLOT, SPLOT2D, SPLOT3D
;              separated splot stuff from graph.pro
; 6/29/96  aph allow numerical limts on ranges
; (06-Dec-97 aph) remove print of ytitle
; (03-jan-99 aph) add back in YTitle (!!)
; (24-jun-99 aph) consistent image/spectra color tables
; (13-aug-99 aph) no change - just using debugs to track reform problem
; (14-nov-00 cgz) migrated from SPLOTA.PRO
; (22-Mar-06 aph) increase character size
;-

pro splot, s, O=oplot, DN=dn, WB=wb, CHARSIZE=csz, COLOR=clr, $
    ZERO=zero,  _extra=e
;--------------------------------------
; basic 1-D structure {d:data, x:xaxis}
; optional label fields{ dl:, xl:} fields for xaxis and data label
; optional field is {dn:} for data normalization
; options:  /O -- overplot
;           O=iclr -- overplot with color=iclr

@axis_com
on_error,2

yst=16
if keyword_set(zero) then yst=0
; if keyword_set(e) then print,e   ;aph - deleted printing of extra opts
zdata=s.d
if keyword_set(dn) then zdata=s.dn
iclr=[0,255]	; default to Black-on-White
if keyword_set(wb) then iclr=[255,0]
if keyword_set(clr) then iclr(0)=clr

if keyword_set(oplot) then begin
   if not keyword_set(clr) then iclr(0)=128
   if oplot gt 1 then iclr(0)=oplot
   oplot, s.x, zdata, color=iclr(0), _extra=e
endif else begin
   if not keyword_set(csz) then csz=1.5	;nominal character size
   if not keyword_set(clr) then clr=0
   xl='' & yl = '' & dl=''
   if stag(s,'xl') then xl=s.xl
   if stag(s,'yl') then yl=s.yl
   if stag(s,'dl') then dl=s.dl
   plot, s.x, zdata, $
      xtitle=xl, xstyle=1, ystyle=yst, title=dl, ytitle = yl, $
      color=iclr(0), back=iclr(1), charsize=csz, _extra=e
endelse
end

