PRO Stack_setup_update 
 
@bsif_com 
 
COMMON Stack_setup_common, stack_setup_par, stack_strlen, $ 
  i_ev, i_khz, i_filename, i0_ev, i0_khz, i0_filename, i0_counts, $ 
  template_filename, sd_template, ev_list, msec_list, z_list, header 
 
msec_list = 0 
ev_list = 0 
z_list = 0 
 
IF ((stack_setup_par.r1_got_endev NE 0) AND $ 
    (stack_setup_par.r1_got_deltaev NE 0) AND $ 
    (stack_setup_par.r1_got_msec NE 0) AND $ 
    (stack_setup_par.got_i0 NE 0)) THEN BEGIN 
    ev_left = min(i0_ev) 
    ev_right = stack_setup_par.r1_endev 
    delta_ev = stack_setup_par.r1_deltaev 
    msec_dwell = stack_setup_par.r1_msec 
    n_ev = fix(0.5+(ev_right-ev_left) / float(delta_ev)) 
    ev_list = ev_left+delta_ev*findgen(n_ev) 
    msec_list = msec_dwell+fltarr(n_ev) 
ENDIF 
 
IF ((stack_setup_par.r2_got_endev NE 0) AND $ 
    (stack_setup_par.r2_got_deltaev NE 0) AND $ 
    (stack_setup_par.r2_got_msec NE 0) AND $ 
    (stack_setup_par.r1_got_endev NE 0)) THEN BEGIN 
    ev_left = stack_setup_par.r1_endev 
    ev_right = stack_setup_par.r2_endev 
    delta_ev = stack_setup_par.r2_deltaev 
    msec_dwell = stack_setup_par.r2_msec 
    n_ev = fix(0.5+(ev_right-ev_left) / float(delta_ev)) 
    new_ev_list = ev_left+delta_ev*findgen(n_ev) 
    new_msec_list = msec_dwell+fltarr(n_ev) 
    ev_list = [ev_list, new_ev_list] 
    msec_list = [msec_list, new_msec_list] 
ENDIF 
 
IF ((stack_setup_par.r3_got_endev NE 0) AND $ 
    (stack_setup_par.r3_got_deltaev NE 0) AND $ 
    (stack_setup_par.r3_got_msec NE 0) AND $ 
    (stack_setup_par.r2_got_endev NE 0)) THEN BEGIN 
    ev_left = stack_setup_par.r2_endev 
    ev_right = stack_setup_par.r3_endev 
    delta_ev = stack_setup_par.r3_deltaev 
    msec_dwell = stack_setup_par.r3_msec 
    n_ev = fix(0.5+(ev_right-ev_left) / float(delta_ev)) 
    new_ev_list = ev_left+delta_ev*findgen(n_ev) 
    new_msec_list = msec_dwell+fltarr(n_ev) 
    ev_list = [ev_list, new_ev_list] 
    msec_list = [msec_list, new_msec_list] 
ENDIF 
 
IF ((stack_setup_par.r4_got_endev NE 0) AND $ 
    (stack_setup_par.r4_got_deltaev NE 0) AND $ 
    (stack_setup_par.r4_got_msec NE 0) AND $ 
    (stack_setup_par.r3_got_endev NE 0)) THEN BEGIN 
    ev_left = stack_setup_par.r3_endev 
    ev_right = stack_setup_par.r4_endev 
    delta_ev = stack_setup_par.r4_deltaev 
    msec_dwell = stack_setup_par.r4_msec 
    n_ev = fix(0.5+(ev_right-ev_left) / float(delta_ev)) 
    new_ev_list = ev_left+delta_ev*findgen(n_ev) 
    new_msec_list = msec_dwell+fltarr(n_ev) 
    ev_list = [ev_list, new_ev_list] 
    msec_list = [msec_list, new_msec_list] 
ENDIF 
 
IF ((stack_setup_par.r5_got_endev NE 0) AND $ 
    (stack_setup_par.r5_got_deltaev NE 0) AND $ 
    (stack_setup_par.r5_got_msec NE 0) AND $ 
    (stack_setup_par.r4_got_endev NE 0)) THEN BEGIN 
    ev_left = stack_setup_par.r4_endev 
    ev_right = stack_setup_par.r5_endev 
    delta_ev = stack_setup_par.r5_deltaev 
    msec_dwell = stack_setup_par.r5_msec 
    n_ev = fix(0.5+(ev_right-ev_left) / float(delta_ev)) 
    new_ev_list = ev_left+delta_ev*findgen(n_ev) 
    new_msec_list = msec_dwell+fltarr(n_ev) 
    ev_list = [ev_list, new_ev_list] 
    msec_list = [msec_list, new_msec_list] 
ENDIF 
 
IF (stack_setup_par.r1_got_endev NE 0) THEN BEGIN 
    widget_control, stack_setup_par.r1_endev_label, $ 
      set_value = strtrim(string(stack_setup_par.r1_endev,$ 
                                 format='(f10.2)'),2) 
ENDIF 
IF (stack_setup_par.r1_got_deltaev NE 0) THEN BEGIN 
    widget_control, stack_setup_par.r1_deltaev_label, $ 
      set_value = strtrim(string(stack_setup_par.r1_deltaev,$ 
                                 format='(f10.2)'),2) 
ENDIF 
IF (stack_setup_par.r1_got_msec NE 0) THEN BEGIN 
    widget_control, stack_setup_par.r1_msec_label, $ 
      set_value = strtrim(string(stack_setup_par.r1_msec,$ 
                                 format='(f10.2)'),2) 
ENDIF 
 
IF (stack_setup_par.r2_got_endev NE 0) THEN BEGIN 
    widget_control, stack_setup_par.r2_endev_label, $ 
      set_value = strtrim(string(stack_setup_par.r2_endev,$ 
                                 format='(f10.2)'),2) 
ENDIF 
IF (stack_setup_par.r2_got_deltaev NE 0) THEN BEGIN 
    widget_control, stack_setup_par.r2_deltaev_label, $ 
      set_value = strtrim(string(stack_setup_par.r2_deltaev,$ 
                                 format='(f10.2)'),2) 
ENDIF 
IF (stack_setup_par.r2_got_msec NE 0) THEN BEGIN 
    widget_control, stack_setup_par.r2_msec_label, $ 
      set_value = strtrim(string(stack_setup_par.r2_msec,$ 
                                 format='(f10.2)'),2) 
ENDIF 
 
IF (stack_setup_par.r3_got_endev NE 0) THEN BEGIN 
    widget_control, stack_setup_par.r3_endev_label, $ 
      set_value = strtrim(string(stack_setup_par.r3_endev,$ 
                                 format='(f10.2)'),2) 
ENDIF 
IF (stack_setup_par.r3_got_deltaev NE 0) THEN BEGIN 
    widget_control, stack_setup_par.r3_deltaev_label, $ 
      set_value = strtrim(string(stack_setup_par.r3_deltaev,$ 
                                 format='(f10.2)'),2) 
ENDIF 
IF (stack_setup_par.r3_got_msec NE 0) THEN BEGIN 
    widget_control, stack_setup_par.r3_msec_label, $ 
      set_value = strtrim(string(stack_setup_par.r3_msec,$ 
                                 format='(f10.2)'),2) 
ENDIF 
 
IF (stack_setup_par.r4_got_endev NE 0) THEN BEGIN 
    widget_control, stack_setup_par.r4_endev_label, $ 
      set_value = strtrim(string(stack_setup_par.r4_endev,$ 
                                 format='(f10.2)'),2) 
ENDIF 
IF (stack_setup_par.r4_got_deltaev NE 0) THEN BEGIN 
    widget_control, stack_setup_par.r4_deltaev_label, $ 
      set_value = strtrim(string(stack_setup_par.r4_deltaev,$ 
                                 format='(f10.2)'),2) 
ENDIF 
IF (stack_setup_par.r4_got_msec NE 0) THEN BEGIN 
    widget_control, stack_setup_par.r4_msec_label, $ 
      set_value = strtrim(string(stack_setup_par.r4_msec,$ 
                                 format='(f10.2)'),2) 
ENDIF 
 
IF (stack_setup_par.r5_got_endev NE 0) THEN BEGIN 
    widget_control, stack_setup_par.r5_endev_label, $ 
      set_value = strtrim(string(stack_setup_par.r5_endev,$ 
                                 format='(f10.2)'),2) 
ENDIF 
IF (stack_setup_par.r5_got_deltaev NE 0) THEN BEGIN 
    widget_control, stack_setup_par.r5_deltaev_label, $ 
      set_value = strtrim(string(stack_setup_par.r5_deltaev,$ 
                                 format='(f10.2)'),2) 
ENDIF 
IF (stack_setup_par.r5_got_msec NE 0) THEN BEGIN 
    widget_control, stack_setup_par.r5_msec_label, $ 
      set_value = strtrim(string(stack_setup_par.r5_msec,$ 
                                 format='(f10.2)'),2) 
ENDIF 
 
IF (stack_setup_par.got_zp_d NE 0) THEN BEGIN 
    widget_control, stack_setup_par.zp_d_label, $ 
      set_value = strtrim(string(stack_setup_par.zp_d_um,$ 
                                 format='(f10.1)'),2) 
ENDIF 
 
IF (stack_setup_par.got_zp_drn NE 0) THEN BEGIN 
    widget_control, stack_setup_par.zp_drn_label, $ 
      set_value = strtrim(string(stack_setup_par.zp_drn_nm,$ 
                                 format='(f10.1)'),2) 
ENDIF 
 
widget_control, stack_setup_par.doit_label, sensitive = 0 
IF ((stack_setup_par.got_template NE 0) AND $ 
    (n_elements(ev_list) GT 1)) THEN BEGIN 
    IF ((stack_setup_par.got_zp_d NE 0) AND $ 
        (stack_setup_par.got_zp_drn NE 0) AND $ 
        (stack_setup_par.r1_got_endev NE 0)) THEN BEGIN 
        nm_list = 1239.852/ev_list 
        f_list = stack_setup_par.zp_d_um*stack_setup_par.zp_drn_nm / $ 
          nm_list 
        f_template = stack_setup_par.zp_d_um*stack_setup_par.zp_drn_nm / $ 
          (0.1*sd_template.wavelength) 
        z_list = sd_template.focus_position+(f_template-f_list) 
 
        widget_control, stack_setup_par.ev_min_label, $ 
          set_value = strtrim(string(min(ev_list), format = '(f10.1)'), 2) 
        widget_control, stack_setup_par.ev_max_label, $ 
          set_value = strtrim(string(max(ev_list), format = '(f10.1)'), 2) 
        widget_control, stack_setup_par.z_min_label, $ 
          set_value = strtrim(string(min(z_list), format = '(f10.1)'), 2) 
        widget_control, stack_setup_par.z_max_label, $ 
          set_value = strtrim(string(max(z_list), format = '(f10.1)'), 2) 
        IF ((stack_setup_par.got_header NE 0) AND $ 
            (stack_setup_par.got_firstfile_num NE 0)) THEN BEGIN 
            widget_control, stack_setup_par.doit_label, sensitive = 1 
        ENDIF 
    ENDIF 
 
    total_hours = total(msec_list)*sd_template.scan_width*$ 
      sd_template.scan_height/(1000.*60.*60.) 
    widget_control, stack_setup_par.total_hours_label, $ 
      set_value = strtrim(string(total_hours, format = '(f10.1)'), 2) 
ENDIF 
 
return 
END 
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
 
PRO Stack_setup_plots 
 
@bsif_com 
 
COMMON Stack_setup_common, stack_setup_par, stack_strlen, $ 
  i_ev, i_khz, i_filename, i0_ev, i0_khz, i0_filename, i0_counts, $ 
  template_filename, sd_template, ev_list, msec_list, z_list, header 
 
wset, stack_setup_par.i_plot_win 
erase 
wset, stack_setup_par.i0_plot_win 
erase 
 
IF (stack_setup_par.r1_got_endev NE 0) THEN BEGIN 
    IF ( (stack_setup_par.i0_plot_leftpix NE 0) AND $ 
         (stack_setup_par.i0_plot_rightpix NE 0) AND $ 
         (stack_setup_par.i0_plot_botpix NE 0) AND $ 
         (stack_setup_par.i0_plot_toppix NE 0) ) THEN BEGIN 
        wset, stack_setup_par.i0_plot_win 
        right_pix = convert_coord(stack_setup_par.r1_endev, !Y.crange(1), $ 
                                  /data, /to_device) 
        nxpix = fix(right_pix(0)) - $ 
          stack_setup_par.i0_plot_leftpix 
        i0_nypix = stack_setup_par.i0_plot_toppix - $ 
          stack_setup_par.i0_plot_botpix 
        IF (stack_setup_par.got_i0 NE 0) THEN BEGIN 
            wset, stack_setup_par.i0_plot_win 
            blob = bytarr(nxpix, i0_nypix)+$ 
              stack_setup_par.red_index 
            tv, blob, stack_setup_par.i0_plot_leftpix, $ 
              stack_setup_par.i0_plot_botpix, /device 
        ENDIF 
    ENDIF 
 
    IF ( (stack_setup_par.i0_plot_leftpix NE 0) AND $ 
         (stack_setup_par.i0_plot_rightpix NE 0) AND $ 
         (stack_setup_par.i_plot_botpix NE 0) AND $ 
         (stack_setup_par.i_plot_toppix NE 0) ) THEN BEGIN 
        right_pix = convert_coord(stack_setup_par.r1_endev, !Y.crange(1), $ 
                                  /data, /to_device) 
        nxpix = fix(right_pix(0)) - $ 
          stack_setup_par.i0_plot_leftpix 
        i_nypix = stack_setup_par.i_plot_toppix-stack_setup_par.i_plot_botpix 
 
        IF (stack_setup_par.got_i NE 0) THEN BEGIN 
            wset, stack_setup_par.i_plot_win 
            blob = bytarr(nxpix, i_nypix)+$ 
              stack_setup_par.red_index 
            tv, blob, stack_setup_par.i0_plot_leftpix, $ 
              stack_setup_par.i_plot_botpix, /device 
        ENDIF 
    ENDIF 
 
ENDIF 
 
IF ((stack_setup_par.r2_got_endev NE 0) AND $ 
    (stack_setup_par.r1_got_endev NE 0)) THEN BEGIN 
    IF ( (stack_setup_par.i0_plot_leftpix NE 0) AND $ 
         (stack_setup_par.i0_plot_rightpix NE 0) AND $ 
         (stack_setup_par.i0_plot_botpix NE 0) AND $ 
         (stack_setup_par.i0_plot_toppix NE 0) ) THEN BEGIN 
        wset, stack_setup_par.i0_plot_win 
        right_pix = convert_coord(stack_setup_par.r2_endev, !Y.crange(1), $ 
                                  /data, /to_device) 
        left_pix = convert_coord(stack_setup_par.r1_endev, !Y.crange(1), $ 
                                 /data, /to_device) 
        nxpix = fix(right_pix(0)) - fix(left_pix(0)) 
        i0_nypix = stack_setup_par.i0_plot_toppix - $ 
          stack_setup_par.i0_plot_botpix 
        IF (stack_setup_par.got_i0 NE 0) THEN BEGIN 
            wset, stack_setup_par.i0_plot_win 
            blob = bytarr(nxpix, i0_nypix)+$ 
              stack_setup_par.blue_index 
            tv, blob, fix(left_pix(0)), $ 
              stack_setup_par.i0_plot_botpix, /device 
        ENDIF 
    ENDIF 
 
    IF ( (stack_setup_par.i0_plot_leftpix NE 0) AND $ 
         (stack_setup_par.i0_plot_rightpix NE 0) AND $ 
         (stack_setup_par.i_plot_botpix NE 0) AND $ 
         (stack_setup_par.i_plot_toppix NE 0) ) THEN BEGIN 
        right_pix = convert_coord(stack_setup_par.r2_endev,!y.crange(1), $ 
                                  /data, /to_device) 
        left_pix = convert_coord(stack_setup_par.r1_endev,!y.crange(1), $ 
                                 /data, /to_device) 
        nxpix = fix(right_pix(0)) - fix(left_pix(0)) 
        i_nypix = stack_setup_par.i_plot_toppix-stack_setup_par.i_plot_botpix 
 
        IF (stack_setup_par.got_i NE 0) THEN BEGIN 
            wset, stack_setup_par.i_plot_win 
            blob = bytarr(nxpix,i_nypix)+$ 
              stack_setup_par.blue_index 
            tv,blob,fix(left_pix(0)), $ 
              stack_setup_par.i_plot_botpix,/device 
        ENDIF 
    ENDIF 
 
ENDIF 
 
IF ((stack_setup_par.r3_got_endev NE 0) AND $ 
    (stack_setup_par.r2_got_endev NE 0)) THEN BEGIN 
    IF ( (stack_setup_par.i0_plot_leftpix NE 0) AND $ 
         (stack_setup_par.i0_plot_rightpix NE 0) AND $ 
         (stack_setup_par.i0_plot_botpix NE 0) AND $ 
         (stack_setup_par.i0_plot_toppix NE 0) ) THEN BEGIN 
        wset, stack_setup_par.i0_plot_win 
        right_pix = convert_coord(stack_setup_par.r3_endev,!y.crange(1), $ 
                                  /data, /to_device) 
        left_pix = convert_coord(stack_setup_par.r2_endev,!y.crange(1), $ 
                                 /data, /to_device) 
        nxpix = fix(right_pix(0)) - fix(left_pix(0)) 
        i0_nypix = stack_setup_par.i0_plot_toppix - $ 
          stack_setup_par.i0_plot_botpix 
        IF (stack_setup_par.got_i0 NE 0) THEN BEGIN 
            wset, stack_setup_par.i0_plot_win 
            blob = bytarr(nxpix,i0_nypix)+$ 
              stack_setup_par.red_index 
            tv,blob,fix(left_pix(0)),$ 
              stack_setup_par.i0_plot_botpix,/device 
        ENDIF 
    ENDIF 
 
    IF ( (stack_setup_par.i0_plot_leftpix NE 0) AND $ 
         (stack_setup_par.i0_plot_rightpix NE 0) AND $ 
         (stack_setup_par.i_plot_botpix NE 0) AND $ 
         (stack_setup_par.i_plot_toppix NE 0) ) THEN BEGIN 
        right_pix = convert_coord(stack_setup_par.r3_endev,!y.crange(1), $ 
                                  /data, /to_device) 
        left_pix = convert_coord(stack_setup_par.r2_endev,!y.crange(1), $ 
                                 /data, /to_device) 
        nxpix = fix(right_pix(0)) - fix(left_pix(0)) 
        i_nypix = stack_setup_par.i_plot_toppix-stack_setup_par.i_plot_botpix 
 
        IF (stack_setup_par.got_i NE 0) THEN BEGIN 
            wset, stack_setup_par.i_plot_win 
            blob = bytarr(nxpix,i_nypix)+$ 
              stack_setup_par.red_index 
            tv,blob,fix(left_pix(0)), $ 
              stack_setup_par.i_plot_botpix,/device 
        ENDIF 
    ENDIF 
 
ENDIF 
 
IF ((stack_setup_par.r4_got_endev NE 0) AND $ 
    (stack_setup_par.r3_got_endev NE 0)) THEN BEGIN 
    IF ( (stack_setup_par.i0_plot_leftpix NE 0) AND $ 
         (stack_setup_par.i0_plot_rightpix NE 0) AND $ 
         (stack_setup_par.i0_plot_botpix NE 0) AND $ 
         (stack_setup_par.i0_plot_toppix NE 0) ) THEN BEGIN 
        wset, stack_setup_par.i0_plot_win 
        right_pix = convert_coord(stack_setup_par.r4_endev,!y.crange(1), $ 
                                  /data, /to_device) 
        left_pix = convert_coord(stack_setup_par.r3_endev,!y.crange(1), $ 
                                 /data, /to_device) 
        nxpix = fix(right_pix(0)) - fix(left_pix(0)) 
        i0_nypix = stack_setup_par.i0_plot_toppix - $ 
          stack_setup_par.i0_plot_botpix 
        IF (stack_setup_par.got_i0 NE 0) THEN BEGIN 
            wset, stack_setup_par.i0_plot_win 
            blob = bytarr(nxpix,i0_nypix)+$ 
              stack_setup_par.blue_index 
            tv,blob,fix(left_pix(0)),$ 
              stack_setup_par.i0_plot_botpix,/device 
        ENDIF 
    ENDIF 
 
    IF ( (stack_setup_par.i0_plot_leftpix NE 0) AND $ 
         (stack_setup_par.i0_plot_rightpix NE 0) AND $ 
         (stack_setup_par.i_plot_botpix NE 0) AND $ 
         (stack_setup_par.i_plot_toppix NE 0) ) THEN BEGIN 
        right_pix = convert_coord(stack_setup_par.r4_endev,!y.crange(1), $ 
                                  /data, /to_device) 
        left_pix = convert_coord(stack_setup_par.r3_endev,!y.crange(1), $ 
                                 /data, /to_device) 
        nxpix = fix(right_pix(0)) - fix(left_pix(0)) 
        i_nypix = stack_setup_par.i_plot_toppix-stack_setup_par.i_plot_botpix 
 
        IF (stack_setup_par.got_i NE 0) THEN BEGIN 
            wset, stack_setup_par.i_plot_win 
            blob = bytarr(nxpix,i_nypix)+$ 
              stack_setup_par.blue_index 
            tv,blob,fix(left_pix(0)), $ 
              stack_setup_par.i_plot_botpix,/device 
        ENDIF 
    ENDIF 
 
ENDIF 
 
IF ((stack_setup_par.r5_got_endev NE 0) AND $ 
    (stack_setup_par.r5_got_endev NE 0)) THEN BEGIN 
    IF ( (stack_setup_par.i0_plot_leftpix NE 0) AND $ 
         (stack_setup_par.i0_plot_rightpix NE 0) AND $ 
         (stack_setup_par.i0_plot_botpix NE 0) AND $ 
         (stack_setup_par.i0_plot_toppix NE 0) ) THEN BEGIN 
        wset, stack_setup_par.i0_plot_win 
        right_pix = convert_coord(stack_setup_par.r5_endev,!y.crange(1), $ 
                                  /data, /to_device) 
        left_pix = convert_coord(stack_setup_par.r4_endev,!y.crange(1), $ 
                                 /data, /to_device) 
        nxpix = fix(right_pix(0)) - fix(left_pix(0)) 
        i0_nypix = stack_setup_par.i0_plot_toppix - $ 
          stack_setup_par.i0_plot_botpix 
        IF (stack_setup_par.got_i0 NE 0) THEN BEGIN 
            wset, stack_setup_par.i0_plot_win 
            blob = bytarr(nxpix,i0_nypix)+$ 
              stack_setup_par.red_index 
            tv,blob,fix(left_pix(0)),$ 
              stack_setup_par.i0_plot_botpix,/device 
        ENDIF 
    ENDIF 
 
    IF ( (stack_setup_par.i0_plot_leftpix NE 0) AND $ 
         (stack_setup_par.i0_plot_rightpix NE 0) AND $ 
         (stack_setup_par.i_plot_botpix NE 0) AND $ 
         (stack_setup_par.i_plot_toppix NE 0) ) THEN BEGIN 
        right_pix = convert_coord(stack_setup_par.r5_endev, !Y.crange(1), $ 
                                  /data, /to_device) 
        left_pix = convert_coord(stack_setup_par.r4_endev, !Y.crange(1), $ 
                                 /data, /to_device) 
        nxpix = fix(right_pix(0)) - fix(left_pix(0)) 
        i_nypix = stack_setup_par.i_plot_toppix-stack_setup_par.i_plot_botpix 
 
        IF (stack_setup_par.got_i NE 0) THEN BEGIN 
            wset, stack_setup_par.i_plot_win 
            blob = bytarr(nxpix, i_nypix)+$ 
              stack_setup_par.red_index 
            tv, blob, fix(left_pix(0)), $ 
              stack_setup_par.i_plot_botpix, /device 
        ENDIF 
    ENDIF 
 
ENDIF 
 
wset, stack_setup_par.i_plot_win 
IF ( (stack_setup_par.got_i NE 0) AND $ 
     (stack_setup_par.got_i0 NE 0) ) THEN BEGIN 
    abs = -alog(i_khz/i0_khz) 
    plot, i_ev, abs, $ 
      xtitle = 'eV', ytitle = '-alog(I/I0)', $ 
      title = 'I: '+i_filename, /noerase 
    top_pix = convert_coord(!X.crange(0), !Y.crange(1), $ 
                            /data, /to_device) 
    stack_setup_par.i_plot_toppix = fix(top_pix(1)) 
    bot_pix = convert_coord(!X.crange(0), !Y.crange(0), $ 
                            /data, /to_device) 
    stack_setup_par.i_plot_botpix = fix(bot_pix(1)) 
ENDIF ELSE IF (stack_setup_par.got_i NE 0) THEN BEGIN 
    plot, i_ev, i_khz, $ 
      xtitle = 'eV', ytitle = 'I kHz', $ 
      title = 'I: '+i_filename, /noerase 
    top_pix = convert_coord(!X.crange(0), !Y.crange(1), $ 
                            /data, /to_device) 
    stack_setup_par.i_plot_toppix = fix(top_pix(1)) 
    bot_pix = convert_coord(!X.crange(0), !Y.crange(0), $ 
                            /data, /to_device) 
    stack_setup_par.i_plot_botpix = fix(bot_pix(1)) 
ENDIF 
 
wset, stack_setup_par.i0_plot_win 
IF (stack_setup_par.got_i0 NE 0) THEN BEGIN 
    plot_io, i0_ev, i0_counts, $ 
      xtitle = 'eV', $ 
      ytitle = 'I0 counts / '+$ 
      strtrim(string(stack_setup_par.i0_msec_dwell, format = '(i6)'), 2)+$ 
      ' msec', $ 
      title = 'I0: '+i0_filename, /noerase 
    top_pix = convert_coord(!X.crange(0), 10.^!Y.crange(1), $ 
                            /data, /to_device) 
    stack_setup_par.i0_plot_leftpix = fix(top_pix(0)) 
    stack_setup_par.i0_plot_toppix = fix(top_pix(1)) 
    bot_pix = convert_coord(!X.crange(1), 10.^!Y.crange(0), $ 
                            /data, /to_device) 
    stack_setup_par.i0_plot_rightpix = fix(bot_pix(0)) 
    stack_setup_par.i0_plot_botpix = fix(bot_pix(1)) 
ENDIF 
 
return 
END 
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
 
PRO stack_setup_event, event 
 
@bsif_com 
@stxm_common 
@camac_common 
 
COMMON Stack_setup_common, stack_setup_par, stack_strlen, $ 
  i_ev, i_khz, i_filename, i0_ev, i0_khz, i0_filename, i0_counts, $ 
  template_filename, sd_template, ev_list, msec_list, z_list, header 
 
CASE event.id OF 
    Stack_setup_par.stxm_template_label: BEGIN 
        wset, stack_setup_par.i_plot_win 
        temp_string = '' 
        widget_control, stack_setup_par.stxm_template_label, $ 
          get_value = temp_string 
        template_filename = temp_string(0) 
        n_cols = 0 
        read_stxm, template_filename, sd 
        stack_setup_par.got_template = 0 
        IF (n_cols EQ 0) THEN BEGIN 
            erase 
            xyouts, 0.1, 0.5, /norm, $ 
              'File "'+i_filename+'" not found' 
        ENDIF ELSE BEGIN 
            stack_setup_par.got_template = 1 
            sd_template = sd 
            widget_control, stack_setup_par.xpix_label, $ 
              set_value = strtrim(string(sd_template.scan_width),2) 
            widget_control, stack_setup_par.ypix_label, $ 
              set_value = strtrim(string(sd_template.scan_height),2) 
        ENDELSE 
    END 
 
    Stack_setup_par.header_label: BEGIN 
        temp_string = '' 
        widget_control, stack_setup_par.header_label, $ 
          get_value = temp_string 
        header = temp_string(0) 
        widget_control, stack_setup_par.header_label, $ 
          set_value = strtrim(header,2) 
        stack_setup_par.got_header = 1 
    END 
 
    Stack_setup_par.firstfile_num_label: BEGIN 
        temp_string = '' 
        widget_control, stack_setup_par.firstfile_num_label, $ 
          get_value = temp_string 
        on_ioerror, firstfile_num_oops 
        temp_value = 0 
        reads,temp_string(0),temp_value 
        stack_setup_par.firstfile_num = temp_value 
        stack_setup_par.got_firstfile_num = 1 
        firstfile_num_oops: 
        widget_control, stack_setup_par.firstfile_num_label, $ 
          set_value = strtrim(string(stack_setup_par.firstfile_num),2) 
    END 
 
    Stack_setup_par.i_stxm_label: BEGIN 
        wset, stack_setup_par.i_plot_win 
        temp_string = '' 
        widget_control, stack_setup_par.i_stxm_label, $ 
          get_value = temp_string 
        i_filename = temp_string(0) 
        n_cols = 0 
        read_stxm, i_filename, sd 
        stack_setup_par.got_i = 0 
        IF (n_cols EQ 0) THEN BEGIN 
            erase 
            xyouts, 0.1, 0.5, /norm, $ 
              'File "'+i_filename+'" not found' 
        ENDIF ELSE IF (sd.scan_driver_mode NE 4) THEN BEGIN 
            erase 
            xyouts, 0.1, 0.5, /norm, $ 
              'File "'+i_filename+'" is not a spectrum file' 
        ENDIF ELSE BEGIN 
            stack_setup_par.got_i = 1 
            angstroms = sd.initial_lambda + $ 
              (sd.final_lambda-sd.initial_lambda)*$ 
              findgen(sd.scan_width)/float(sd.scan_width-1) 
            i_ev = 12398.52/angstroms 
            i_khz = sd.clock_frequency*image_data(*, *, 0) / $ 
              float(image_data(*, *, 1)) 
            stack_setup_plots 
        ENDELSE 
    END 
 
    Stack_setup_par.i0_stxm_label: BEGIN 
        wset, stack_setup_par.i_plot_win 
        temp_string = '' 
        widget_control, stack_setup_par.i0_stxm_label, $ 
          get_value = temp_string 
        i0_filename = temp_string(0) 
        n_cols = 0 
        read_stxm, i0_filename, sd 
        stack_setup_par.got_i0 = 0 
        IF (n_cols EQ 0) THEN BEGIN 
            erase 
            xyouts, 0.1, 0.5, /norm, $ 
              'File "'+i0_filename+'" not found' 
        ENDIF ELSE IF (sd.scan_driver_mode NE 4) THEN BEGIN 
            erase 
            xyouts, 0.1, 0.5, /norm, $ 
              'File "'+i0_filename+'" is not a spectrum file' 
        ENDIF ELSE BEGIN 
            stack_setup_par.got_i0 = 1 
            angstroms = sd.initial_lambda + $ 
              (sd.final_lambda-sd.initial_lambda)*$ 
              findgen(sd.scan_width)/float(sd.scan_width-1) 
            i0_ev = 12398.52/angstroms 
            stack_setup_par.i0_msec_dwell = sd.dwell_time 
            i0_counts = image_data(*,*,0) 
            i0_khz = sd.clock_frequency*image_data(*, *, 0) / $ 
              float(image_data(*, *, 1)) 
            stack_setup_plots 
        ENDELSE 
    END 
 
    Stack_setup_par.i_plot_label: BEGIN 
        wset, stack_setup_par.i_plot_win 
        IF (fix(event.press) EQ 1) THEN BEGIN 
            IF ( (stack_setup_par.got_i NE 0) OR $ 
                 (stack_setup_par.got_i0 NE 0) ) THEN BEGIN 
                plot_units = convert_coord(event.x, event.y, $ 
                                           /device, /to_data) 
                stack_setup_par.mouse_ev = plot_units(0) 
                widget_control, stack_setup_par.mouseev_label, $ 
                  set_value = strtrim(string(stack_setup_par.mouse_ev,$ 
                                             format='(f10.2)'),2)+' eV' 
            ENDIF 
        ENDIF 
    END 
 
    Stack_setup_par.i0_plot_label: BEGIN 
        wset, stack_setup_par.i0_plot_win 
        IF (fix(event.press) EQ 1) THEN BEGIN 
            IF ( (stack_setup_par.got_i NE 0) OR $ 
                 (stack_setup_par.got_i0 NE 0) ) THEN BEGIN 
                plot_units = convert_coord(event.x, event.y, $ 
                                           /device, /to_data) 
                stack_setup_par.mouse_ev = plot_units(0) 
                widget_control, stack_setup_par.mouseev_label, $ 
                  set_value = strtrim(string(stack_setup_par.mouse_ev, $ 
                                             format = '(f10.2)'), 2)+' eV' 
            ENDIF 
        ENDIF 
    END 
 
    Stack_setup_par.r1_endev_label: BEGIN 
        temp_string = '' 
        widget_control, stack_setup_par.r1_endev_label, $ 
          get_value = temp_string 
        ON_IOERROR, r1_endev_label_oops 
        this_value = 0. 
        reads, temp_string(0), this_value 
        IF (stack_setup_par.got_i0 NE 0) THEN BEGIN 
            dummy = min(abs(i0_ev-this_value), index) 
            stack_setup_par.r1_endev = i0_ev(index) 
        ENDIF ELSE BEGIN 
            stack_setup_par.r1_endev = this_value 
        ENDELSE 
        stack_setup_par.r1_got_endev = 1 
        R1_endev_label_oops: 
        stack_setup_update 
        stack_setup_plots 
    END 
 
    Stack_setup_par.r1_deltaev_label: BEGIN 
        temp_string = '' 
        widget_control, stack_setup_par.r1_deltaev_label, $ 
          get_value = temp_string 
        on_ioerror, r1_deltaev_label_oops 
        this_value = 0. 
        reads,temp_string(0),this_value 
        stack_setup_par.r1_deltaev = this_value 
        stack_setup_par.r1_got_deltaev = 1 
        r1_deltaev_label_oops: 
        stack_setup_update 
    END 
 
    stack_setup_par.r1_msec_label: BEGIN 
        temp_string = '' 
        widget_control, stack_setup_par.r1_msec_label, $ 
          get_value = temp_string 
        on_ioerror, r1_msec_label_oops 
        this_value = 0. 
        reads,temp_string(0),this_value 
        stack_setup_par.r1_msec = this_value 
        stack_setup_par.r1_got_msec = 1 
        r1_msec_label_oops: 
        stack_setup_update 
    END 
 
    stack_setup_par.r1_define_label: BEGIN 
        IF (stack_setup_par.got_i0 NE 0) THEN BEGIN 
            dummy = min(abs(i0_ev-stack_setup_par.mouse_ev),index) 
            stack_setup_par.r1_endev = i0_ev(index) 
        ENDIF ELSE BEGIN 
            stack_setup_par.r1_endev = stack_setup_par.mouse_ev 
        ENDELSE 
        stack_setup_par.r1_got_endev = 1 
        stack_setup_update 
        stack_setup_plots 
    END 
 
    stack_setup_par.r2_endev_label: BEGIN 
        temp_string = '' 
        widget_control, stack_setup_par.r2_endev_label, $ 
          get_value = temp_string 
        on_ioerror, r2_endev_label_oops 
        this_value = 0. 
        reads,temp_string(0),this_value 
        IF (stack_setup_par.got_i0 NE 0) THEN BEGIN 
            dummy = min(abs(i0_ev-this_value),index) 
            stack_setup_par.r2_endev = i0_ev(index) 
        ENDIF ELSE BEGIN 
            stack_setup_par.r2_endev = this_value 
        ENDELSE 
        stack_setup_par.r2_got_endev = 1 
        r2_endev_label_oops: 
        stack_setup_update 
        stack_setup_plots 
    END 
 
    stack_setup_par.r2_deltaev_label: BEGIN 
        temp_string = '' 
        widget_control, stack_setup_par.r2_deltaev_label, $ 
          get_value = temp_string 
        on_ioerror, r2_deltaev_label_oops 
        this_value = 0. 
        reads,temp_string(0),this_value 
        stack_setup_par.r2_deltaev = this_value 
        stack_setup_par.r2_got_deltaev = 1 
        r2_deltaev_label_oops: 
        stack_setup_update 
    END 
 
    stack_setup_par.r2_msec_label: BEGIN 
        temp_string = '' 
        widget_control, stack_setup_par.r2_msec_label, $ 
          get_value = temp_string 
        on_ioerror, r2_msec_label_oops 
        this_value = 0. 
        reads,temp_string(0),this_value 
        stack_setup_par.r2_msec = this_value 
        stack_setup_par.r2_got_msec = 1 
        r2_msec_label_oops: 
        stack_setup_update 
    END 
 
    stack_setup_par.r2_define_label: BEGIN 
        IF (stack_setup_par.got_i0 NE 0) THEN BEGIN 
            dummy = min(abs(i0_ev-stack_setup_par.mouse_ev),index) 
            stack_setup_par.r2_endev = i0_ev(index) 
        ENDIF ELSE BEGIN 
            stack_setup_par.r2_endev = stack_setup_par.mouse_ev 
        ENDELSE 
        stack_setup_par.r2_got_endev = 1 
        stack_setup_update 
        stack_setup_plots 
    END 
 
    stack_setup_par.r3_endev_label: BEGIN 
        temp_string = '' 
        widget_control, stack_setup_par.r3_endev_label, $ 
          get_value = temp_string 
        on_ioerror, r3_endev_label_oops 
        this_value = 0. 
        reads,temp_string(0),this_value 
        IF (stack_setup_par.got_i0 NE 0) THEN BEGIN 
            dummy = min(abs(i0_ev-this_value),index) 
            stack_setup_par.r3_endev = i0_ev(index) 
        ENDIF ELSE BEGIN 
            stack_setup_par.r3_endev = this_value 
        ENDELSE 
        stack_setup_par.r3_got_endev = 1 
        r3_endev_label_oops: 
        stack_setup_update 
        stack_setup_plots 
    END 
 
    stack_setup_par.r3_deltaev_label: BEGIN 
        temp_string = '' 
        widget_control, stack_setup_par.r3_deltaev_label, $ 
          get_value = temp_string 
        on_ioerror, r3_deltaev_label_oops 
        this_value = 0. 
        reads,temp_string(0),this_value 
        stack_setup_par.r3_deltaev = this_value 
        stack_setup_par.r3_got_deltaev = 1 
        r3_deltaev_label_oops: 
        stack_setup_update 
    END 
 
    stack_setup_par.r3_msec_label: BEGIN 
        temp_string = '' 
        widget_control, stack_setup_par.r3_msec_label, $ 
          get_value = temp_string 
        on_ioerror, r3_msec_label_oops 
        this_value = 0. 
        reads,temp_string(0),this_value 
        stack_setup_par.r3_msec = this_value 
        stack_setup_par.r3_got_msec = 1 
        r3_msec_label_oops: 
        stack_setup_update 
    END 
 
    stack_setup_par.r3_define_label: BEGIN 
        IF (stack_setup_par.got_i0 NE 0) THEN BEGIN 
            dummy = min(abs(i0_ev-stack_setup_par.mouse_ev),index) 
            stack_setup_par.r3_endev = i0_ev(index) 
        ENDIF ELSE BEGIN 
            stack_setup_par.r3_endev = stack_setup_par.mouse_ev 
        ENDELSE 
        stack_setup_par.r3_got_endev = 1 
        stack_setup_update 
        stack_setup_plots 
    END 
 
    stack_setup_par.r4_endev_label: BEGIN 
        temp_string = '' 
        widget_control, stack_setup_par.r4_endev_label, $ 
          get_value = temp_string 
        on_ioerror, r4_endev_label_oops 
        this_value = 0. 
        reads,temp_string(0),this_value 
        IF (stack_setup_par.got_i0 NE 0) THEN BEGIN 
            dummy = min(abs(i0_ev-this_value),index) 
            stack_setup_par.r4_endev = i0_ev(index) 
        ENDIF ELSE BEGIN 
            stack_setup_par.r4_endev = this_value 
        ENDELSE 
        stack_setup_par.r4_got_endev = 1 
        r4_endev_label_oops: 
        stack_setup_update 
        stack_setup_plots 
    END 
 
    stack_setup_par.r4_deltaev_label: BEGIN 
        temp_string = '' 
        widget_control, stack_setup_par.r4_deltaev_label, $ 
          get_value = temp_string 
        on_ioerror, r4_deltaev_label_oops 
        this_value = 0. 
        reads,temp_string(0),this_value 
        stack_setup_par.r4_deltaev = this_value 
        stack_setup_par.r4_got_deltaev = 1 
        r4_deltaev_label_oops: 
        stack_setup_update 
    END 
 
    stack_setup_par.r4_msec_label: BEGIN 
        temp_string = '' 
        widget_control, stack_setup_par.r4_msec_label, $ 
          get_value = temp_string 
        on_ioerror, r4_msec_label_oops 
        this_value = 0. 
        reads,temp_string(0),this_value 
        stack_setup_par.r4_msec = this_value 
        stack_setup_par.r4_got_msec = 1 
        r4_msec_label_oops: 
        stack_setup_update 
    END 
 
    stack_setup_par.r4_define_label: BEGIN 
        IF (stack_setup_par.got_i0 NE 0) THEN BEGIN 
            dummy = min(abs(i0_ev-stack_setup_par.mouse_ev),index) 
            stack_setup_par.r4_endev = i0_ev(index) 
        ENDIF ELSE BEGIN 
            stack_setup_par.r4_endev = stack_setup_par.mouse_ev 
        ENDELSE 
        stack_setup_par.r4_got_endev = 1 
        stack_setup_update 
        stack_setup_plots 
    END 
 
    stack_setup_par.r5_endev_label: BEGIN 
        temp_string = '' 
        widget_control, stack_setup_par.r5_endev_label, $ 
          get_value = temp_string 
        on_ioerror, r5_endev_label_oops 
        this_value = 0. 
        reads,temp_string(0),this_value 
        IF (stack_setup_par.got_i0 NE 0) THEN BEGIN 
            dummy = min(abs(i0_ev-this_value),index) 
            stack_setup_par.r5_endev = i0_ev(index) 
        ENDIF ELSE BEGIN 
            stack_setup_par.r5_endev = this_value 
        ENDELSE 
        stack_setup_par.r5_got_endev = 1 
        r5_endev_label_oops: 
        stack_setup_update 
        stack_setup_plots 
    END 
 
    stack_setup_par.r5_deltaev_label: BEGIN 
        temp_string = '' 
        widget_control, stack_setup_par.r5_deltaev_label, $ 
          get_value = temp_string 
        on_ioerror, r5_deltaev_label_oops 
        this_value = 0. 
        reads,temp_string(0),this_value 
        stack_setup_par.r5_deltaev = this_value 
        stack_setup_par.r5_got_deltaev = 1 
        r5_deltaev_label_oops: 
        stack_setup_update 
    END 
 
    stack_setup_par.r5_msec_label: BEGIN 
        temp_string = '' 
        widget_control, stack_setup_par.r5_msec_label, $ 
          get_value = temp_string 
        on_ioerror, r5_msec_label_oops 
        this_value = 0. 
        reads,temp_string(0),this_value 
        stack_setup_par.r5_msec = this_value 
        stack_setup_par.r5_got_msec = 1 
        r5_msec_label_oops: 
        stack_setup_update 
    END 
 
    stack_setup_par.r5_define_label: BEGIN 
        IF (stack_setup_par.got_i0 NE 0) THEN BEGIN 
            dummy = min(abs(i0_ev-stack_setup_par.mouse_ev),index) 
            stack_setup_par.r5_endev = i0_ev(index) 
        ENDIF ELSE BEGIN 
            stack_setup_par.r5_endev = stack_setup_par.mouse_ev 
        ENDELSE 
        stack_setup_par.r5_got_endev = 1 
        stack_setup_update 
        stack_setup_plots 
    END 
 
    stack_setup_par.zp_d_label: BEGIN 
        temp_string = '' 
        widget_control, stack_setup_par.zp_d_label, $ 
          get_value = temp_string 
        on_ioerror, zp_d_label_oops 
        this_value = 0. 
        reads,temp_string(0),this_value 
        stack_setup_par.zp_d_um = this_value 
        stack_setup_par.got_zp_d = 1 
        zp_d_label_oops: 
        stack_setup_update 
    END 
 
    stack_setup_par.zp_drn_label: BEGIN 
        temp_string = '' 
        widget_control, stack_setup_par.zp_drn_label, $ 
          get_value = temp_string 
        ON_IOERROR, zp_drn_label_oops 
        this_value = 0. 
        reads,temp_string(0),this_value 
        stack_setup_par.zp_drn_nm = this_value 
        stack_setup_par.got_zp_drn = 1 
        zp_drn_label_oops: 
        stack_setup_update 
    END 
 
    Stack_setup_par.doit_label: BEGIN 
        widget_control, stack_setup_par.main_base, /destroy 
 
        pzt_mode = 1 
        stepper_mode = 2 
        focus_mode = 3 
        sgm_mode = 4 
        scan_mode = ['ILLEGAL', 'PZT', 'Stepper', 'Focus', 'SGM'] 
        text_height = 20 
        spacer = 4 
 
        print, 'Running STXM_INIT' 
        stxm_init 
        print, 'Running STXM_STARTUP' 
        stxm_startup,'' 
        sd.auto_shutter = -1 
 
        print, 'Reading template file "'+template_filename+'"' 
        read_stxm, template_filename, sd 
        IF ((sd.scan_driver_mode EQ sgm_mode) OR $ 
            (sd.scan_driver_mode EQ focus_mode)) THEN BEGIN 
            message, 'Do not acquire stacks of '+$ 
              scan_mode(sd.scan_driver_mode)+' scans' 
            return 
        ENDIF 
 
        window, 0, xsize = n_cols, ysize = n_rows+text_height+2*spacer 
        cvec = byte(indgen(!D.table_size)) 
        tvlct, cvec, cvec, cvec 
 
        get_mot_pos, x_motor, motx_position 
        md.motx_position = motx_position 
        get_mot_pos, y_motor, moty_position 
        md.moty_position = moty_position 
        get_mot_pos, z_motor, motz_position 
        md.motz_position = motz_position 
 
        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
        n_images = n_elements(ev_list) 
        FOR i = 0, (n_images-1) DO BEGIN 
            file_num = stack_setup_par.firstfile_num + i 
 
            print, 'Now doing '+scan_mode(sd.scan_driver_mode)+$ 
              ' scan '+strtrim(string(i+1), 2)+' of '+$ 
              strtrim(string(n_images), 2) 
 
            this_z_pos = z_list(i) 
 
            ;; find the actual angstroms and eV corresponding 
            ;; to this step position 
            sgm_convert, ev_list(i), this_sgm_o_step, /out, $ 
              from = 'eV', to = 'step' 
            sgm_convert, this_sgm_o_step, this_angstroms, /out, $ 
              from = 'step', to = 'angstroms' 
            sgm_convert, this_sgm_o_step, this_ev, /out, $ 
              from = 'step', to = 'ev' 
 
            move_motor_to, sgm_o_motor, this_sgm_o_step 
            move_motor_to, z_motor, this_z_pos 
 
            sd.focus_position = this_z_pos 
            sd.z_center = this_z_pos 
            sd.z_start = this_z_pos 
            sd.z_stop = this_z_pos 
 
            sd.wavelength = this_angstroms 
            sd.initial_lambda = this_angstroms 
            sd.final_lambda = this_angstroms 
            sd.dwell_time = msec_list(i) 
 
            this_num_string = strtrim(string(file_num), 2) 
            IF (strlen(this_num_string) EQ 1) THEN BEGIN 
                this_num_string = '00'+this_num_string 
            ENDIF ELSE IF (strlen(this_num_string) EQ 2) THEN BEGIN 
                this_num_string = '0'+this_num_string 
            ENDIF 
            filename = header+this_num_string+'.nc' 
            sd.file_name = byte(filename) 
 
            print, 'Waiting for SGM_O and MIC_Z motors to '+$ 
              'reach starting positions' 
            motor_wait, sgm_o_motor 
            motor_wait, z_motor 
            print, '  Starting '+$ 
              strtrim(string(sd.dwell_time, format = '(i6)'), 2)+$ 
              ' msec/pixel scan at '+$ 
              strtrim(string(this_ev, format = '(f10.2)'), 2)+$ 
              ' eV with Z = '+$ 
              strtrim(string(z_list(i), format = '(f10.1)'), 2)+' microns.' 
 
            scan_status.image_row = 0 
            open_shutter 
            stxm_scan, /nowidgets 
 
            keep_going = 1 
            WHILE (keep_going EQ 1) DO BEGIN 
                wait, 5. 
                print, '    Now on row '+$ 
                  strtrim(string(sb.last_valid_row), 2)+$ 
                  ' of '+strtrim(string(sb.ny), 2) 
                IF (sb.scan_status EQ SCAN_COMPLETE) THEN BEGIN 
                    IF (sb.last_valid_row EQ (sb.ny-1)) THEN BEGIN 
                        keep_going = 0 
                    ENDIF 
                ENDIF 
            ENDWHILE 
            close_shutter 
 
            ;; OK, if we get here the scan is done.  This is basically 
            ;; copied from get_info.pro 
            ;; done above! filename = strtrim(string(sd.file_name)) 
            image_title = string(sd.sample) 
            data_title = ['Transmitted intensity', $ 
                          'Clock pulses'] 
            IF ((sd.scan_driver_mode EQ sgm_mode) OR $ 
                (sd.scan_driver_mode EQ focus_mode)) THEN BEGIN 
                message, 'Confusion: sgm or focus scan mode?' 
                return 
            ENDIF 
            x_start = sd.x_start 
            x_stop = sd.x_stop 
            y_start = sd.y_start 
            y_stop = sd.y_stop 
            x_title = 'Horizontal scan position (microns)' 
            y_title = 'Vertical scan position (microns)' 
 
            user_buffer_len = n_tags(sd, /length) 
            user_buffer = bytarr(user_buffer_len) 
            copy_bytes, user_buffer_len, sd, user_buffer 
            write_stxm, filename, sd 
            print, '    Wrote file "'+filename+'", and now displaying it' 
 
            erase 
            tv, bytscl(image_data(*, *, 0)/float(image_data(*, *, 1)), $ 
                       top = !D.table_size-1), $ 
              0, text_height+2*spacer, /device 
            xyouts, spacer, spacer, filename, /device 
        ENDFOR 
 
    END 
 
    Stack_setup_par.exit_label: BEGIN 
        widget_control, stack_setup_par.main_base, /destroy 
    END 
ENDCASE 
END 
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
 
PRO stack_setup 
 
@bsif_com 
 
COMMON Stack_setup_common, stack_setup_par, stack_strlen, $ 
  i_ev, i_khz, i_filename, i0_ev, i0_khz, i0_filename, i0_counts, $ 
  template_filename, sd_template, ev_list, msec_list, z_list, header 
 
stack_strlen = 128 
IF (n_tags(stack_setup_par) EQ 0) THEN BEGIN 
    stack_setup_par = $ 
      { stack_setup_par, $ 
        Main_base: 0L, $ 
        Stxm_template_label: 0L, $ 
        Got_template: 0L, $ 
        I_stxm_label: 0L, $ 
        Got_i: 0L, $ 
        I0_stxm_label: 0L, $ 
        Got_i0: 0L, $ 
        R1_endev_label: 0L, $ 
        R1_deltaev_label: 0L, $ 
        R1_msec_label: 0L, $ 
        R1_define_label: 0L, $ 
        R1_got_endev: 0L, $ 
        R1_got_deltaev: 0L, $ 
        R1_got_msec: 0L, $ 
        R1_endev: 0., $ 
        R1_deltaev: 0., $ 
        R1_msec: 0., $ 
        R2_endev_label: 0L, $ 
        R2_deltaev_label: 0L, $ 
        R2_msec_label: 0L, $ 
        R2_define_label: 0L, $ 
        R2_got_endev: 0L, $ 
        R2_got_deltaev: 0L, $ 
        R2_got_msec: 0L, $ 
        R2_endev: 0., $ 
        R2_deltaev: 0., $ 
        R2_msec: 0., $ 
        R3_endev_label: 0L, $ 
        R3_deltaev_label: 0L, $ 
        R3_msec_label: 0L, $ 
        R3_define_label: 0L, $ 
        R3_got_endev: 0L, $ 
        R3_got_deltaev: 0L, $ 
        R3_got_msec: 0L, $ 
        R3_endev: 0., $ 
        R3_deltaev: 0., $ 
        R3_msec: 0., $ 
        R4_endev_label: 0L, $ 
        R4_deltaev_label: 0L, $ 
        R4_msec_label: 0L, $ 
        R4_define_label: 0L, $ 
        R4_got_endev: 0L, $ 
        R4_got_deltaev: 0L, $ 
        R4_got_msec: 0L, $ 
        R4_endev: 0., $ 
        R4_deltaev: 0., $ 
        R4_msec: 0., $ 
        R5_endev_label: 0L, $ 
        R5_deltaev_label: 0L, $ 
        R5_msec_label: 0L, $ 
        R5_define_label: 0L, $ 
        R5_got_endev: 0L, $ 
        R5_got_deltaev: 0L, $ 
        R5_got_msec: 0L, $ 
        R5_endev: 0., $ 
        R5_deltaev: 0., $ 
        R5_msec: 0., $ 
        mouseev_label: 0L, $ 
        mouse_ev: 0., $ 
        xpix_label: 0L, $ 
        ypix_label: 0L, $ 
        Total_hours_label: 0L, $ 
        zp_d_label: 0L, $ 
        got_zp_d: 0L, $ 
        zp_d_um: 0., $ 
        zp_drn_label: 0L, $ 
        got_zp_drn: 0L, $ 
        zp_drn_nm: 0., $ 
        Z_min_label: 0L, $ 
        Z_max_label: 0L, $ 
        Ev_min_label: 0L, $ 
        Ev_max_label: 0L, $ 
        header_label: 0L, $ 
        got_header: 0L, $ 
        firstfile_num_label: 0L, $ 
        got_firstfile_num: 0L, $ 
        firstfile_num: 0L, $ 
        Doit_label: 0L, $ 
        Exit_label: 0L, $ 
        i_plot_label: 0L, $ 
        i0_plot_label: 0L, $ 
        I_plot_win: 0L, $ 
        I0_plot_win: 0L, $ 
        i_plot_botpix: 0L, $ 
        i_plot_toppix: 0L, $ 
        i0_plot_botpix: 0L, $ 
        i0_plot_toppix: 0L, $ 
        i0_plot_leftpix: 0L, $ 
        i0_plot_rightpix: 0L, $ 
        i0_msec_dwell: 0., $ 
        Plot_ncols: 500L, $ 
        Plot_nrows: 300L, $ 
        Rvec: bytarr(4), $ 
        Gvec: bytarr(4), $ 
        Bvec: bytarr(4), $ 
        Red_index: 2L, $ 
        Blue_index: 3L, $ 
        I_filename: bytarr(stack_strlen), $ 
        I0_filename: bytarr(stack_strlen) $ 
    } 
ENDIF 
 
stack_setup_par.got_i = 0 
stack_setup_par.got_i0 = 0 
stack_setup_par.got_template = 0 
stack_setup_par.got_zp_d = 0 
stack_setup_par.got_zp_drn = 0 
stack_setup_par.r1_got_endev = 0 
stack_setup_par.r2_got_endev = 0 
stack_setup_par.r3_got_endev = 0 
stack_setup_par.r4_got_endev = 0 
stack_setup_par.r5_got_endev = 0 
stack_setup_par.got_header = 0 
stack_setup_par.got_firstfile_num = 0 
 
stack_setup_par.rvec = byte([0, 255, 100, 0]) 
stack_setup_par.gvec = byte([0, 255, 0, 0]) 
stack_setup_par.bvec = byte([0, 255, 0, 100]) 
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
 
stack_setup_par.main_base = widget_base(title='Stack', /row ) 
col1 = widget_base(stack_setup_par.main_base,/frame,/column) 
col2 = widget_base(stack_setup_par.main_base,/frame,/column) 
 
 
label = widget_label( col1, value='STXM template image:' ) 
stack_setup_par.stxm_template_label = $ 
  widget_text( col1, /editable, /frame, xsize=35 ) 
 
row = widget_base( col1, /row ) 
label = widget_label( row, value = 'File header: ') 
stack_setup_par.header_label = $ 
  widget_text( row, value='',xsize=10,/frame,/editable) 
label = widget_label( row, value = 'First filenum: ') 
stack_setup_par.firstfile_num_label = $ 
  widget_text( row, value='',xsize=10,/frame,/editable) 
 
label = widget_label( col1, value='STXM I file:' ) 
stack_setup_par.i_stxm_label = $ 
  widget_text( col1, /editable, /frame, xsize=35 ) 
label = widget_label( col1, value='STXM I0 file:' ) 
stack_setup_par.i0_stxm_label = $ 
  widget_text( col1, /editable, /frame, xsize=35 ) 
 
row = widget_base( col1, /row, /frame) 
col = widget_base( row, /column) 
label = widget_label(col, value='#') 
label = widget_text(col, value='1',/frame,xsize=3) 
label = widget_text(col, value='2',/frame,xsize=3) 
label = widget_text(col, value='3',/frame,xsize=3) 
label = widget_text(col, value='4',/frame,xsize=3) 
label = widget_text(col, value='5',/frame,xsize=3) 
col = widget_base( row, /column) 
label = widget_label(col, value = 'End eV') 
stack_setup_par.r1_endev_label = $ 
  widget_text(col, value = '', /editable, /frame, xsize = 10) 
stack_setup_par.r2_endev_label = $ 
  widget_text(col, value = '', /editable, /frame, xsize = 10) 
stack_setup_par.r3_endev_label = $ 
  widget_text(col, value = '', /editable, /frame, xsize = 10) 
stack_setup_par.r4_endev_label = $ 
  widget_text(col, value = '', /editable, /frame, xsize = 10) 
stack_setup_par.r5_endev_label = $ 
  widget_text(col, value = '', /editable, /frame, xsize = 10) 
col = widget_base( row, /column) 
label = widget_label(col, value = 'Delta eV') 
stack_setup_par.r1_deltaev_label = $ 
  widget_text(col, value = '', /editable, /frame, xsize = 10) 
stack_setup_par.r2_deltaev_label = $ 
  widget_text(col, value = '', /editable, /frame, xsize = 10) 
stack_setup_par.r3_deltaev_label = $ 
  widget_text(col, value = '', /editable, /frame, xsize = 10) 
stack_setup_par.r4_deltaev_label = $ 
  widget_text(col, value = '', /editable, /frame, xsize = 10) 
stack_setup_par.r5_deltaev_label = $ 
  widget_text(col, value = '', /editable, /frame, xsize = 10) 
col = widget_base( row, /column) 
label = widget_label(col, value = 'Msec') 
stack_setup_par.r1_msec_label = $ 
  widget_text(col, value = '', /editable, /frame, xsize = 10) 
stack_setup_par.r2_msec_label = $ 
  widget_text(col, value='',/editable,/frame,xsize=10) 
stack_setup_par.r3_msec_label = $ 
  widget_text(col, value = '', /editable, /frame, xsize = 10) 
stack_setup_par.r4_msec_label = $ 
  widget_text(col, value = '', /editable, /frame, xsize = 10) 
stack_setup_par.r5_msec_label = $ 
  widget_text(col, value = '', /editable, /frame, xsize = 10) 
col = widget_base( row, /column) 
label = widget_label(col, value = 'Define?') 
stack_setup_par.r1_define_label = $ 
  widget_button(col, value = 'Define 1', /frame) 
stack_setup_par.r2_define_label = $ 
  widget_button(col, value = 'Define 2', /frame) 
stack_setup_par.r3_define_label = $ 
  widget_button(col, value = 'Define 3', /frame) 
stack_setup_par.r4_define_label = $ 
  widget_button(col, value = 'Define 4', /frame) 
stack_setup_par.r5_define_label = $ 
  widget_button(col, value = 'Define 5', /frame) 
 
row = widget_base( col1, /row ) 
label = widget_label( row, value = 'Mouse click eV: ') 
stack_setup_par.mouseev_label = $ 
  widget_text( row, value = '', xsize = 10) 
 
row = widget_base( col1, /row ) 
label = widget_label( row, value = 'Image rows: ') 
stack_setup_par.ypix_label = $ 
  widget_text( row, value = '', xsize = 4) 
label = widget_label( row, value = 'columns: ') 
stack_setup_par.xpix_label = $ 
  widget_text( row, value = '', xsize = 4) 
 
row = widget_base( col1, /row ) 
label = widget_label( row, value = 'ZP d (um): ') 
stack_setup_par.zp_d_label = $ 
  widget_text( row, value = '', xsize = 10, /frame, /editable) 
label = widget_label( row, value = 'ZP drn (nm): ') 
stack_setup_par.zp_drn_label = $ 
  widget_text( row, value = '', xsize = 10, /frame, /editable) 
 
row = widget_base( col1, /row ) 
label = widget_label( row, value = 'eV range: ') 
stack_setup_par.ev_min_label = $ 
  widget_text( row, value = '', xsize = 10) 
stack_setup_par.ev_max_label = $ 
  widget_text( row, value = '', xsize = 10) 
 
row = widget_base( col1, /row ) 
label = widget_label( row, value = 'MIC Z range: ') 
stack_setup_par.z_min_label = $ 
  widget_text( row, value = '', xsize = 10) 
stack_setup_par.z_max_label = $ 
  widget_text( row, value = '', xsize = 10) 
 
row = widget_base( col1, /row ) 
label = widget_label( row, value = 'Total hours: ') 
stack_setup_par.total_hours_label = $ 
  widget_text( row, value = '', xsize = 10) 
 
stack_setup_par.doit_label = $ 
  widget_button(col1, value = 'Do it (yes, the Z values are "safe")') 
stack_setup_par.exit_label = widget_button(col1, value = 'Exit') 
 
stack_setup_par.i_plot_label = $ 
  widget_draw( col2, xsize = stack_setup_par.plot_ncols, $ 
               ysize = stack_setup_par.plot_nrows, $ 
               retain = 2, /button_events) 
stack_setup_par.i0_plot_label = $ 
  widget_draw( col2, xsize = stack_setup_par.plot_ncols, $ 
               ysize = stack_setup_par.plot_nrows, $ 
               retain = 2, /button_events) 
 
widget_control, stack_setup_par.main_base, /realize 
 
widget_control, stack_setup_par.i_plot_label, get_value = window 
stack_setup_par.i_plot_win = window 
widget_control, stack_setup_par.i0_plot_label, get_value = window 
stack_setup_par.i0_plot_win = window 
widget_control, stack_setup_par.doit_label, sensitive = 0 
 
wset, window 
tvlct, stack_setup_par.rvec, stack_setup_par.gvec, $ 
  stack_setup_par.bvec 
 
xmanager, 'stack_setup', stack_setup_par.main_base, $ 
  group_leader = stack_setup_par.main_base 
 
return 
end 
 
