; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
;+ 
;NAME: 
;	AX_IMAGE_APPEND 
; 
;LAST CHANGED:-------------------------- 29-jun-00 
; 
;PURPOSE 
;  This procedure appends the currently displayed image 
;  to a user-selected second image with averaging in the common region. 
;  The final image is interpolated to the mesh of 
;  the more finely sampled image. 
; 
;CATEGORY: 
;	AXIS: image analysis 
; 
;CALLING SEQUENCE: 
; 	ax_image_append 
; 
;INPUT: none (uses AXIS_COM common blocks for input/output) 
; 
;KEYWORDS: none 
; 
;OUTPUT: 
;	(Image in buffer_9) = (1st_image) appended to (2nd_image) 
; 
;COMMON BLOCKS: 
;	AXIS_COM	standard set of common blocks 
; 
;MODIFICATION HISTORY: 
; (29-jun-00) first version 
;- 
 
PRO AX_IMAGE_APPEND 
@axis_com
on_error,2 
 
HANDLE_VALUE, Data(CurBuf), tmp 
IF n_tags(tmp) EQ 0 THEN RETURN 
IF tmp.t EQ '2d' then begin 
    bt = buffer(group = AXIS_ID) 
    IF bt EQ -1 THEN RETURN				  ; abort procedure if no other image selected 
  	HANDLE_VALUE, Data(bt), div 
  	IF n_tags(div) EQ 0 THEN RETURN 
	IF (div.t EQ '2d') THEN BEGIN     ; for images only 
			xmin1 = min(tmp.x, max=xmax1) 
			xmin2 = min(div.x, max=xmax2) 
			xmin = min([xmin1,xmin2]) 
			xmax = max([xmax1,xmax2]) 
			ymin1 = min(tmp.y, max=ymax1) 
			ymin2 = min(div.y,max=ymax2) 
			ymin = min([ymin1,ymin2]) 
			ymax = max([ymax1,ymax2]) 
			xstep = tmp.x(2)-tmp.x(1)		; ASSUMES STEP IS THE SAME ! 
			ystep = tmp.y(2)-tmp.y(1) 
			nx = ceil(1 + (xmax - xmin)/xstep) 
			x = findgen(nx)*xstep + xmin 
			ny = ceil(1 + (ymax - ymin)/ystep) 
			y = findgen(ny)*ystep + ymin 
			print, 'Append image size is ', nx, ny 
			d_avg = (mean(tmp.d) + mean(div.d))/2. 
			d = make_array(nx, ny, /float, value=d_avg) 
			dl = string(format='(A," app ",A)',tmp.dl,div.dl) 
	 	   	s = {t:'2d', x:x, y:y, d:d, xl:tmp.xl, yl:tmp.yl, dl:dl} 
; identify indices in d which correspond to tmp and div 
			Ilo = DIndex(xmin1,ymin1,s) 
			Ihi = DIndex(xmax1,ymax1,s) 
			print, 'Append tmp into: X:', Ilo(0), Ihi(0),' Y:',Ilo(1), Ihi(1) 
			help, tmp.d 
			d(Ilo(0):Ihi(0),Ilo(1):Ihi(1)) = tmp.d(0:Ihi(0)-Ilo(0),0:Ihi(1)-Ilo(1)) 
			Ilo = DIndex(xmin2,ymin2,s) 
			Ihi = DIndex(xmax2,ymax2,s) 
			print, 'Append div into: X:', Ilo(0), Ihi(0),' Y:',Ilo(1), Ihi(1) 
			help, div.d 
			d(Ilo(0):Ihi(0),Ilo(1):Ihi(1)) = div.d(0:Ihi(0)-Ilo(0),0:Ihi(1)-Ilo(1)) 
; use average of the common section if needed 
	  		t = Ax_Mesh(tmp,div,2)  	; NB tmp and div are returned with common area only 
			if t EQ 1 then begin 
				dn = (tmp.d + div.d)/2. 
				xmin = min(tmp.x, max=xmax) 
				ymin = min(tmp.y, max=ymax) 
				Ilo = DIndex(xmin,ymin,s) 
				Ihi = DIndex(xmax,ymax,s) 
				print, 'Append common into: X:', Ilo(0), Ihi(0),' Y:',Ilo(1), Ihi(1) 
				d(Ilo(0):Ihi(0),Ilo(1):Ihi(1)) = dn(0:Ihi(0)-Ilo(0),0:Ihi(1)-Ilo(1)) 
			endif 
			s.d = d 
; store appended image in buffer 0 
     	   	CurBuf = 0 
   	   		HANDLE_VALUE, Data(CurBuf), s, /set 
   	   		Label(CurBuf) = s.dl 
   	   		PlotBuf,CurBuf 
   	 ENDIF ELSE WIDGET_CONTROL, Uprompt, SET_VALUE='Append buffers: only for 2 images' 
ENDIF ELSE WIDGET_CONTROL, Uprompt, SET_VALUE='Append buffers: only for images' 
END 
