PRO stack_bldlst_stripdir, this_filename 
 
temp_filename = this_filename 
osname = strupcase(strmid(!Version.os, 0, 3)) 
IF (osname EQ 'VMS') THEN BEGIN 
    firstpos = strpos(temp_filename, ']')+1 
ENDIF ELSE IF (osname EQ 'WIN') THEN BEGIN 
    firstpos = rstrpos(temp_filename, '\')+1 
ENDIF ELSE BEGIN 
    firstpos = rstrpos(temp_filename, '/')+1 
ENDELSE 
 
IF (firstpos EQ -1) THEN BEGIN 
    this_filename = temp_filename 
ENDIF ELSE BEGIN 
    this_filename = strmid(temp_filename, firstpos, $ 
                           (strlen(temp_filename)-firstpos)) 
ENDELSE 
 
return 
END 
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
 
PRO stack_bldlst_header_num, filename, header, numstr, trailer, next_numstr 
 
dotpos = rstrpos(filename, '.') 
trailer = strmid(filename, dotpos, (strlen(filename)-dotpos)) 
 
zerobytstr = byte('0') 
zerobyte = zerobytstr(0) 
ninebytstr = byte('9') 
ninebyte = ninebytstr(0) 
 
testpos = dotpos-1 
teststr = strmid(filename, testpos, 1) 
testbytarr = byte(teststr) 
testbyte = testbytarr(0) 
WHILE ((testbyte GE zerobyte) AND $ 
       (testbyte LE ninebyte)) DO BEGIN 
    numpos = testpos 
    testpos = numpos - 1 
    teststr = strmid(filename, testpos, 1) 
    testbytarr = byte(teststr) 
    testbyte = testbytarr(0) 
ENDWHILE 
 
header = strmid(filename, 0, numpos) 
numstr = strmid(filename, numpos, (dotpos-numpos)) 
 
num = 0 
reads, numstr, num 
 
next_numstr = strtrim(string(num+1), 2) 
next_numstr_len = strlen(next_numstr) 
numstr_len = strlen(numstr) 
 
WHILE (numstr_len GT next_numstr_len) DO BEGIN 
    next_numstr = '0'+next_numstr 
    next_numstr_len = next_numstr_len + 1 
ENDWHILE 
 
return 
END 
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
 
PRO stack_bldlst_doit 
 
@bsif_com
 
COMMON stack_bldlst_common, stack_bldlst_par, $ 
  pick_directory, pick_filelist, stack_filelist, $ 
  stack_evlist, stack_file_ev_msec_list, $ 
  this_filename, first_filename, last_filename, list_filename 
 
IF ((stack_bldlst_par.got_first EQ 0) OR $ 
    (stack_bldlst_par.got_last EQ 0)) THEN BEGIN 
    stack_evlist = 0 
    stack_filelist = 0 
    stack_file_ev_msec_list = 0 
    widget_control, stack_bldlst_par.stack_filelist_label, $ 
      set_value = [''] 
 
    return 
ENDIF 
 
stack_bldlst_header_num, first_filename, $ 
  header, first_numstr, trailer, next_numstr 
stack_bldlst_header_num, last_filename, $ 
  header, last_numstr, trailer 
 
print,'Have header="'+header+'",first_numstr='+$ 
  strtrim(string(first_numstr),2)+$ 
  ', trailer="'+trailer+'"' 
 
this_numstr = first_numstr 
this_filename = header+this_numstr+trailer 
next_filename = header+next_numstr+trailer 
keep_going = 1 
WHILE (keep_going NE 0) DO BEGIN 
    templist = findfile(this_filename) 
    svec = size(templist) 
    IF (svec(0) NE 0) THEN BEGIN 
        read_stxm, this_filename, sd, /header, /nocopybytes 
        this_ev = 12398.52/sd.wavelength 
        ;; Add this to the list 
        svec = size(stack_filelist) 
        this_file_ev_msec = this_filename+' '+$ 
            strtrim(string(this_ev, format = '(f10.2)'), 2)+' eV '+$ 
            strtrim(string(sd.dwell_time, format='(i6)'), 2)+' msec '+$ 
            strtrim(string(n_cols),2)+'x'+strtrim(string(n_rows),2) 
        IF (svec(0) EQ 0) THEN BEGIN 
            stack_filelist = [this_filename] 
            stack_evlist = [this_ev] 
            stack_file_ev_msec_list = [this_file_ev_msec] 
        ENDIF ELSE BEGIN 
            stack_filelist = [stack_filelist, this_filename] 
            stack_evlist = [stack_evlist, this_ev] 
            stack_file_ev_msec_list = $ 
              [stack_file_ev_msec_list, this_file_ev_msec] 
        ENDELSE 
 
        IF (this_numstr EQ last_numstr) THEN BEGIN 
            keep_going = 0 
        ENDIF ELSE BEGIN 
            this_numstr = next_numstr 
            this_filename = header+this_numstr+trailer 
            stack_bldlst_header_num, this_filename, $ 
              header, numstr, trailer, next_numstr 
            next_filename = header+next_numstr+trailer 
        ENDELSE 
    ENDIF ELSE BEGIN 
        keep_going = 0 
    ENDELSE 
ENDWHILE 
 
print,'Sorting the list' 
index_order = sort(stack_evlist) 
stack_evlist = stack_evlist(index_order) 
stack_filelist = stack_filelist(index_order) 
stack_file_ev_msec_list = stack_file_ev_msec_list(index_order) 
 
widget_control,stack_bldlst_par.stack_filelist_label,$ 
  set_value = stack_file_ev_msec_list 
 
return 
END 
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
 
pro stack_bldlst_readfile 
 
@bsif_com
 
COMMON stack_bldlst_common, stack_bldlst_par, $ 
  pick_directory,pick_filelist,stack_filelist,$ 
  stack_evlist,stack_file_ev_msec_list,$ 
  this_filename,first_filename,last_filename, list_filename 
 
print,'Trying to do read_stxm on "'+this_filename+'"' 
n_cols = 0 
read_stxm,this_filename,sd,/header,/nocopybytes 
 
print,'Finished read_stxm in stack_bldlst_readfile' 
 
IF (n_cols NE 0) THEN BEGIN 
    stack_bldlst_par.this_ev = 12398.52/sd.wavelength 
    widget_control,stack_bldlst_par.this_file_label,$ 
      set_value=this_filename 
    widget_control,stack_bldlst_par.row_col_label,$ 
      set_value=strtrim(string(n_cols),2)+' X '+$ 
            strtrim(string(n_rows),2) 
    widget_control,stack_bldlst_par.this_ev_label,$ 
      set_value=strtrim(string(stack_bldlst_par.this_ev,$ 
                           format='(f10.2)'),2) 
    stack_bldlst_par.got_a_file = 1 
    widget_control,stack_bldlst_par.first_label,sensitive=1 
    widget_control,stack_bldlst_par.last_label,sensitive=1 
ENDIF ELSE BEGIN 
    widget_control,stack_bldlst_par.this_file_label,$ 
      set_value='' 
    widget_control,stack_bldlst_par.row_col_label,$ 
      set_value='' 
    widget_control,stack_bldlst_par.this_ev_label,$ 
      set_value='' 
    stack_bldlst_par.got_a_file = 0 
ENDELSE 
 
END 
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
 
PRO stack_bldlst_event, event 
 
@bsif_com
 
COMMON stack_bldlst_common, stack_bldlst_par, $ 
  pick_directory,pick_filelist,stack_filelist,$ 
  stack_evlist,stack_file_ev_msec_list,$ 
  this_filename,first_filename,last_filename, list_filename 
 
case event.id of 
    stack_bldlst_par.pick_directory_label: BEGIN 
        temp_string = '' 
        widget_control, stack_bldlst_par.pick_directory_label, $ 
          get_value = temp_string 
        on_ioerror, pick_directory_label_oops 
        pick_directory = temp_string(0) 
        pick_directory_label_oops: 
        last_char = strmid(pick_directory,strlen(pick_directory)-1,1) 
        osname = strupcase(strmid(!version.os,0,3)) 
        IF (osname EQ 'VMS') THEN BEGIN 
            IF (last_char NE ']') THEN BEGIN 
                pick_directory = pick_directory+']' 
            ENDIF 
        ENDIF ELSE IF (osname EQ 'WIN') THEN BEGIN 
            IF (last_char NE '\') THEN BEGIN 
                pick_directory = pick_directory+'\' 
            ENDIF 
        ENDIF ELSE BEGIN 
            IF (last_char NE '/') THEN BEGIN 
                pick_directory = pick_directory+'/' 
            ENDIF 
        ENDELSE 
        widget_control, stack_bldlst_par.pick_directory_label, $ 
          set_value = pick_directory 
 
        pick_filelist = findfile(pick_directory+'*.nc') 
        svec = size(pick_filelist) 
        IF (svec(0) EQ 0) THEN BEGIN 
            pick_filelist = ['No files'] 
        ENDIF 
 
        widget_control, stack_bldlst_par.pick_filelist_label, $ 
          set_value=pick_filelist 
    END 
 
    stack_bldlst_par.pick_filelist_label: BEGIN 
        this_filename = pick_filelist(event.index) 
        ;stack_bldlst_stripdir,this_filename 
        stack_bldlst_readfile 
    END 
 
    stack_bldlst_par.first_label: BEGIN 
        IF (stack_bldlst_par.got_a_file NE 0) THEN BEGIN 
            stack_bldlst_par.first_ev = stack_bldlst_par.this_ev 
            stack_bldlst_par.got_first = 1 
            first_filename = this_filename 
            widget_control, stack_bldlst_par.first_name_label,$ 
              set_value=this_filename 
            widget_control, stack_bldlst_par.first_ev_label, $ 
              set_value=strtrim(string(stack_bldlst_par.first_ev,$ 
                                   format='(f10.2)'),2) 
            IF (stack_bldlst_par.got_last NE 0) THEN BEGIN 
              widget_control,stack_bldlst_par.add_label,$ 
                  sensitive=1 
            ENDIF 
        ENDIF ELSE BEGIN 
            stack_bldlst_par.got_first = 0 
            first_filename = '' 
            widget_control, stack_bldlst_par.first_name_label,$ 
              set_value='' 
            widget_control, stack_bldlst_par.first_ev_label, $ 
              set_value='' 
        ENDELSE 
    END 
 
    stack_bldlst_par.last_label: BEGIN 
        IF (stack_bldlst_par.got_a_file NE 0) THEN BEGIN 
            stack_bldlst_par.last_ev = stack_bldlst_par.this_ev 
            stack_bldlst_par.got_last = 1 
            last_filename = this_filename 
            widget_control, stack_bldlst_par.last_name_label,$ 
              set_value=this_filename 
            widget_control, stack_bldlst_par.last_ev_label, $ 
              set_value=strtrim(string(stack_bldlst_par.last_ev,$ 
                                   format='(f10.2)'),2) 
            IF (stack_bldlst_par.got_first NE 0) THEN BEGIN 
              widget_control,stack_bldlst_par.add_label,$ 
                  sensitive=1 
            ENDIF 
        ENDIF ELSE BEGIN 
            stack_bldlst_par.got_last = 0 
            last_filename = '' 
            widget_control, stack_bldlst_par.last_name_label,$ 
              set_value='' 
            widget_control, stack_bldlst_par.last_ev_label, $ 
              set_value='' 
        ENDELSE 
 
    END 
 
    stack_bldlst_par.add_label: BEGIN 
        widget_control,stack_bldlst_par.main_base,hourglass=1 
        stack_bldlst_doit 
        stack_bldlst_par.got_a_file = 0 
        stack_bldlst_par.got_first = 0 
        first_filename = '' 
        widget_control, stack_bldlst_par.first_name_label,$ 
            set_value='' 
        widget_control, stack_bldlst_par.first_ev_label, $ 
            set_value='' 
        stack_bldlst_par.got_last = 0 
        last_filename = '' 
        widget_control, stack_bldlst_par.last_name_label,$ 
            set_value='' 
        widget_control, stack_bldlst_par.last_ev_label, $ 
            set_value='' 
        widget_control,stack_bldlst_par.add_label,sensitive=0 
        widget_control,stack_bldlst_par.first_label,sensitive=0 
        widget_control,stack_bldlst_par.last_label,sensitive=0 
        IF (stack_bldlst_par.got_list_filename NE 0) THEN BEGIN 
            widget_control,stack_bldlst_par.save_list_doit_label,$ 
                sensitive=1 
        ENDIF 
 
        widget_control,stack_bldlst_par.main_base,hourglass=0 
    END 
 
    stack_bldlst_par.reset_list_label: BEGIN 
        stack_evlist = 0 
        stack_filelist = 0 
        stack_file_ev_msec_list = 0 
 
        widget_control,stack_bldlst_par.save_list_doit_label,$ 
          sensitive=0 
        widget_control,stack_bldlst_par.stack_filelist_label,$ 
          set_value = [''] 
    END 
 
    stack_bldlst_par.save_list_filename_label: BEGIN 
        temp_string = '' 
        widget_control, stack_bldlst_par.save_list_filename_label, $ 
          get_value = temp_string 
        list_filename = temp_string(0) 
        IF (strlen(list_filename) NE 0) THEN BEGIN 
            IF (strpos(strlowcase(list_filename),'.sl') LT 0) THEN BEGIN 
                list_filename = list_filename+'.sl' 
            ENDIF 
            stack_bldlst_par.got_list_filename = 1 
            IF (n_elements(stack_filelist) GT 1) THEN BEGIN 
                widget_control, stack_bldlst_par.save_list_doit_label,$ 
                    sensitive = 1 
            ENDIF 
        ENDIF 
        widget_control, stack_bldlst_par.save_list_filename_label, $ 
          set_value = list_filename 
    END 
 
    stack_bldlst_par.save_list_doit_label: BEGIN 
        stack_writelist, list_filename, stack_filelist 
        print,'Wrote list file "'+list_filename+'"' 
    END 
 
    stack_bldlst_par.list_complete_label: BEGIN 
        widget_control,stack_bldlst_par.main_base,/destroy 
    END 
 
ENDCASE 
END 
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
 
PRO stack_buildlist,return_list_filename,return_filename_list 
 
@bsif_com
 
COMMON stack_bldlst_common, stack_bldlst_par, $ 
  pick_directory,pick_filelist,stack_filelist,$ 
  stack_evlist,stack_file_ev_msec_list,$ 
  this_filename,first_filename,last_filename,list_filename 
 
if (n_tags(stack_bldlst_par) eq 0) then begin 
    stack_bldlst_par = $ 
      { stack_bldlst_par, $ 
        main_base: 0L, $ 
        pick_directory_label: 0L, $ 
        pick_filelist_label: 0L, $ 
        this_file_label: 0L, $ 
        row_col_label: 0L, $ 
        this_ev_label: 0L, $ 
        this_ev: 0., $ 
        first_label: 0L, $ 
        first_ev_label: 0L, $ 
        first_ev: 0., $ 
        first_name_label: 0L, $ 
        last_label: 0L, $ 
        last_ev_label: 0L, $ 
        last_ev: 0., $ 
        last_name_label: 0L, $ 
        add_label: 0L, $ 
        reset_list_label: 0L, $ 
        save_list_filename_label: 0L, $ 
        save_list_doit_label: 0L, $ 
        list_complete_label: 0L, $ 
        stack_filelist_label: 0L, $ 
        got_first: 0L, $ 
        got_last: 0L, $ 
        got_a_file: 0L, $ 
        got_list_filename: 0L $ 
      } 
endif 
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
 
stack_bldlst_par.main_base = widget_base(title='stack_bldlst', /row ) 
col1 = widget_base(stack_bldlst_par.main_base,/frame,/column) 
col2 = widget_base(stack_bldlst_par.main_base,/frame,/column) 
 
pick_directory = '' 
pick_filelist = findfile(pick_directory+'*.nc') 
stack_filelist = 0 
stack_evlist = 0 
stack_file_ev_msec_list = 0 
stack_bldlst_par.got_first = 0L 
stack_bldlst_par.got_last = 0L 
stack_bldlst_par.got_a_file = 0L 
stack_bldlst_par.got_list_filename = 0L 
 
svec = size(pick_filelist) 
IF (svec(0) EQ 0) THEN BEGIN 
    pick_filelist = ['No files'] 
ENDIF 
 
filebase = widget_base(col1,/column,/frame) 
row = widget_base(filebase,/row) 
label = widget_label(row,value='Directory: ') 
stack_bldlst_par.pick_directory_label = $ 
  widget_text(row,value=pick_directory,xsize=20,/frame,/editable) 
stack_bldlst_par.pick_filelist_label = $ 
  widget_list(filebase,value=pick_filelist,$ 
              xsize=40,ysize=6,/frame) 
row = widget_base(filebase,/row) 
label = widget_label(row,value='This file: ') 
stack_bldlst_par.this_file_label = $ 
  widget_text(row,value='',xsize=40) 
row = widget_base(filebase,/row) 
label = widget_label(row,value='has rows x cols: ') 
stack_bldlst_par.row_col_label = $ 
  widget_text(row,value='',xsize=10) 
label = widget_label(row,value='eV: ') 
stack_bldlst_par.this_ev_label = $ 
  widget_text(row,value='',xsize=8) 
 
first_base = widget_base(col1,/column,/frame) 
row = widget_base(first_base,/row) 
stack_bldlst_par.first_label = $ 
  widget_button(row,value='Set as first') 
label = widget_label(row,value='eV: ') 
stack_bldlst_par.first_eV_label = $ 
  widget_text(row,value='',xsize=8) 
row = widget_base(first_base,/row) 
label = widget_label(row,value='First filename: ') 
stack_bldlst_par.first_name_label = $ 
  widget_text(row,value='',xsize=40) 
 
last_base = widget_base(col1,/column,/frame) 
row = widget_base(last_base,/row) 
stack_bldlst_par.last_label = $ 
  widget_button(row,value='Set as last') 
label = widget_label(row,value='eV: ') 
stack_bldlst_par.last_eV_label = $ 
  widget_text(row,value='',xsize=8) 
row = widget_base(last_base,/row) 
label = widget_label(row,value='Last filename: ') 
stack_bldlst_par.last_name_label = $ 
  widget_text(row,value='',xsize=40) 
 
row = widget_base( col1, /row,/frame ) 
label = widget_label( row, value='Save list ".sl" filename: ' ) 
stack_bldlst_par.save_list_filename_label = $ 
  widget_text( row, value='', xsize=20, /frame, /editable) 
stack_bldlst_par.save_list_doit_label = $ 
  widget_button( row, value='Save list') 
 
row = widget_base( col1,/row,/frame) 
stack_bldlst_par.add_label = $ 
  widget_button( row,value='Add first -> last to list') 
stack_bldlst_par.reset_list_label = $ 
  widget_button( row, value = 'Reset list' ) 
stack_bldlst_par.list_complete_label = $ 
  widget_button( row, value = 'List is complete!' ) 
 
stack_bldlst_par.stack_filelist_label = $ 
  widget_text( col2, value = [''], $ 
               xsize = 40, ysize=15, $ 
               /frame, /scroll ) 
widget_control, stack_bldlst_par.main_base, /realize 
 
widget_control,stack_bldlst_par.add_label,sensitive=0 
widget_control,stack_bldlst_par.first_label,sensitive=0 
widget_control,stack_bldlst_par.last_label,sensitive=0 
widget_control,stack_bldlst_par.save_list_doit_label, sensitive = 0 
 
xmanager, 'stack_bldlst', stack_bldlst_par.main_base, $ 
  group_leader = stack_bldlst_par.main_base 
 
IF (n_elements(list_filename) NE 0) THEN BEGIN 
    return_list_filename = list_filename 
ENDIF 
return_filename_list = stack_filelist 
 
return 
END 
