; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
;+ 
;NAME: 
;	AX_IMG_DEL 
; 
;LAST CHANGED: ----------------------------------- 31-dec-99 
; 
; PURPOSE: 
;	This procedure replaces all pixels in a user-selected region 
; by user-selected value (0 or mean). 
; 
; CATEGORY: 
;	AXIS: image analysis 
; 
; CALLING SEQUENCE: 
;	AX_IMG_DEL 
; 
;CALLED FROM AXIS: 
;	->Images->Delete region 
 
; INPUTS: 
;	All input parameters are passed as keywords or through AXIS_COM 
; 
; KEYWORDS: none 
; 
; OUTPUTS: 
;	Modified image placed in buffer 0. 
; 
; COMMON BLOCKS: 
;	@AXIS_COM	standard set of common blocks 
; 
; PROCEDURE: 
;	Uses DefROI widget for felxible region of interest definition. 
; 
; RESTRICTIONS: 
;	only executable from AXIS 
; 
; MODIFICATION HISTORY: 
; (31-dec-99 aph) first written 
;- 
 
PRO ax_img_del 
 
@axis_com
on_error,2 
 
HANDLE_VALUE, Data(CurBuf), tmp 
IF n_tags(tmp) EQ 0 THEN RETURN 
IF tmp.t EQ '2d' THEN BEGIN 
	ncol = n_elements(tmp.x) & nrow = n_elements(tmp.y) 
	img_size = max([ncol, nrow]) 
	if img_size EQ 0 then img_size = 1 ;for images larger than 360*gr_scale 
	img_zoom =  floor(360*gr_scale/img_size) 
	SetGraf, 'MainImg' 
	erase 
	loadct,ColTbl,/silent 
	tvscl, rebin(tmp.d, img_zoom*ncol,img_zoom*nrow) 
	roi = cw_defroi(MainWid, image_size = [ncol,nrow], zoom =[img_zoom, img_zoom]) 
;  	print,'Zoom = ', img_zoom, '.   ROI limits: ',min(roi),max(roi) 
	svec = size(roi) 
	IF (svec(0) NE 0) THEN BEGIN	; proceed only if roi is real region 
		t = moment(tmp.d,/nan) 
		replace = get_num(Prompt = 'replace with ',val = t(0) , group = axis_ID) 
		tmp.d(roi) = replace 
	endif 
	ax_color 
	CurBuf = 0 
	tmp.dl = 'D ' + tmp.dl 
	HANDLE_VALUE, Data(CurBuf), tmp, /set 
	PlotBuf, CurBuf 
	Label(CurBuf) = tmp.dl 
ENDIF ELSE WIDGET_CONTROL, Uprompt, Set_Value = 'Image delete region: only for images' 
END 
