; Copyright (c) 1998-2008 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AXIS_WEB
;
;LAST CHANGED: ----------------------------------- 25-Feb-08
;
;PURPOSE:
;	This procedure executes a net browser command to access
; synchrotron or other sites via the web.
; The browser command will be system / computer specific.
;
;CATEGORY:
;	AXIS: utility (captive)
;
;CALLING SEQUENCE:
;	AXIS_WEB, event_X, event_Y
;
;CALLED FROM AXIS:
;	while rotating logo visible only
;
;INPUTS:
;	EVENT_X - from Xmanager, X-value of pixel clicked
;	EVENT_Y - from Xmanager, Y-value of pixel clicked
;
;KEYWORDS:
;	SITE - code for web site to go to (to use from "utilities/XRM sites")
;
;OUTPUTS:
;	A new window with the web info is generated.
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;SIDE EFFECTS:
;	A window is created/destroyed.
;
;PROCEDURE:
;	uses IDL spawn command. The form of the Net command MUST be one
; that will operate from an MS-DOS window in win-95. Thus 8.3 file names and
; no embedded blanks in paths.
;
;
;MODIFICATION HISTORY:
; (31-jan-00 aph) first created; adapted to variable size
; (22-aug-00 aph) add link to aXis2000 home base
; (22-aug-01 aph) update axis2000 home base
; (25-Feb-08 aph) update web links
;-

PRO axis_web, event_X, event_Y, site = site

@axis_com
on_error,2

if net_command EQ '' then $
    net_command = 'c:\progra~1\netscape\communicator\program\netscape'

if NOT keyword_set(site) then begin
    site = 'nowhere'
	if logo_size LE 360 then begin
		webx = fix(float(event_x)/gr_scale)
		weby = fix(float(event_y)/gr_scale)
	endif else begin
		pos = fix(0.5*(logo_size-360))
		webx = event_x - pos
		weby = event_y - pos
	endelse
;	webx = fix((float(event_x)/360.)*logo_size)
;	weby = fix((float(event_y)/360.)*logo_size)
	if webx GE 5 AND webx LE 80 then begin
		if weby GE 240 AND weby LE 260 then site = 'ALS'
		if weby GE 200 AND weby LE 225 then site = 'APS'
		if weby GE 165 AND weby LE 185 then site = 'Bessy'
		if weby GE 125 AND weby LE 145 then site = 'CLS'
	endif
	if webx GE 285 AND webx LE 356 then begin
		if weby GE 240 AND weby LE 260 then site = 'elettra'
		if weby GE 200 AND weby LE 225 then site = 'ESRF'
		if weby GE 165 AND weby LE 185 then site = 'NSLS'
		if weby GE 125 AND weby LE 145 then site = 'PLS'
	endif else begin
		if weby LT 100 then site = 'AXIS2000'
	endelse
endif
site = strtrim(site, 2)
print, 'Contacting XRM web site: ', site

CASE site OF

'ALS': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting ALS web site . . . '
	spawn, net_command + ' http://www-als.lbl.gov/als/microscopes/scope5.3.2.html', /noshell
   end

'APS': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting APS web site . . . '
	spawn, net_command + ' http://www.aps.anl.gov/sricat/2idb.html', /noshell
  end

'Bessy': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting Bessy web site . . . '
	spawn, net_command + ' http://www.bessy.de/cms.php?idcat=166', /noshell
  end

'CLS': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting CLS web site . . . '
	spawn, net_command + ' http://www.lightsource.ca/experimental/sm.php', /noshell
  end

'elettra': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting ELETTRA web site . . . '
	spawn, net_command + ' http://www.elettra.trieste.it/experiments/beamlines/twinmic/index.html', /noshell
  end

'ESRF': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting ESRF web site . . . '
	spawn, net_command + 'http://www.esrf.eu/UsersAndScience/Experiments/Imaging/ID21/', /noshell
  end

'NSLS': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting NSLS web site . . . '
	spawn, net_command + ' http://xray1.physics.sunysb.edu/', /noshell
   end

'PLS': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting PLS web site . . . '
	spawn, net_command + ' http://paleng.postech.ac.kr/', /noshell
   end

'AXIS2000': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting aXis2000 web site . . . '
	spawn, net_command + ' http://unicorn.mcmaster.ca/aXis2000.html', /noshell
   end

   else: print, 'This web site is unknown'

ENDCASE

end
