FUNCTION stack_list, list_filename 
; 
; PURPOSE:  wrapper around stack_readlist to convert all stack list files 
; to Zimba format (first line is ath; subsequent are names) 
; automatic checking for alternate paths if initial path not correct 
; 
; INPUTS:  list_filename = file contianing filename_list 
; 
; OUTPUTS:  returns 1 if successfully read the files; 0 otherwise 
; 
; --------------------------- last changed: 17-apr-00 
; (25-sep-99 aph) force write out in zimba version; this allows zimba to work 
; (02-feb-00 aph) ensure path is written in line 1 when rewrite *.sl file 
; (17-apr-00 aph) adapt for cases where first line is blank (peem, zimba) 
;               major rewrite to convert sphagetti to penne 
 
@axis_com
on_error, 2 
 
if widget_info(/active) EQ 0 then Uprompt = 0 
check = 1 
sep = ax_sep() 
filename_list = '' 
stack_readlist, list_filename, filename_list 
; help, filename_list 
n_files = n_elements(filename_list) 
IF (n_files EQ 0) THEN goto, bailout 
; print, 'first file is ', filename_list(0) 
 
; ------- CHECK IF FILENAMES are accessible. ----- 
ftest = findfile(filename_list(0), count=ctest) 
 
; ------ If found, define path and check with second filename -- 
IF ctest GT 0 then begin 
	t = ax_name(filename_list(0)) 
	if t(0) NE '' then sl_path = t(0) else sl_path = DefPath 
	t = ax_name(filename_list(1)) 
	fnew = sl_path + t(1) + '.' + t(2) 
	ftest = findfile(fnew, count=dtest) 
	if dtest EQ 0 then check = 0 
ENDIF ELSE check = 0 
 
; -------- first line in file is not a valid file. 
; - either it is path (Zimba format default) 
; .......... or the path is wrong 
; ....................or the file does not exist 
IF check EQ 0 then BEGIN 
; ------------------------- check if it is a zimba format file -------- 
	widget_control,Uprompt, Bad_ID = Bad_ID,  Set_Value = 'filenames incorrect. Checking alternate locations' 
	t = ax_name(list_filename)	; check if files are in same area as list_filename 
	File_Path = t(0) 
; PRINT, 'check if files are in same area as list_filename ', File_Path 
	fname = filename_list(1) 
	t = ax_name(fname) 
	fname = t(1) + '.' + t(2) 
	fnew = File_Path + fname 
	print, 'Path to ', filename_list(0), ' is incorrect. Trying . . . ', fnew 
	ftest = findfile(fnew,count=dtest) 
 
	if dtest GT 0 then begin 
		sl_path = File_Path 
	endif else begin 
		print, ' Invalid Path. Select a file from the directory containing the data' 
		ftest = pickfile2(/read,filter ='*.*') 
		t = ax_name(ftest) 
		File_Path = t(0) 
		fnew = File_Path + fname 
		print, 'Checking that ', fname,' is in directory ', File_Path 
		ftest = findfile(fnew,count=etest) 
		if etest EQ 0 then goto, bailout 
		sl_path = File_Path 
	endelse 
 
ENDIF 
;------  sl_path SHOULD BE correct  - so revise filename_list to zimba format 
; making sure each name transferred to the final filename_list exists 
n_files = 0 
bad_count = 0 
t_list = filename_list 
FOR i = 0, n_elements(filename_list)-1 DO BEGIN 
	t = ax_name(filename_list(i)) 
	fname = t(1) + '.' + t(2) 
	ftest = findfile(sl_path + fname,count=etest) 
	if etest EQ 0 AND i GT 0 then begin 
		print, 'Removing ', fname, ' from list' 
		bad_count = bad_count + 1 
	endif else begin 
		t_list(n_files) = fname 
		n_files = n_files + 1 
	endelse 
ENDFOR 
IF bad_count GT 0 then begin 
	print, 'There were ', bad_count,' invalid filenames' 
	print, 'Cannot find some files in ', list_filename 
endif 
; ----- force filename_list to have Zimba format --------- 
filename_list = strarr(n_files+1) 
filename_list(0) = sl_path 
filename_list(1:n_files) = t_list(0:n_files-1) 
 
; ---- and rewrite ----- 
Widget_control,Uprompt, Bad_ID = BadID, Set_Value = 'REWRITE stack_list file in Zimba format' 
openw, iunit, list_filename, /get_lun 
for i = 0, n_files do printf, iunit, filename_list(i) 
close, iunit & free_lun, iunit 
print, 'wrote revised SL data in Zimba format to ', list_filename 
 
return, check 
 
bailout: 
PRINT, 'Cannot find data files. Ending.' 
check = 0 
return, check 
 
END 
