;NAME:
;	AA_EventCB
;
;LAST CHANGED: ----------------------------------- 28-feb-07
;
;PURPOSE:
; The event handler for the X-SpecSim sub-program
;
;CATEGORY:
;	STAND ALONE: Spectra Prediction
;
;CALLED FROM AA:
;
;OUTPUTS:
;	No explicit outputs indpendant of the X-SpecSim program
;
;COMMON BLOCKS:
;	@AA_Com		X-SpecSim common block
;	@AXIS_COM	standard set of common blocks
;-----------------------------------------------------------------
pro cancel, event

;exit
    WIDGET_CONTROL, Event.Top, /DESTROY

end

pro chkClick, event
  @AA_Com

  if SaveSF eq 0 then begin
    SaveSF = 1
  endif else begin
    SaveSF = 0
  endelse

  aa_writeconfig
end

pro LoadSequence, Event
  @AA_Com
  fname = pickfile2(Title='Select Sequence file')
  print, fname
  openr, iunit, fname, /get_lun
  text = ''
  line = ''
		while not  eof(iunit) do begin
			readf,iunit, line
			text = text + line
		endwhile
  close, iunit & free_lun, iunit

  text = strtrim(text,2)
  text = strupcase(text)
  text = strcompress(text)

  WIDGET_CONTROL, WIDtext, SET_VALUE=text
end


pro SimpleSum, Event
  @AA_Com

  if (n_elements(aadata) lt 1) or (n_elements(endata) lt 1) then begin
    loaddat, file=datapaths[curdat]
    loaden, file=enpaths[curen]
	aa = aamoddata
	en = endata
  endif else begin
	aa = aamoddata
	en = endata
  endelse

  WIDGET_CONTROL, WIDtext, GET_VALUE=text
  print, text
  text = strtrim(text,2)
  text = strupcase(text)
  text = strcompress(text)
  FinData = fltarr(1, n_elements(en))
  comp = {carbon:0, nitrogen:0, oxygen:0, hydrogen:0, sulphur:0, phosphorus:0}
  for i = 0, strlen(text[0])-1 do begin
	for j = 0, n_elements(AA)-1 do begin
	  	if AA[j].Letter eq strmid(text[0],i,1) then begin
			FinData = AA[j].data + FinData
			comp.carbon = comp.carbon + AAdata[j].carbon
			comp.nitrogen = comp.nitrogen + AAdata[j].nitrogen
			comp.oxygen = comp.oxygen+AAdata[j].oxygen
			comp.hydrogen = comp.hydrogen+AAdata[j].hydrogen
			comp.sulphur = comp.sulphur+AAdata[j].sulphur
			comp.phosphorus = comp.phosphorus+AAdata[j].phosphorus
		endif
	endfor
  endfor

findata = findata/strlen(text[0])

  comp.oxygen = comp.oxygen - strlen(text[0]) + 1 ;amide bond correction, lose 1 oxygen
  comp.hydrogen = comp.hydrogen - 2*strlen(text[0]) + 2;amide bond correction, lose 2 hydrogen
  sfcmpd = 'C' + string(comp.carbon) + ' N' + string(comp.nitrogen) + ' O' + string(comp.oxygen) + ' H' + string(comp.hydrogen) + ' S' + string(comp.sulphur) + ' P' + string(comp.phosphorus)
  sfcmpd = STRCOMPRESS(sfcmpd, /REMOVE_ALL)
  SF_INIT, 'c:\axis2000\sfdata\'
  print, sfcmpd
  sfdat = sf(sfcmpd,en,density = 1.3, thickness = 0.001, result_type='trans', sf_dir='c:\axis2000\sfdata\') ;fix this fixed string
  sfdat = alog(1/sfdat)

  cedge = where((en gt 278) and (en lt 340))
  clow = where(en lt 283)
  chigh = where((en gt 315) and (en lt 340))
  nedge = where((en gt 380) and (en lt 480))
  nlow = where((en lt 398) and (en gt 380))
  nhigh = where((en gt 430) and (en lt 480))
  oedge = where((en gt 510) and (en lt 600))
  olow = where((en lt 525) and (en gt 480))
  ohigh = where((en gt 560) and (en lt 600))

	;cEdgeStuff
	if ((n_elements(clow) gt 1) and (n_elements(chigh) gt 1)) then begin
	totallength = n_elements(clow) + n_elements(chigh)

	;Float arrays for regression are assembled
	QarrX = fltarr(3,totalLength)
	QarrY = fltarr(totalLength)
	W = fltarr(totalLength)
	W[*]=1
	QarrX[0,0:n_elements(clow)-1] = en(clow)
	Qarrx[0,n_elements(clow):n_elements(clow)+n_elements(chigh)-1] = en(chigh)
	QarrX[1,0:n_elements(clow)-1] = findata(clow)
	Qarrx[1,n_elements(clow):n_elements(clow)+n_elements(chigh)-1] = findata(chigh)
	QarrX[2,*] = 1
	QarrY[0:n_elements(clow)-1] = sfdat(clow)
	QarrY[n_elements(clow):n_elements(clow)+n_elements(chigh)-1] = sfdat(chigh)

	result = regress2(QarrX, QarrY, W)
	SlopeE = result[0]
	Slope = result[1]
	Const = result[2]

	findata[cedge] = findata[cedge] * slope + en[cedge]*SlopeE + const
	endif

	;N Edge
	if ((n_elements(nlow) gt 1) and (n_elements(nhigh) gt 1)) then begin
	totallength = n_elements(nlow) + n_elements(nhigh)

	;Float arrays for regression are assembled
	QarrX = fltarr(3,totalLength)
	QarrY = fltarr(totalLength)
	W = fltarr(totalLength)
	W[*]=1
	QarrX[0,0:n_elements(nlow)-1] = en(nlow)
	Qarrx[0,n_elements(nlow):n_elements(nlow)+n_elements(nhigh)-1] = en(nhigh)
	QarrX[1,0:n_elements(nlow)-1] = findata(nlow)
	Qarrx[1,n_elements(nlow):n_elements(nlow)+n_elements(nhigh)-1] = findata(nhigh)
	QarrX[2,*] = 1
	QarrY[0:n_elements(nlow)-1] = sfdat(nlow)
	QarrY[n_elements(nlow):n_elements(nlow)+n_elements(nhigh)-1] = sfdat(nhigh)

	result = regress2(QarrX, QarrY, W)
	SlopeE = result[0]
	Slope = result[1]
	Const = result[2]

	findata[nedge] = findata[nedge] * slope + en[nedge]*SlopeE + const
	endif

	;O edge
	if ((n_elements(olow) gt 1) and (n_elements(ohigh) gt 1)) then begin
  	totallength = n_elements(olow) + n_elements(ohigh)
	;Float arrays for regression are assembled
	QarrX = fltarr(3,totalLength)
	QarrY = fltarr(totalLength)
	W = fltarr(totalLength)
	W[*]=1
	QarrX[0,0:n_elements(olow)-1] = en(olow)
	Qarrx[0,n_elements(olow):n_elements(olow)+n_elements(ohigh)-1] = en(ohigh)
	QarrX[1,0:n_elements(olow)-1] = findata(olow)
	Qarrx[1,n_elements(olow):n_elements(olow)+n_elements(ohigh)-1] = findata(ohigh)
	QarrX[2,*] = 1
	QarrY[0:n_elements(olow)-1] = sfdat(olow)
	QarrY[n_elements(olow):n_elements(olow)+n_elements(ohigh)-1] = sfdat(ohigh)

	result = regress2(QarrX, QarrY, W)
	SlopeE = result[0]
	Slope = result[1]
	Const = result[2]

	findata[oedge] = findata[oedge] * slope + en[oedge]*SlopeE + const
  	endif

  WIDGET_CONTROL, proteinname, GET_VALUE=pName
  plot, en, findata, TITLE=pname[0] + ' Spectra', XTITLE='eV', XRANGE = [en[0], en[n_elements(en)-1]], /XSTYLE
  oplot, en, sfdat

  if AXISR eq 1 then begin    		  ;Axis is running, output to its buffers
	@Axis_Com
    if savesf eq 1 then begin
  	  energy = findgen(700 - 250) + 250
		i=1
  	  	CurBuf = i
		stmp ={t:'1d', x: en, d: findata, yl: 'transmission', xl: 'Energy (eV)', dn: 'spectra', dl: pname[0] }
	   	HANDLE_value, Data(CurBuf),stmp,/set
		Label(CurBuf) = stmp.dl
		Plotbuf, CurBuf
		i = i + 1
  	  	CurBuf = i
		stmp ={t:'1d', x: energy, d: alog(1/sf(sfcmpd,energy,density = 1, thickness = 0.001, result_type='trans', sf_dir='C:\Axis2000\SFdir')), yl: 'transmission', xl: 'Energy (eV)', dn: 'spectra', dl: pname[0] + 'SF' }
	   	HANDLE_value, Data(CurBuf),stmp,/set
		Label(CurBuf) = stmp.dl
		Plotbuf, CurBuf
	endif else begin
	  tmp = {t:'1d', x: en, d: findata, yl: 'transmission', xl: 'Energy (eV)', dn: 'spectra', dl: pname[0] }
      HANDLE_value, Data(CurBuf),tmp,/set
      Plotbuf,CurBuf
	endelse
  Endif else begin
  	cfilepath = sav_AA(en=en, data=findata,  sequence=otext, name = pname[0])
    if savesf eq 1 then begin
  	  energy = findgen(700 - 250) + 250
  	  cfilepath = sav_AA(en=energy, data=alog(1/sf(sfcmpd,energy,density = 1, thickness = 0.001, result_type='trans', sf_dir='C:\Axis2000\SFdir'))$
  	  ,  sequence=otext, name = 'SF_'+ pname[0])
    endif
  Endelse

end

pro ComplexSum, Event
	@AA_com

  if n_elements(aadata) lt 1 then begin
    loaddat, file=datapaths[curdat]
    loaden, file=enpaths[curen]
	aa = aamoddata
	en = endata
  endif else begin
	aa = aamoddata
	en = endata
  endelse

  WIDGET_CONTROL, WIDtext, GET_VALUE=text
  text = strtrim(text,2)
  text = strupcase(text)
  TextAdd = ''
  for i = 0, strlen(text[0])-1 do begin
	TextAdd=TextAdd + 'Z'
  endfor
  oText =text
  text = text + TextAdd

  comp = {carbon:0, nitrogen:0, oxygen:0, hydrogen:0, sulphur:0, phosphorus:0}
  FinData = fltarr(1, n_elements(en))
  for i = 0, strlen(text[0])-1 do begin
	for j = 0, n_elements(aamoddata)-1 do begin
	  	if AA[j].Letter eq strmid(text[0],i,1) then begin
			FinData = AA[j].data + FinData
			comp.carbon = comp.carbon + AAdata[j].carbon
			comp.nitrogen = comp.nitrogen + AAdata[j].nitrogen
			comp.oxygen = comp.oxygen + AAdata[j].oxygen
			comp.hydrogen = comp.hydrogen + AAdata[j].hydrogen
			comp.sulphur = comp.sulphur + AAdata[j].sulphur
			comp.phosphorus = comp.phosphorus + AAdata[j].phosphorus
		endif
	endfor
  endfor

  findata = findata/strlen(otext[0])

  comp.oxygen = comp.oxygen - strlen(otext[0]) + 1 ;amide bond correction, lose 1 oxygen for each amide bond
  comp.hydrogen = comp.hydrogen - 2*strlen(otext[0]) + 2;amide bond correction, lose 2 hydrogen for each amide bond
  sfcmpd = 'C' + string(comp.carbon) + ' N' + string(comp.nitrogen) + ' O' + string(comp.oxygen) + ' H' + string(comp.hydrogen) + ' S' + string(comp.sulphur) + ' P' + string(comp.sulphur)
  sfcmpd = STRCOMPRESS(sfcmpd, /REMOVE_ALL)
  SF_INIT, 'sfdata\'
  sfdat = sf(sfcmpd,en,density = 1.3, thickness = 0.001, result_type='trans', sf_dir='SFdata\') ;fix this fixed string
  sfdat = alog(1/sfdat)

  cedge = where((en gt 278) and (en lt 340))
  clow = where(en lt 283)
  chigh = where((en gt 315) and (en lt 340))
  nedge = where((en gt 380) and (en lt 480))
  nlow = where((en lt 398) and (en gt 380))
  nhigh = where((en gt 430) and (en lt 480))
  oedge = where((en gt 510) and (en lt 600))
  olow = where((en lt 525) and (en gt 480))
  ohigh = where((en gt 560) and (en lt 600))

	;cEdgeStuff
	if ((n_elements(clow) gt 1) and (n_elements(chigh) gt 1)) then begin
	totallength = n_elements(clow) + n_elements(chigh)

	;Float arrays for regression are assembled
	QarrX = fltarr(3,totalLength)
	QarrY = fltarr(totalLength)
	W = fltarr(totalLength)
	W[*]=1
	QarrX[0,0:n_elements(clow)-1] = en(clow)
	Qarrx[0,n_elements(clow):n_elements(clow)+n_elements(chigh)-1] = en(chigh)
	QarrX[1,0:n_elements(clow)-1] = findata(clow)
	Qarrx[1,n_elements(clow):n_elements(clow)+n_elements(chigh)-1] = findata(chigh)
	QarrX[2,*] = 1
	QarrY[0:n_elements(clow)-1] = sfdat(clow)
	QarrY[n_elements(clow):n_elements(clow)+n_elements(chigh)-1] = sfdat(chigh)

	result = regress2(QarrX, QarrY, W)
	SlopeE = result[0]
	Slope = result[1]
	Const = result[2]

	findata[cedge] = findata[cedge] * slope + en[cedge]*SlopeE + const
	endif

	;N Edge
	if ((n_elements(nlow) gt 1) and (n_elements(nhigh) gt 1)) then begin
	totallength = n_elements(nlow) + n_elements(nhigh)

	;Float arrays for regression are assembled
	QarrX = fltarr(3,totalLength)
	QarrY = fltarr(totalLength)
	W = fltarr(totalLength)
	W[*]=1
	QarrX[0,0:n_elements(nlow)-1] = en(nlow)
	Qarrx[0,n_elements(nlow):n_elements(nlow)+n_elements(nhigh)-1] = en(nhigh)
	QarrX[1,0:n_elements(nlow)-1] = findata(nlow)
	Qarrx[1,n_elements(nlow):n_elements(nlow)+n_elements(nhigh)-1] = findata(nhigh)
	QarrX[2,*] = 1
	QarrY[0:n_elements(nlow)-1] = sfdat(nlow)
	QarrY[n_elements(nlow):n_elements(nlow)+n_elements(nhigh)-1] = sfdat(nhigh)

	result = regress2(QarrX, QarrY, W)
	SlopeE = result[0]
	Slope = result[1]
	Const = result[2]

	findata[nedge] = findata[nedge] * slope + en[nedge]*SlopeE + const
	endif

	;O edge
	if ((n_elements(olow) gt 1) and (n_elements(ohigh) gt 1)) then begin
  	totallength = n_elements(olow) + n_elements(ohigh)
	;Float arrays for regression are assembled
	QarrX = fltarr(3,totalLength)
	QarrY = fltarr(totalLength)
	W = fltarr(totalLength)
	W[*]=1
	QarrX[0,0:n_elements(olow)-1] = en(olow)
	Qarrx[0,n_elements(olow):n_elements(olow)+n_elements(ohigh)-1] = en(ohigh)
	QarrX[1,0:n_elements(olow)-1] = findata(olow)
	Qarrx[1,n_elements(olow):n_elements(olow)+n_elements(ohigh)-1] = findata(ohigh)
	QarrX[2,*] = 1
	QarrY[0:n_elements(olow)-1] = sfdat(olow)
	QarrY[n_elements(olow):n_elements(olow)+n_elements(ohigh)-1] = sfdat(ohigh)

	result = regress2(QarrX, QarrY, W)
	SlopeE = result[0]
	Slope = result[1]
	Const = result[2]

	findata[oedge] = findata[oedge] * slope + en[oedge]*SlopeE + const
  	endif

  WIDGET_CONTROL, proteinname, GET_VALUE=pName

  if AXISR eq 1 then begin
	@Axis_Com
    if savesf eq 1 then begin
  	  energy = findgen(700 - 250) + 250
		i=1
  	  	CurBuf = i
		stmp ={t:'1d', x: en, d: findata, yl: 'transmission', xl: 'Energy (eV)', dn: 'spectra', dl: pname[0] }
	   	HANDLE_value, Data(CurBuf),stmp,/set
		Label(CurBuf) = stmp.dl
		Plotbuf, CurBuf
		i = i + 1
  	  	CurBuf = i
		stmp ={t:'1d', x: energy, d: alog(1/sf(sfcmpd,energy,density = 1, thickness = 0.001, result_type='trans', sf_dir='C:\Axis2000\SFdir')), yl: 'transmission', xl: 'Energy (eV)', dn: 'spectra', dl: pname[0] + 'SF' }
	   	HANDLE_value, Data(CurBuf),stmp,/set
		Label(CurBuf) = stmp.dl
		Plotbuf, CurBuf
	endif else begin
	  tmp = {t:'1d', x: en, d: findata, yl: 'transmission', xl: 'Energy (eV)', dn: 'spectra', dl: pname[0] }
      HANDLE_value, Data(CurBuf),tmp,/set
      Plotbuf,CurBuf
	endelse
  Endif else begin
 cfilepath = sav_AA(en=en, data=findata,  sequence=otext, name = pname[0], modified='Peptide Bond Corrected')
    if savesf eq 1 then begin
  	  energy = findgen(700 - 250) + 250
  	  cfilepath = sav_AA(en=energy, data=alog(1/sf(sfcmpd,energy,density = 1, thickness = 0.001, result_type='trans', sf_dir='C:\Axis2000\SFdir'))$
  	  ,  sequence=otext, name = 'SF_'+ pname[0])
    endif
    plot, en, findata, TITLE=pname[0] + ' Spectra', XTITLE='eV', XRANGE = [en[0], en[n_elements(en)-1]], /XSTYLE
    oplot, en, sfdat
  Endelse

end

pro LoadEnergy, Event
	@AA_Com
    filename = Dialog_Pickfile(/READ, /MUST_EXIST, Filter='*.enf', TITLE='Select Energy File To Load')
	IF filename NE "" THEN BEGIN
  		ENData = read_energies( File=filename, filter='*.enf')
  		if n_elements(endata) gt 0 and n_elements(aadata) gt 0 then begin
			ab = extrapolateaa(endata)
		endif
	ENDIF else begin
		Result = DIALOG_MESSAGE('a Valid file was not selected')
	endelse
end

pro Loaden, File=File
@aa_com
	if not keyword_set(file) then begin
		file = Dialog_Pickfile(/READ, /MUST_EXIST, Filter='*.aah', TITLE='Select Amino Acid Data Files to Load')
	endif
	IF file NE "" THEN BEGIN
  		ENData = read_energies( File=file, filter='*.enf')
  		if n_elements(endata) gt 0 and n_elements(aadata) gt 0 then begin
			ab = extrapolateaa(endata)
		endif
	ENDIF else begin
		Result = DIALOG_MESSAGE('a Valid file was not selected')
	endelse
end

Pro LoadAA, Event
	@AA_Com

    filename = Dialog_Pickfile(/READ, /MUST_EXIST, Filter='*.aah', TITLE='Select Amino Acid Data Files to Load')
	Loaddat, file=filename
end

Pro LoadDat, file=file
@aa_com
	if not keyword_set(file) then begin
		file = Dialog_Pickfile(/READ, /MUST_EXIST, Filter='*.aah', TITLE='Select Amino Acid Data Files to Load')
	endif
	AAList = read_AA_header(file=file)
    path = getpath(file)
    print, aalist
    AAdata = 	REPLICATE({Name:'alanine', Letter:'A', Formula:'', cSize:0, Energies:FLTARR(1000), Data:FLTARR(1000), carbon:0, nitrogen:0, oxygen:0, hydrogen:0, sulphur:0, phosphorus:0},N_ELEMENTS(aalist))
  	for i = 0, N_ELEMENTS(AAList)-1 do begin
  		AAen = read_AAData(file=path + '\' + AAList[i], filter='*.aas', letter=letterB, engdat=endata, Comp=Comp)
    	AAdata[i].letter = letterB
    	leng = n_elements(aaen[0,*])
    	AAdata[i].Energies = AAen[0,0:leng-1]
    	AAdata[i].Data = AAen[1,0:leng-1]
    	AAdata[i].cSize = leng
		aadata[i].carbon = comp.carbon
		aadata[i].nitrogen = comp.nitrogen
		aadata[i].oxygen = comp.oxygen
		aadata[i].hydrogen = comp.hydrogen
		aadata[i].sulphur = comp.sulphur
		aadata[i].phosphorus = comp.phosphorus
  	endfor

  	if n_elements(endata) GT 1 then begin
    	ab = extrapolateaa(endata)
  	endif

  print, aadata.letter
end

pro DropListEncb, event
@aa_com
  curen = event.INDEX
  loaden, file=enpaths[curen]
  aa_writeconfig
end

pro DropListDatcb, event
@aa_com
  curdat = event.index
  Loaddat, file=datapaths[curdat]
  aa_writeconfig
end

pro AA_eventcb
end

