; Copyright (c) 1998-2004 A.P. Hitchcock  All rights reserved
;+
;NAME:
;  AverageVal
;
;LAST CHANGED: ----------------------------------- 21-Jul-06
;
; PURPOSE:
;	this function projects from existing data the value of a point
;
; CATEGORY:
;	spectra Processing; stand alone operation
;
; CALLING SEQUENCE:
;	AverageVal, Arr, Val
;
; INPUTS:
; 	Arr	2d array of energy and spectral data
;	Val the energy value you wish to acquire data about
;
; KEYWORDS: none
;
; OUTPUTS: 	none
;
; COMMON BLOCKS: none
;
;
; RESTRICTIONS: none
;
; MODIFICATION HISTORY:
; (21-Jul-06 jso) first version

Function AverageVal, arr=arr, val=val
	i=0
	ans =0
	while i NE length(arr)-1 do begin
		if val le arr(0,i+1) and val Ge arr(0,i) then begin
			slope = (arr[1,i+1]-arr[1,i])/(arr[0,i+1] - arr[0,i])
			ans = arr(1,i) + slope * (val - arr[0,i])
			return, ans
		endif
		i = i+1
	endwhile
end