function read_bsp, file, sd, header_only=header_only, DEFPATH=DefPath, _extra=e 
 
;+ 
; function read_bsp, file, sd, header_only=header_only, DEFPATH=DefPath, _extra=e 
; 
; --------------------------------------------- last changed: 25-Jun-99 
; Reads in a STXM image from netCDF format. 
; 
; It puts the image and associated information 
; into BSIF_COMMON variables: 
;   image_data (the array which holds the image - possible several 
;   		planes deep for I, IO, CLOCK) 
;   x_normal, y_normal, rotated, x_title, y_title, 
;   x_dist, and y_dist 
; 
; The STXM scan data is put into "sd" BUT ONLY IF 
;- 
; -------------------- DEVELOPMENT HISTORY --------------- 
; Based on Mark Rivers stuff; Chris Jacobsen, June 1993 
; (18-Jun-97 aph)  Modified for SPECTRAL.PRO 
; (14-jun-98 aph) bsif_com 
; (28-jan-99 aph) add dwell info 
; (25-jun-99 aph) fileshort only 
 
;on_error,2 
 
@bsif_com
 
if n_elements(file) eq 0 then begin  ;popup file dialog box 
   fltr='*.nc' 
   if keyword_set(nof) then fltr='*' 
   file=PICKFILE2(/Read, FILTER=fltr, /LPATH, DEFPATH=defpath) 
endif 
 
if strlen(file) GT 0 THEN BEGIN  ; bail-out if no filename 
 
; Open the file to be read 
cdfid = ncdf_open(file, /NOWRITE) 
 
ncdf_diminq, cdfid, 0, dummy, n_cols 
ncdf_diminq, cdfid, 1, dummy, n_rows 
ncdf_diminq, cdfid, 2, dummy, n_data 
ncdf_diminq, cdfid, 3, dummy, n_chars 
 
image_data_id = ncdf_varid(cdfid, 'image_data') 
data_title_id = ncdf_varid(cdfid, 'data_title') 
 
 
; Retrieve global attributes 
ncdf_attget, cdfid, /GLOBAL, "title", image_title 
 
; Retrieve BSIF information 
ncdf_attget, cdfid, image_data_id, "x_normal", x_normal 
ncdf_attget, cdfid, image_data_id, "y_normal", y_normal 
ncdf_attget, cdfid, image_data_id, "rotated", rotated 
ncdf_attget, cdfid, image_data_id, "x_start", x_start 
ncdf_attget, cdfid, image_data_id, "x_stop", x_stop 
ncdf_attget, cdfid, image_data_id, "y_start", y_start 
ncdf_attget, cdfid, image_data_id, "y_stop", y_stop 
ncdf_attget, cdfid, image_data_id, "x_title", x_title 
ncdf_attget, cdfid, image_data_id, "y_title", y_title 
 
init_stxm_sd,sd 
ncdf_attget, cdfid, image_data_id, "version_number", t 
sd.version_number=t 
ncdf_attget, cdfid, image_data_id, "scan_driver_mode", t 
sd.scan_driver_mode=t 
ncdf_attget, cdfid, image_data_id, "scan_width", t 
sd.scan_width=t 
ncdf_attget, cdfid, image_data_id, "scan_height", t 
sd.scan_height=t 
ncdf_attget, cdfid, image_data_id, "i0_mode", t 
sd.i0_mode=t 
ncdf_attget, cdfid, image_data_id, "clock_frequency", t 
sd.clock_frequency=t 
ncdf_attget, cdfid, image_data_id, "sd_x_start", t 
sd.x_start=t 
ncdf_attget, cdfid, image_data_id, "sd_x_stop", t 
sd.x_stop=t 
ncdf_attget, cdfid, image_data_id, "x_center", t 
sd.x_center=t 
ncdf_attget, cdfid, image_data_id, "x_step_size", t 
sd.x_step_size=t 
ncdf_attget, cdfid, image_data_id, "sd_y_start", t 
sd.y_start=t 
ncdf_attget, cdfid, image_data_id, "sd_y_stop", t 
sd.y_stop=t 
ncdf_attget, cdfid, image_data_id, "y_center", t 
sd.y_center=t 
ncdf_attget, cdfid, image_data_id, "y_step_size", t 
sd.y_step_size=t 
ncdf_attget, cdfid, image_data_id, "z_start", t 
sd.z_start=t 
ncdf_attget, cdfid, image_data_id, "z_stop", t 
sd.z_stop=t 
ncdf_attget, cdfid, image_data_id, "z_center", t 
sd.z_center=t 
ncdf_attget, cdfid, image_data_id, "z_step_size", t 
sd.z_step_size=t 
ncdf_attget, cdfid, image_data_id, "focus_position", t 
sd.focus_position=t 
ncdf_attget, cdfid, image_data_id, "dwell_time", t 
sd.dwell_time=t 
ncdf_attget, cdfid, image_data_id, "x_prescan_distance", t 
sd.x_prescan_distance=t 
ncdf_attget, cdfid, image_data_id, "y_prescan_distance", t 
sd.y_prescan_distance=t 
ncdf_attget, cdfid, image_data_id, "x_postscan_distance", t 
sd.x_postscan_distance=t 
ncdf_attget, cdfid, image_data_id, "x_postscan_distance", t 
sd.x_postscan_distance=t 
ncdf_attget, cdfid, image_data_id, "flyback_velocity", t 
sd.flyback_velocity=t 
ncdf_attget, cdfid, image_data_id, "entrance_slit", t 
sd.entrance_slit=t 
ncdf_attget, cdfid, image_data_id, "exit_slit", t 
sd.exit_slit=t 
ncdf_attget, cdfid, image_data_id, "wavelength", t 
sd.wavelength=t 
ncdf_attget, cdfid, image_data_id, "date_time", t 
sd.date_time=byte(string(t)) 
;ncdf_attget, cdfid, image_data_id, "sd.operator", t 
;sd.operator=byte(string(t)) 
ncdf_attget, cdfid, image_data_id, "sample", t 
sd.sample=byte(string(t)) 
ncdf_attget, cdfid, image_data_id, "zone_plate", t 
sd.zone_plate=byte(string(t)) 
ncdf_attget, cdfid, image_data_id, "comment1", t 
sd.comment1=byte(string(t)) 
ncdf_attget, cdfid, image_data_id, "comment2", t 
sd.comment2=byte(string(t)) 
ncdf_attget, cdfid, image_data_id, "file_name", t 
sd.file_name=byte(string(t)) 
ncdf_attget, cdfid, image_data_id, "ring_current", t 
sd.ring_current=t 
ncdf_attget, cdfid, image_data_id, "undulator_gap", t 
sd.undulator_gap=t 
ncdf_attget, cdfid, image_data_id, "idling_time", t 
sd.idling_time=t 
ncdf_attget, cdfid, image_data_id, "auto_shutter", t 
sd.auto_shutter=t 
ncdf_attget, cdfid, image_data_id, "x_pzt_offset", t 
sd.x_pzt_offset=t 
ncdf_attget, cdfid, image_data_id, "y_pzt_offset", t 
sd.y_pzt_offset=t 
ncdf_attget, cdfid, image_data_id, "initial_lambda", t 
sd.initial_lambda=t 
ncdf_attget, cdfid, image_data_id, "final_lambda", t 
sd.final_lambda=t 
ncdf_attget, cdfid, image_data_id, "sgm_step_size", t 
sd.sgm_step_size=t 
ncdf_attget, cdfid, image_data_id, "dx_dl", t 
sd.dx_dl=t 
ncdf_attget, cdfid, image_data_id, "dy_dl", t 
sd.dy_dl=t 
ncdf_attget, cdfid, image_data_id, "dz_de", t 
sd.dz_de=t 
 
;sd_len=n_tags(sd,/length) 
;user_buffer=bytarr(sd_len) 
;copy_bytes,sd_len,sd,user_buffer 
 
if (not keyword_set(header_only)) then begin 
  ncdf_varget, cdfid, image_data_id, image_data 
endif 
ncdf_varget, cdfid, data_title_id, data_title 
 
;calculate x_dist for spectra 
x_pixel_size = (x_stop - x_start)/n_cols 
x_dist = x_start + (findgen(n_cols) * x_pixel_size) 
 
ncdf_close, cdfid 
 
;  Add-in to generate structure to parallel the ALS format (aph) 
	d=float(image_data(*,0,0)) 
	norm = 0*d + 1. 
	xl='Wavelength' 
    tmp = size(image_data)  & np= tmp(1) 
	print, 'NSLS spectrum read from BINARY file: ', file 
	name_bits = ax_name(file) 
	fileshort = name_bits(1) 
	details = Strcompress(string(np))+' points from '+Strcompress(string(X_start))+' to '+Strcompress(string(X_stop)) + ' Angstroms ' 
	dwl_info = string(format='(",    Dwell = ",f7.2," ms")', sd.dwell_time) 
	details = details + dwl_info 
	print, details 
	tmp=create_struct('t','1d','x',x_dist,'d',d,'dn',norm,'xl',xl + dwl_info,'dl',fileshort) 
 
endif else begin 	; go here if user pushes 'cancel' 
    print, ' file name of zero length. Read aborted' 
    tmp=0 
endelse 
 
return, tmp 
end 
 
