; Copyright (c) 1995, ALS SpectroMicroscopy Facility 
; 
;FILE: print.pro 
;+ 
;  pro PRA, /LS, /EPS, _extra=e 
;	OPEN POSTSCRIPT FILE FOR OUTPUT 
;	OPTIONS: /LS (landscape), /EPS (encapsulated postcript) 
;  pro PRB, 'printer', /NOPRINT 
;	CLOSE & PRINT to 'BL7LJ4' (default), 'hp9', etc. 
; (29nov00 cgz) Only PRa and PRb are used anywhere within AXIS
;			PRa and PRb are called once from within WINDOW.PRO
;			Migrated PRa and PRb to WINDOWS.PRO
;		PRINT.PRO is now obsolete
;- 
 
pro PRa, LS=ls, EPS=eps, _extra=e 
;-------------------------------- 
  cmd='set_plot,''ps'' & device, bits=8' 
  if keyword_set(ls) eq 1 then cmd=cmd+', /landscape' 
  if keyword_set(eps) eq 1 then cmd=cmd+', /encapsulated,/preview' 
  cmd=cmd+', _extra=e' 
  print, cmd 
  dum=execute( cmd ) 
  return 
END 
 
 
pro PRb, printer, NOPRINT=nopr 
;---------------------------- 
device,/close 
set_plot,'x' 
if keyword_set(printer) then pr=printer else pr='6-BL7LJ4M+' ;'hp9','xm1_hp' 
if keyword_set(nopr) eq 0 then begin 
  pcmd='lpr -P'+pr+' idl.ps' 
  print,pcmd 
  spawn,pcmd 
endif 
;retall 
END 
 
;---- delete later --- 
pro PRls,_extra=e 
   set_plot,'ps' 
   device,bits=8,/landscape,_extra=e 
end 
 
pro PReps,_extra=e 
   set_plot,'ps' 
   device,bits=8,/encapsulated,/preview,_extra=e 
end 
 
 
 
 
