; Copyright (c) 1998-2008 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		AX_DELTAMIN
;
;LAST CHANGED: ----------------------------------- 	01-Jun-08
;
; PURPOSE:
;	This function returns the smallest spacing in a 1-d array
;
; CATEGORY:
;	stand alon utility
;
; CALLING SEQUENCE:
;	Result = AX_DELTAMIN(X)
;
; OUTPUTS: minimum spacing
;
; COMMON BLOCKS: none
;
; MODIFICATION HISTORY:
; (01-jun-08 aph) first written
;-

function ax_deltamin, x
s = x(0)
if n_elements(x) LE 1 then return,s
s=abs(x(1)-x(0))
for i=1,n_elements(x)-1 DO BEGIN
	t=abs(float(x(i)-x(i-1)))
	if t LT s AND t GT 0. then s=t
ENDFOR
Return, s
END