 ; Copyright (c) 1998-2001 A.P. Hitchcock  All rights reserved
;+
;NAME: READ_BL
;
;LAST CHANGED: ----------------------------------- 10-feb-01
;
; PURPOSE:
;	This function reads ALS B 5.3 STXM data from self-defining format ascii files.
; Images, stacks and linescans have *.hdr and a set of *.xim files
; for {energies.channels.regions}
; Spectra are a single *.xsp file containing header and multi-column spectra.
;
; CATEGORY:
;	Input / output utilty
;
; CALLING SEQUENCE:
;	Result = READ_BL5(file, nof=nof, filter=filter, groupID=groupID, header_only=header_only, _extra=e)
;
; INPUTS:
; 	FILE	optional file name
;
; KEYWORDS:
;	FILTER	   user defined filter
;	GROUPID		group leader (Axis_ID if called from aXis2000 and axis)
;	HEADER_ONLY print header contents only
;	_EXTRA		other passed through parameters
;
; OUTPUTS:
;	structure variable; either 1d (spectra) or 2d (image)
;
; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;	BL5FORMAT	reference number for naming muti-element arrays of structures
;
; MODIFICATION HISTORY:
; (10-feb-01 aph) first version
;-

function read_BL5, file, filter=filter, groupID=groupID, header_only=header_only, _extra=e
on_error,2
@axis_com
common bl5format, starnum

starnum = 0			; start of structure label names

if n_elements(file) eq 0 then begin  ;popup file dialog box
   if not keyword_set(filter) then fltr='*.hdr' else fltr = filter
   file=PICKFILE2(/Read, FILTER=fltr, /LPATH, DEFPATH=defpath)
endif
s = 0
if strlen(file) LE 0 THEN return, s  ; bail-out if no filename
; ------- Open the header to be read -------
on_ioerror,nofile
get_lun,lun
openr,lun,file
; ------- Read header file into a single string (max = 32600 characters)  --------
line = ' '
all = ''
count = 0
while not  eof(lun) do begin
	readf,lun, line
;		print, line
	all = all + line
	count = count + 1			; the number of lines is used in spectral readin
endwhile
close, lun

; ----- remove structure name
equal = strpos(all, '=')
name = strtrim(strmid(all,0,equal),2)
lcb = strpos(all, '{')
all = strmid(all,lcb)
ScanDef = parse_bl5(all,name)
;help, /struct, ScanDef
;return, ScanDef

if keyword_set(header_only) then begin
; ------- print header information
	print, 'Header of file: ', file
	print, '-----------------------------------------------'
	print, ScanDef
	return, ScanDef
endif

; --------- Read in data according to the type of scan -----
n_channels = n_elements(ScanDef.channels)	; KLUGE for now - change when get array structure
if keyword_set(groupID) then $
  n_data = get_num(prompt='Choose data channel', val=2, group=groupID) $
   else n_data = get_num(prompt='Choose data channel', val=2)
TYPE = ScanDef.type
CASE TYPE of
	'Image Scan' : BEGIN
		x = float(ScanDef.PAxis.points)
		nx = n_elements(x)
		y = float(ScanDef.QAxis.points)
		ny = n_elements(y)
		Print, file, nx,' x ',ny, '  pixels.    # data channels', n_channels
		case n_data of
		1 : let = 'a'
		2 : let = 'b'
		3 : let = 'c'
		4 : let = 'd'
		5 : let = 'e'
		else : print, 'Only set up for 5 channels max'
		endcase
		t = ax_name(file)
		img_file = t(0) + t(1) + '_' + let +'.xim'
		d = text_read1(img_file)
;	------ pack into AXIS 2d structure -----------------
		energy = ScanDef.StackAxis.min
		dwell = 10
		xl = string(FORMAT='("x (um)     E = ",f8.3," eV     dwell = ",f5.2," ms")', $
     			 energy, dwell)
		t = ax_name(file)
		fileshort = t(1)
	s = {t:'2d', x:x, y:y, d:d, e: energy, xl:xl, yl:'um  ch '+let, dl: fileshort}
		text = string(format= $
	  '(i4," x",i4," image read from ",A,". E =",f7.2," eV. Dwell =",f5.2," ms.")', $
	   nx, ny, file, energy, dwell)
	print, text

	return, s
	END

	'XANES': BEGIN
	; ------- select data channel
		get_lun,lun
		openr,lun,file			; re-open to get data
		test = ''
		energy = float(ScanDef.Paxis.points)
		npts = n_elements(energy)
		d = fltarr(npts)  & i =0
		ldata = fltarr(n_channels)
		Print, file, ' npts ', npts,' # data channels', n_channels
		for i = 0, (count - npts - 1) do readf,lun,test
	; ------ now positioned at start of multi-column data
		i = 0
		while not eof(lun) do begin
			readf,lun, line
;					print, 'line ', i,': ', line
			reads, line, ldata
			energy(i) = ldata(0)
			d(i)  = ldata(n_data-1)
			i = i+1
		endwhile
		close, lun
;		plot, energy,d
; --------------- generate axis 1d structure -----
		type='1d'
		dwell_time = '10'
		t = ax_name(file)
		fileshort = t(1)
		xl = string(FORMAT='("Energy(eV)    dwell = ",f7.2," ms")', dwell_time)
		tmp = {t:type, x:energy, d:d, dn:d, xl:xl, dl:fileshort}
		print, 'read ALS BL5.3.1 XANES file: ', file
		npts = n_elements(tmp.x)-1
		print, format='(i4," pts. ",f9.4," to ",f9.4," eV. Dwell= ",f7.2," ms.")', $
		    npts, tmp.x(0), tmp.x(npts-1), dwell_time
		return, tmp
	END
	'XANES Image Scan': BEGIN
		Print, 'Reading in ALS Beamline 5.3.1 Stack'
		text = 'ALS 5.3 stack read in: not yet developed'
		print, text
		if keyword_Set(groupID) then Widget_CONTROL, Uprompt, Set_Value = text
		s = 0
		return,s
	END

	'XANES Line Scan': BEGIN
		print, 'Reading in ALS Beamline 5.3.1 Linescan'
		print, 'not yet developed'
		text = 'ALS 5.3 linescan read in: not yet developed'
		print, text
		if keyword_Set(groupID) then Widget_CONTROL, Uprompt, Set_Value = text
		s = 0
		return,s
	END
	; -------- bailout -------------------------
	ELSE: BEGIN
		print, 'Unknown scan type'
	ENDELSE
ENDCASE
return, scandef

nofile:
print, 'Open or read error on ', file
close,/all
return, s
end

