; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
;+ 
;NAME: 
;	AXIS_START_EVENTCB 
; 
;LAST CHANGED: ----------------------------------- 20-jan-00 
; 
;PURPOSE: 
;	This set of procedures processes choices from IDL start-up procedure 
; This is the event call back file for AXIS_START 
; 
;CATEGORY: 
;	STAND ALONE: utility 
; 
;ROUTINES 
;	BUT_AXIS, Event - give prompt to user to run AXIS 
;	BUT_ZimbaStack, Event - compile and run zinba stack analyze (ZIMBA_RUN) 
;	BUT_IDL, Event = goto IDL 
;	AXIS_start_eventcb - stub for autoloading 
; 
;MODIFICATION HISTORY: 
; Generated on:	09/26/99 11:48.55 
; (16-Oct-99 aph) current version 
; (03-jan-00 aph) AXIS standard documentation 
; (20-jan-00 aph) removed ZSTACK_MANALIGN to match new Zimba codes 
;- 
 
pro BUT_AXIS, Event 
; -------------------- start current version of AXIS ------------ 
   	Widget_Control, /DESTROY, Event.Top 
	print, ' ' 
	print, '****************************' 
	print, ' To load and execute AXIS, please type @axis' 
	print, '****************************' 
;	start_axis 
end 
 
pro BUT_ZimbaStack, Event 
; ---------------------- start Zimba stack_analyze routine only --- 
	Widget_Control, /DESTROY, Event.Top 
	Resolve_routine, 'Zstack_analyze' 
	Resolve_routine, 'zstack_color' 
	Resolve_routine, 'zstack_buildlist' 
	Resolve_routine, 'zstack_readlist' 
	Resolve_routine, 'zstack_align_images' 
	Resolve_routine, 'zstack_shift' 
	Resolve_routine, 'zstack_tune' 
	Resolve_routine, 'zstack_align' 
	Resolve_routine, 'zstack_save' 
	Resolve_routine, 'zstack_profile' 
	Resolve_routine, 'zstack_spectra' 
	Resolve_routine, 'zstack_analyze' 
	Resolve_routine, 'stack_readlist' 
;	Resolve_routine, 'pickfile2' 
	zimba_run 
end 
 
; ---------------------- run IDL without loading any widget ------- 
pro BUT_IDL, Event 
   Widget_Control, /DESTROY, Event.Top 
end 
; 
; Empty stub procedure used for autoloading. 
; 
pro AXIS_start_eventcb 
end 
