; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
;+ 
;NAME: 
;	AX_COPY 
; 
;LAST CHANGED: ----------------------------------- 31-dec-99 
; 
;PURPOSE: 
;	This procedure completes the copy of structure data from CurBuf to 
; NewBuf using Thumbs to identify NewBuf. The output buffer is identiifed 
; by left-clicking on one of the thumbnail images or the buffer label. 
; 
;CATEGORY: 
;	AXIS: utility 
; 
;CALLING SEQUENCE: 
;	AX_COPY 
; 
;CALLED FROM AXIS: 
;	->Copy then (AXIS_EVENT processing) 
 
;INPUTS: none 
; 
;KEYWORDS: none 
; 
;OUTPUTS: 
;	Data structure is copied from CurBufto NewBuf 
; 
;COMMON BLOCKS: 
;	@AXIS_COM	standard set of common blocks 
; 
;PROCEDURE: 
;	A flag is set from the COPY command. When the user 
; next clicks on one of the thumbnails or labels this defined NewBuf 
; 
;MODIFICATION HISTORY: 
; (28-sep-99 aph) isolated from axis_c 
; (30-oct-99 aph) removed label change 
; (31-dec-99 aph) AXIS standard documentation 
;- 
 
PRO ax_copy 
 
@axis_com
on_error,2 
 
if NewBuf NE -1 THEN BEGIN 
  HANDLE_VALUE, Data(CurBuf), tmp 
  IF n_tags(tmp) NE 0 THEN BEGIN 
;    tmp.dl = get_text(prompt='Label',VAL=tmp.dl) 
	HANDLE_VALUE, Data(NewBuf), tmp, /set  ;Copy it to new buffer 
	Label(NewBuf) = tmp.dl 
	CurBuf = NewBuf 
	PlotBuf,CurBuf	; plot in new Buffer - this updates ThumbNails and buffer labels 
  endif 
  WIDGET_CONTROL, Uprompt, Set_Value = ' ' 
  copy_flag = 0 
ENDIF 
end 
 
 
