; + 
; function Read_TOF 
; 
; -------------------------------- last changed: 29-may-00 
;PURPOSE: 
;  reads (X,Y,Z) triplet ascii files 
; (for TDC coincidence data) 
;  MUST use TDC program to convert binary to *.IMG (x,y,z) triplets 
;  Xsize=Xsiz, Ysize=Ysize  - number of elements in X,Y 
; 
; REVISION HISTORY 
; (12-may-97 aph) wrote 
; ( 7-jul-99 aph) FREE_LUN as well as close ! 
; (29-may-00 aph) correct data number searcher 
;- 
 
FUNCTION Read_TOF, file, Xsize=Xsiz, Ysize=Ysiz, FILTER=fltr, NOFILTER=nof, DEFPATH=DefPath, _extra=e 
 
on_error,2 
if n_elements(file) eq 0 then begin  ;popup file dialog box 
   if NOT keyword_set(fltr)then fltr='*.img*' 
   if keyword_set(nof) then fltr='*' 
   file=PICKFILE2(/Read, FILTER=fltr, /LPATH, DEFPATH=defpath) 
endif 
 
if strlen(file) GT 0 THEN BEGIN 
	if NOT keyword_set(Xsize) THEN Xsiz = 100 
	if NOT keyword_set(Ysize) THEN Ysiz = 100 
;	a = text_read(file) 
;	as = size(a) 
;    nd = as(2) - 4                   ; find length of data 
	openr, unit,file,/get_lun 
	tmp = string(70) 
	s1 = 1 & s2 = 2 
	on_ioerror,end_of_header 
	head = 0 
	readf,unit,tmp 
	readf,unit, tmp,s2,tmp,s1,format='(a16,i0,a34,i0)' 
	readf,unit, tmp,Xsiz,tmp,xmin,tmp,xmax,format='(a12,i0,a14,f5.2,a8,f5.2)' 
	readf,unit, tmp,Ysiz,tmp,ymin,tmp,ymax,format='(a12,i0,a14,f5.2,a8,f5.2)' 
	head = 1 
	end_of_header: 
	a = fltarr(3,30000) 
	x =float(0) & y=float(0) & z = fix(0) 
	on_ioerror,end_of_file 
	nd = 0 
    for i=0, 30000 do begin 
	   readf,unit, x,y,z 
	   a(*,i) = [x,y,z] 
	   nd = nd + 1 
	endfor 
    end_of_file: 
    close,unit & free_lun, unit 
   ; nd = 1 
   ; while(a(2,nd-1) GT 0)do nd=nd+1 
   ; nd=nd-1 
	print, nd, ' Z-values' 
    IF head EQ 0 THEN BEGIN 
		xmin=min(a(0,*)) 
		xmax=max(a(0,*)) 
		ymin=min(a(1,*)) 
		ymax=max(a(1,*)) 
		xmin = floor(xmin)  & xmax = floor(xmax) + 1 
		ymin = floor(ymin)  & ymax = floor(ymax) + 1 
		if (xmax-xmin) NE (ymax-ymin) then begin                ; force square pixels 
		    if (xmax-xmin) GT (ymax-ymin) then ymax=ymin + (xmax-xmin) $ 
		    else xmax = xmin + (ymax-ymin) 
		endif 
	ENDIF 
	print, ' TOF range 1: ', xmin,' to ', xmax, ' us' 
	print, ' TOF range 2: ', ymin,' to ', ymax, ' us' 
	print, 'data binned to: ',xsiz,' x ',ysiz,' pixels' 
	xd = findgen(Xsiz) 
	yd = findgen(Ysiz) 
	zd=make_array(Xsiz,Ysiz,/float,value=0.) 
	xslope = (xmax-xmin)/float(Xsiz-1) 
	yslope = (ymax-ymin)/float(Ysiz-1) 
	xd = xmin + xd * xslope 
	yd = ymin + yd * yslope 
	for i = 0, nd-1 do begin 
		nx = fix((a(0,i) - xmin)/xslope) 
		ny = fix((a(1,i) - ymin)/yslope) 
;		print,i,nx,ny 
    	zd(nx,ny) = a(2,i) 
 	endfor 
 	xl = 'TOF-ion#'+ strcompress(string(s1)) 
 	yl = 'TOF-ion#'+ strcompress(string(s2)) 
 	upos = rstrpos(file,'/')       ; check for subdirectory separators 
 	wpos = rstrpos(file,'\') 
 	spos = max([upos,wpos]) 
 	if (spos ne -1) then file=strmid(file,spos+1,strlen(file)) 	; strip leader if it exists 
 	spos=strpos(file,'.') 
 	if (spos ne -1) then file=strmid(file,0,spos)		; strip extension 
 	file=strlowcase(file) 
 	dl = file 
 	s=create_struct('t','2d','x',xd,'y',yd,'d',zd,'xl',xl,'yl',yl,'dl',dl) 
endif else begin 	; go here if user pushes 'cancel' 
    print, ' file name of zero length. Read aborted' 
    s=0 
endelse 
 
return, s 
end 
 
 
 
 
 
