; Copyright (c) 1998-2013 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		READ_IMG
;
;LAST CHANGED: ----------------------------------- 	30-Aug-2013
;
; PURPOSE:
;	This function reads in early ALS PEEM data
;
; CATEGORY:
;	read in early ALS PEEM data (PRISM - Brian Tonner's machine).
;
; CALLING SEQUENCE:
;	Result = READ_IMG (file, HSIZE=hs)
;
; INPUTS:
; 	FILE	name of file
;
; KEYWORDS:
;	hsize		SIZE OF IMAGE
;
; COMMON BLOCKS: none
;
; MODIFICATION HISTORY:
;Import Data Translation .IMG file format ( PRISM expt )
; (11-nov-00 cgz) migrated from IO.PRO
; (30-Aug-13 aph) AXIS standard header added
;-


FUNCTION READ_IMG, file, HSIZE=hs

ON_ERROR, 2
file=strlowcase(file)
if (strpos(file,'.img') eq -1) then file=file+'.img'
print, file
;
hdr=strarr(512)
a=bytarr(512,512)
;
openr, unit, file, /GET_LUN
readu, unit, hdr
readu, unit, a
FREE_LUN, unit
;flip vertical
a=rotate(a,7)

if keyword_set(hs) eq 0 then hs=640
vs=round(hs*0.75)
print, hs, vs

outarray=congrid(a(0:511,32:511),hs, vs)
return, outarray
END

