; Copyright (c) 1998-2014 A.P. Hitchcock, B. Watts  All rights reserved

; ************************** AXIS2000.PRO ***********************************
; start-up file for AXIS2000
; IDL Program Suite for Analysis of X-ray microscopy Image and Spectral data
; @Hitchcock Enterprises unlimited
; ******************************************* AXIS 2000 (2.1j) **************
;
; AXIS2000.PRO is the front end of the AXIS program suite
;	used to determine the program directory and initialization file.
;
;
;+
;NAME:
;	AXIS2000
;
;LAST CHANGED: -----------------------------------  14-Jan-14 (aph)
;
;PURPOSE:
;	This procedure starts the aXis2000 widget.
;
;CATEGORY:
;	AXIS: utility
;
;CALLING SEQUENCE:  AXIS2000, directory=directory, start_file='*.ini', , help=help, /dialog
;
;INPUTS: none
;
;KEYWORDS:
;	spin		activate spinning logo
;	help		print a help text
;
;OUTPUTS: starts execution of AXIS
;
;COMMON BLOCKS:
; axis_com
; sdf_com
;
; PROCEDURE
;
; LIMITATIONS
; this has problems for MacOS
;
;MODIFICATION HISTORY:
; (08-dec-00 cgz) first written
; (23-jan-01 cgz) Added initial specification of ini_file if start_file is not specified
; (23-jan-01 cgz) Added /help option to give help message
; (31-jan-01 aph) get so that will auto-run on PC from start_file call (redo of 12-jan-01 changes)
; (22-aug-01 aph) add spin keyword
; (28-jul-02 aph) set directory to 'CodePath' (from axis.ini file), if not defined in call
; (20-Apr-08 aph) explicitly force CodePath to 'c:\axis2000' if not exist
; (25-Jan-12 aph) adapt CodePath to deal with Mac versus Windows
; (20-May-13 bw ) Use internal IDL routines to get codepath to simplify and make more platform independent
; (27-MAy-13 aph) adapt to Windows so it will work with IDL version 6.3;  use as standard start file
; (14-Jan-14 aph) add @sdf_com - so now remembers last SDF file type
;-
;

PRO aXis2000, spin=spin, help=help

@axis_com
@sdf_com

IF keyword_set(help) THEN BEGIN
    print,'axis2000'
    print,'  Options include:'
	print,'    /spin   : activate spinning logo'
    print,'    /help   : to print this help text'
    return
ENDIF

; if !version.os_family EQ 'Windows' then begin
	tmp = file_Search('axis_c.pro', /fully_qualify_path)
	t = ax_name(tmp)
	CodePath=t(0)
	print, 'CodePath is ', CodePath
; endif


;codepath = FILE_DIRNAME(ROUTINE_FILEPATH('axis2000'),/MARK)		; only works for version 7.0 and higher

ini_file = codepath + 'axis.ini'
; print,'codepath : ',codepath
; print,'ini_file : ',codepath+ini_file

if keyword_set(spin) then axis_c, start_file = ini_file, /spin $
  else axis_c, start_file = ini_file

axis_2000_abort :

return
end