; Copyright (c) 2007 A. Scholl  All rights reserved
;+
;NAME:
;		READ_FileInfo_P3B
;
;LAST CHANGED: ----------------------------------- 	20-Jan-07
;
; PURPOSE:
;	This procedure reads all the parameters from ALS PEEM3 data file
;
; CATEGORY:
;	utility
;
; CALLING SEQUENCE:
;	Result =  ReadFileInfo_P3B, FileName, PIXEL_TYPE = pixtype, $
;                    IMAGE_DIMENSIONS = dims, IMAGE_NUMBER = nframes
;
; INPUTS:
;	Filename	name of file (ext = '*.p3b')
;
; KEYWORDS:
;	PIXEL_TYPE  IDL data type number (integer, float, long, etc)
;	IMAGE_DIMENSIONS size of image (nx, ny)
;	IMAGE_NUMBER 	number in a stack
;
; OUTPUTS: adds tags to data file
;
; COMMON BLOCKS: none
;
;
; MODIFICATION HISTORY:
; (20-Jan-07 aph) extracted from filetype_p3b.pro (20-jan-07 version of A. Scholl)
;-

pro ReadFileInfo_P3B, FileName, PIXEL_TYPE = pixtype, IMAGE_DIMENSIONS = dims, IMAGE_NUMBER = nframes

	OPENR, Unit, Filename, /GET_LUN
	ftags = ReadTags(Unit, NTAGS = numtags, MAXTAGS = 3)
	CLOSE, Unit
	FREE_LUN, Unit
	nframes = 1L
	dims = [ftags.DimX, ftags.DimY]
	pixtype = ftags.PixType

end