; Copyright (c) 1998-2014 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		SETGRAF.PRO
;
;LAST CHANGED: ----------------------------------- 	22 Jul 2014
;
; PURPOSE:
;	This procedure switches between the 3Draw Windows in AXIS.PRO
; only allowed values are:  'MainImg'  'XZPlot'   'YZPlot'
; if keyword SET , the scaling parameters for Window, NAME are saved
;
; CATEGORY:
;	aXis2000 utility
;
; CALLING SEQUENCE:
; 	SetGraf, Name, SET=set
;
; INPUTS:
; NAME - name of one of the three draw windows in aXis2000
;		'MainImg'  'XZPlot'   'YZPlot'  - WARNING - case sensitive!!
;
; KEYWORDS:
;	SET		shift focus to the selected window & save old plot parameters for reset

; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;
; MODIFICATION HISTORY:
; (27-may-97 aph) first written
; (12-aug-99 aph) removed from aaa_axis  (axis_c)
; (26-sep-99 aph) removed Thumbnails when went to individual plots
; (21-Dec-00 aph) last change
; (22-Jul-14 aph) AXIS standard header added
;          return if called without aXis2000 running
;-

PRO SetGraf, Name, SET=set
@axis_com
on_error,2

if n_elements(aXis_ID) GT 0 and aXis_ID EQ 0 then return

  CASE NAME OF          ; identify the window
	'MainImg':		i=0
	'XZPlot' : 		i=1
    'YZPlot' : 		i=2
	ELSE     : begin
		print, 'Invalid graf name: ', name
		return
	ENDELSE
ENDCASE
if keyword_set(SET) then Begin
   Xold(i,*) = !X.S
   Yold(i,*) = !Y.S
   return
endif else Begin
  CASE NAME OF          ; identify the window
	'MainImg': 	BEGIN
			wset, MainImg
			i=0
		END
	'XZPlot' : 	BEGIN
			wset, XZPlot
			i =1
		END
    'YZPlot' : 	BEGIN
    		wset, YZPlot
			i = 2
    	END
   ENDCASE
    !X.S = Xold(i,*)   	; restore image (x,y) scaling parameters
    !Y.S = Yold(i,*)
    return
endelse
END
