;
; -------------- check back for user to see if filename list is valid---------
print, 'First file to process is ',filename_list(0)
; --- read first file to define stack dimensions
tmp = img_load(file = filename_list(0),/tif, /values, /silent)
nx = n_elements(tmp.x)
ny = n_elements(tmp.y)
npts = n_files
;print, npts, nx, ny
x = tmp.x
y = tmp.y
image_stack = fltarr(nx,ny,npts)
energy = fltarr(npts)
filename_ev_msec_list = strarr(npts)
; -------- read in images of stack and store in volume_data array
widget_control,hourglass=1
FOR i = 0,n_files-1 DO BEGIN
	tmp = img_load(file = filename_list(i),/jpg, /values, /silent)
	if  n_tags(tmp) NE 0 THEN BEGIN
;		splot2d, tmp
		image_stack(*,*,i) = tmp.d
		energy(i) = tmp.e
		dwell = sd.dwell_time
		filename_ev_msec_list(i) = 'jpg ' + $
			    string(energy(i), format = '(F7.2)') + '  ' +  string(dwell, format='(F5.2)')
		t = ax_name(filename_list(i))
		axis_log, t(1)
	endif
ENDFOR

filename = pickfile2(filter = '*.ncb', title = 'binary stack file')
if strlen(filename) GT 0 then begin
	t = ax_name(filename)
	filename = t(0) + t(1) +'.ncb'
endif else return, filename

widget_control,hourglass=1
; define parameters needed for stack write out
x_start = x(0) & x_stop = x(nx-1)
y_start = y(0) & y_stop = y(ny-1)
ev = energy
stack_wb, filename
widget_control,hourglass=0
axis_log, 'Binary stack of JPG files written as ' + filename
return, filename

END
