; Copyright (c) 1998-2014 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AXIS_INI_SAVE
;
;LAST CHANGED: ----------------------------------- 21 July 2014 (aph)
;
;PURPOSE:
;	This function reads and writes default values for AXIS.
;
;CATEGORY:
;	AXIS: utility
;
;ROUTINES:
;	 test = AXIS_INI_SAVE (filename = filname)  - code that writes parameter file
;
;CALLING SEQUENCE:
;	test = AXIS_INI(file=file, out=out, set = set)
;
;CALLED FROM AXIS:
;	Utilities->Set preferences
; and at start up and Quit
;
;INPUTS: none
;
;KEYWORDS:
;	FILE - initialization file name
;	/OUT - write initialization file
;	/SET - interactive setting of default values
;
;OUTPUTS:
;	axis.ini (or user defined file name)
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;PROCEDURE:
; looks up  default values from AXIS.INI or a user-defined file
; if no file, establish defaults
; on exit from AXIS writes out default values to AXIS.INI or a user-specified file
;
;MODIFICATION HISTORY:
; (28-jun-98 aph) first version
; (12-dec-98 aph) introduce font switching for widget (to adapt IDL 4, IDL 5)
; (13-dec-98 aph) add /set option
; (29-dec-98 aph) use AXIS_OPTIONS to establish defaults (IDL 5.2)
; (03-Jan-99 aph) set default WIN font to Arial*14; switch on 5.2 NOT 5
; (11-May-99 aph) establish axis_ini_save subroutine;
;				  allowed 'Printer' to be full command line, not just language
; (24-may-99 aph) extend to include HELP file command
; (16-nov-99 aph) 'loc' -> 'location' to see if this is why it is not preserved
; (02-jan-00 aph) AXIS standard documentation
; (31-jan-00 aph) add  net browser command
; (27-feb-00 aph) add groupID to get_text
; (07-apr-00 aph) modify to force saving to codepath area by passing on file to axis_ini_save
; (30-nov-00 cgz) added statements to ensure that no leading or trailing spaces are
;				included in parameters once read in from *.ini file
; (05-dec-00 cgz) reversed order of AXIS_INI and AXIS_INI_SAVE
; (09-dec-00 cgz) added conversion of float(strtrim(gr_scale,2))
; (23-jan-01 cgz) added dialog to axis_ini_save, also cleaned up logical path
; (31-jan-01 aph) change prompt
; (22-apr-01 aph) fix crash when load using axis.ini from separate directory - drop axis_options
; (07-oct-01 aph) re-activate axis_options
; (28-oct-04 aph) allow for rescue if user pushes 'cancel' on 'exit'
; (08-nov-04 aph) fix problem that axis2000 does NOT use saved last_file / path information
;            problem was LPath not DefPath was saved, but previously it worked; probably was change in axis_ini_save
; (24-jan-05 aph) replace test for read-in which failed in IDL5.2
; (11-Jan-10 aph) put this code into a separate axis_ini_save.pro file (isolated from from axis_ini.pro)
; (19-Nov-11 aph) automatically save to default file & location, but ask if cannot find it
; (18-Aug-12 aph) get to work on both Mac and Win versions
; (21-Jul-14 aph) save last file name as well as path
;-

FUNCTION axis_ini_save, filename = filename
@axis_com
@sdf_com

get_lun,iunit
on_ioerror, axis_ini_save_oops

print, 'On starting axis_ini_save initialization filename is ', filename
IF NOT keyword_set(filename) then filename = 'axis.ini'  ; force name to be this
; IF NOT keyword_set(filename) THEN filename = ini_file

; ---- make sure system knows the folder where aXis2000 is presently working
cd, current=current_directory
; print, 'current directory is ', current_directory
; print, 'DefPath is ', DefPath
; print, 'Lpath is ', Lpath
; heirarchy is Lpath > DefPath > current_directory
if strtrim(DefPath,2) NE '' then DefPath = current_directory
if strtrim(LPath,2) NE '' then DefPath = Lpath ; save DefPath or the LASTPATH from file reading


; -------- force path for file to be the CodePath -----
; CodePath=''
	IF n_elements(CodePath) GT 0 then begin
		t=ax_name(filename)
		filename = CodePath + t(1) + '.' + t(2)
	ENDIF ELSE BEGIN     ; if CodePath is not defined for some reason
	; ask user to navigate to the codepath to get correct folder string
	   filename = dialog_pickfile(filter='*.ini', /write, /fix_filter, $
      file=filename, path=CodePath, get_path=CodePath, $
      title='Please identify the file "axis.ini" in the CodePath folder  :')
      print, 'CodePath identified as: ', CodePath
	ENDELSE

; --------- check if ini_file actually exists (could be bad from wrong axis.ini  file)
  print, 'Checking for existence of file ', filename
	test = findfile(filename,count=ctest)
	IF ctest EQ 0 then BEGIN
	  axis_log, 'Cannot find aXis2000 source folder  - please locate manually'
		filename = dialog_pickfile(filter='*.ini', /write, /fix_filter, $
			file=filename, path=CodePath, get_path=CodePath, $
			title='Save aXis2000 initialization file as :')
		IF (filename EQ '') THEN BEGIN
			data_directory = current_directory
			GOTO, axis_ini_save_oops 	; trap if CANCEL is chosen in dialog
		ENDIF
 	ENDIF


openw,iunit,filename

print, 'saving aXis2000 parameters to ', filename, ' . . . . '
print, ''

 	on_ioerror, axis_ini_save_oops
printf, iunit, CodePath
printf, iunit, Gr_Dev
printf, iunit, Print_Dev
t=ax_name(DefPath)
t2=ax_name(lfile)
if t(1) EQ '' then printf, iunit, t(0)  + t2(1) + '.' + t2(2) else $
		printf, iunit, DefPath							; changed from DefPath 21-Jul-14 aph
printf, iunit, strcompress(string(gr_scale))
printf, iunit, strcompress(string(ColTbl))
printf, iunit, location
printf, iunit, Print_file
printf, iunit, BufLblFont
printf, iunit, PR_command
printf, iunit, Help_cmd
printf, iunit, Net_command
dt = systime()
printf, iunit, '---------------------------------- '
printf, iunit, 'written: ', dt
printf, iunit, ' '

; --------- print trailer to help users define themselves
printf, iunit, '; ********** Initialization file for AXIS Widget *******************'
printf, iunit, '; '
printf, iunit, '; (aph 19-Nov-11)  Please adapt to your hardware '
printf, iunit, '; Items set                    devices currently supported  '
printf, iunit, '; ---------------------------  -------------------- '
printf, iunit, '0 CodePath                  (e.g. c:\axis2000\) - include final separator'
printf, iunit, '1 Screen display device     (WIN, X)  '
printf, iunit, '2 Print file format		    (PCL, PS) '
printf, iunit, '3 Default data directory    (any - last path wil be saved on exit of AXIS  '
printf, iunit, '4 graphics scale factor     (0.5 - 2) (1 = 360x360 pixels)  '
printf, iunit, '5 color table               (any IDL supports) 0 = B/W; 3 = red temperature '
printf, iunit, '6 location                  (NSLS has special meaning = spooler switch) '
printf, iunit, '7 spooler or print file     (c:\tmp\x1a at nsls - special !!) '
printf, iunit, '8 default font for widget   (windows - Arial*14; unix - 6x10 or 8x13 ) '
printf, iunit, '9 Printer command line      (command line needed to transfer to printer)'
printf, iunit,'10 Command to view Help pdf  (get acrobat reader free from www.adobe.com)'
printf, iunit,'11 command to run browser   (WIN: must be executable from MS-DOS window)'
printf, iunit, ' '
printf, iunit, '   Win95/win98    = "copy idl.ps lpt1: "
printf, iunit, ' some examples of printer command'
printf, iunit, '   NSLS (spooler) = "WLPRSPL -L c:\program files\wlprspl\wlprspl.qs  idl.ps" '
printf, iunit, '   ALS (Unix)    = "lpr -S XRAYS-1 -P 6-BL7LJ4 idl.ps" '
printf, iunit, '   ALS (BL7-Dow) = "lpr -S XRAYS-1 -P 6-BL7LJ4 idl.ps" '
printf, iunit, '   ALS (Dodgson) = "lpr -S XRAYS-1 -P 7-210HP idl.ps" '
printf, iunit, 'form of Help command on Dodgson.ALS.lbl.gov'
printf, iunit,'    c:\progra~1\acrobat3\reader\acroRd32 c:\axis\axis.pdf'
printf, iunit, 'form of Browser command on jabberwocky (standard Netscape install)'
printf, iunit,'    c:\progra~1\netscape\communicator\program\netscape'

printf, iunit,' '

print,'Wrote AXIS parameters as a file "'+filename+'"'

close,iunit
free_lun,iunit
return, filename

axis_ini_save_oops :
	text = 'Saving aXis2000 parameter file (axis.ini) was unsuccessful. Aborting exit'
	print, text
	WIDGET_CONTROL, Uprompt, SET_VALUE=text
	test = ''
	close,iunit
	free_lun,iunit
	return, test
end
