FUNCTION Read_mef, file, Xsize=Xsiz, Ysize=Ysiz, NOFILTER=nof, DEFPATH=DefPath, _extra=e 
 
; + 
; function Read_mef 
; (aph 15-Jul-97)  reads Mephisto (IRIS software) binary files 
; (for TDC coincidence data) 
;  Xsize=Xsiz, Ysize=Ysize  - number of elements in X,Y 
; default = 512x512 (CCD camera output of Mephisto - Jul-97) 
; - 
; (aph 7-aug-97) add type=2d to structure 
; on_error,2 
if n_elements(file) eq 0 then begin  ;popup file dialog box 
   fltr='*.img' 
   if keyword_set(nof) then fltr='*' 
   file=PICKFILE2(/Read, FILTER=fltr, /LPATH, DEFPATH=defpath) 
endif 
 
if strlen(file) GT 0 THEN BEGIN 
	if NOT keyword_set(Xsize) THEN Xsiz = 512 
	if NOT keyword_set(Ysize) THEN Ysiz = 512 
	openr,unit, file, /get_lun 
	readu,unit,text 
	tmp=bytarr(xsiz,ysiz) 
	readu,unit,tmp 
	zd = fltarr(xsiz,ysiz) 
	zd = float(tmp) 
	xd = findgen(xsiz) 
	yd = findgen(ysiz) 
 	xl='x'  &  yl = 'y' 
 	upos = rstrpos(file,'/')       ; check for subdirectory separators 
 	wpos = rstrpos(file,'\') 
 	spos = max([upos,wpos]) 
 	if (spos ne -1) then file=strmid(file,spos+1,strlen(file)) 	; strip leader if it exists 
 	spos=strpos(file,'.') 
 	if (spos ne -1) then file=strmid(file,0,spos)		; strip extension 
 	file=strlowcase(file) 
 	dl = file 
 	tmp = {t:'2d', x:xd, y:yd, d:zd, xl:xl, yl:yl, dl:dl} 
	; correct for image transposition 
 	tmp.d = rotate(tmp.d,7) 
	; distort to compensate for non-square pixels 
	; empirically determined 0.8 (y) factor for old CCD of Mephisto 
		xfactor = 1.0 & yfactor = 0.8 
		tmp.x = tmp.x * xfactor 
 		tmp.y = tmp.y * yfactor 
 		xmin = min(tmp.x)  & xmax = max(tmp.x) & xr = xmax - xmin 
 		ymin = min(tmp.y)  & ymax = max(tmp.y) & yr = ymax - ymin 
 		tx = size(tmp.x) & xsz = tx(1) 
 		ty = size(tmp.y) & ysz = ty(1) 
; 		if xr gt yr then begin  ; shrink x-range to match y-range 
			nysz = fix(yfactor*ysz) 
 			ty = congrid(tmp.y,nysz) 
 			yxtra = (ysz-nysz)/2 &  tyl = fltarr(yxtra) 
			yslope = (ymax-ymin)/nysz 
 			tyl = yslope*(tyl - yxtra) + ymin 
            tyh = fltarr(yxtra) 
 			tyh = yslope*tyh + ymax 
 			for i = 0, yxtra-1 do tmp.y(i) = tyl(i)        ; expand tmp.x 
 			tmp.y(yxtra: yxtra + nysz - 1) = ty 
 			for i = 0, yxtra-1 do tmp.y(i+yxtra+nysz) = tyh(i) 
 			expand,tmp.d, xsz, nysz, td                   ; expand image 
 			for i = 0, yxtra-1 do tmp.d(*,i) = tmp.d(*,0) 
 			tmpdh = tmp.d(*,ysz-1)						; preserve last line 
 			tmp.d(*,yxtra:yxtra+nysz-1) = td 
 			for i = 0, yxtra-1 do  tmp.d(*,i+yxtra+nysz) = tmpdh 
;        endif 
 		s = tmp 
endif else begin 	; go here if user pushes 'cancel' 
    print, ' file name of zero length. Read aborted' 
    s=0 
endelse 
return, s 
end 
 
 
 
 
 
