; Copyright (c) 1998-2016 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		STACK_LIST.PRO
;
;LAST CHANGED: ----------------------------------- 	06 Oct 16
;
; PURPOSE:
;	This function is a wrapper around stack_readlist to convert all stack list files
; to Zimba format (first line is path; subsequent are names ONLY)
; automatic checking for alternate paths if initial path not correct WAS REMOVED
;
; CATEGORY:
;	utility for reading stack_list files
;
; CALLING SEQUENCE:
;	Result = STACK_LIST(list_filename)
;
; INPUTS: list_filename = file containing filename_list
;
;  REQUIRED FORMAT ***********************************
;
; E:\aXis-Pass-Test-data\00-READ\02-STXM-NEXUS\Soleil\
; as-is.axb
; mod.axb
; ****************************************************
; KEYWORDS: none
;
; OUTPUTS: returns 1 if successfully read the files; 0 otherwise
;
; COMMON BLOCKS:
;	AXIS_COM
;
; SIDE EFFECTS: stack list is re-written in the list_filename file
;
; MODIFICATION HISTORY:
; (25-sep-99 aph) force write out in zimba version; this allows zimba to work
; (02-feb-00 aph) ensure path is written in line 1 when rewrite *.sl file
; (17-apr-00 aph) adapt for cases where first line is blank (peem, zimba)
;               major rewrite to convert sphagetti to penne
; (24-Nov-11 aph) rewrote to work with Zimba format list files !!
;                  AXIS standard header added
; (13-Jul-16 aph) added stack_process_com to return filename_list in Zimba format
; (06-Oct-16 aph) tried to fix - it would not read Zimba type stack list files
;                 since it returned all but first file without the path
; (06-Oct-16 aph) drastic rewrite - assume file is in standard form;
;			        if not then direct user how to change it

FUNCTION stack_list, list_filename
@axis_com
@stack_process_com
on_error, 2

 check = 1
sep = ax_sep()


; stack_readlist, list_filename, filename_list
 openr, iunit, list_filename, /get_lun
 i=0
 tmp = ' '
 filename_list = strarr(1)
 while not EOF(iunit) do begin
   readf, iunit, tmp
   filename_list(i) = tmp
   filename_list = [filename_list, ' ']
   i = i + 1
endwhile
close, iunit & free_lun, iunit

;print, '------------------------'
;print, 'INPUT: content of ', list_filename
;for i=0, n_elements(filename_list)-1 do print, filename_list(i)
;print, '------------------------'

sl_path = filename_list(0)
if strmid(sl_path, 0,1,/reverse_offset) NE sep then sl_path = sl_path + sep

nf = 0
tmp = strarr(1)
for i = 1, n_elements(filename_list)-1 do begin
;	print, i, '    ', filename_list(i), ' length = ', strlen(filename_list(i))
	if strlen(filename_list(i)) GT 1 then begin
		tmp=[tmp,' ']
		tmp(nf)= sl_path + filename_list(i)
		nf = nf+1
	endif
endfor

; KLUGE to get around the above code interpreting the last <cr> as a valid name
if strlen(tmp(n_elements(tmp)-1)) LT 2 then tmp = tmp(0:n_elements(tmp)-2)

;print, 'Number of lines in ', list_filename,' = ', n_elements(filename_list)
;print, 'Number of images in stack', ' = ', n_elements(tmp)

filename_list = tmp

;print, '------------------------'
;print, 'OUTPUT: Number of images in stack = ', n_elements(tmp)
;for i=0, n_elements(filename_list)-1 do print, filename_list(i)
;print, '------------------------'


return, check
END

