; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
;+ 
;NAME: 
;	AX_SEP 
; 
;LAST CHANGED: ----------------------------------- 01-jan-00 
; 
;PURPOSE: 
; 	This function returns the valid directories separator 
; for the operating system (system dependent) 
; 
;CATEGORY: 
;	STAND ALONE: utility 
; 
;CALLING SEQUENCE: 
;	Result = AX_SEP() 
; 
;INPUTS: none 
; 
;KEYWORDS: none 
; 
;OUTPUTS: 
;	RESULT = 1-ascii character which is the system separator 
;	Windows = '\', Unix = '/'  Macintosh = ':' 
; 
;MODIFICATION HISTORY: 
; (14-Oct-99 aph) first written 
; (01-jan-00 aph) AXIS standard documentation 
;- 
 
FUNCTION AX_SEP 
sep = '/' 
if strmid(!version.os, 0, 3) EQ 'Win' then sep = '\' 
if strmid(!version.os, 0, 3) EQ 'Mac' then sep = ':' 
 
return, sep 
 
END 
