; Copyright (c) 1998-2010 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AXIS_WEB
;
;LAST CHANGED: ----------------------------------- 04-Jun-18
;
;PURPOSE:
;	This procedure executes a net browser command to access
; synchrotron or other sites via the web.
; The browser command will be system / computer specific and is
; contained in the axis.ini initialization file
;
;CATEGORY:
;	AXIS: utility (captive)
;
;CALLING SEQUENCE:
;	AXIS_WEB, event_X, event_Y
;
;CALLED FROM AXIS:
;	executed while the earth logo visible only
;
;INPUTS:
;	EVENT_X - from Xmanager, X-value of pixel clicked
;	EVENT_Y - from Xmanager, Y-value of pixel clicked
;
;KEYWORDS:
;	SITE - code for web site to go to (to use from "utilities/XRM sites")
;
;OUTPUTS:
;	A new window with the web info is generated.
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;SIDE EFFECTS:
;	A window is created/destroyed.
;
;PROCEDURE:
;	uses IDL spawn command. The form of the Net command MUST be one
; that will operate from an MS-DOS window in win-95. Thus 8.3 file names and
; no embedded blanks in paths.
;
;
;MODIFICATION HISTORY:
; (31-jan-00 aph) first created; adapted to variable size
; (22-aug-00 aph) add link to aXis2000 home base
; (22-aug-01 aph) update axis2000 home base
; (25-Feb-08 aph) update web links
; (21-feb-10 aph) add Elettra, SSRL, update all links and test
; (04-jun-18 aph) update default browser to chrome
;-

PRO axis_web, event_X, event_Y, site = site

@axis_com
on_error,2

if net_command EQ '' then $
    net_command = 'c:\Program Files (x86)\Google\Chrome\Application\chrome.exe'

if NOT keyword_set(site) then begin
    site = 'nowhere'
		webx = fix(float(event_x)/gr_scale)
		weby = fix(float(event_y)/gr_scale)

;	print, webx, weby

	if webx GE -20 AND webx LE 120 then begin
		if weby GE 230 AND weby LE 260 then site = 'ALS'
		if weby GE 185 AND weby LE 215 then site = 'APS'
		if weby GE 140 AND weby LE 165 then site = 'Bessy'
		if weby GE  90 AND weby LE 130 then site = 'CLS'
	endif
	if webx GE 285 AND webx LE 500 then begin
		if weby GE 245 AND weby LE 275 then site = 'Elettra'
		if weby GE 205 AND weby LE 230 then site = 'ESRF'
		if weby GE 160 AND weby LE 190 then site = 'NSLS'
		if weby GE 120 AND weby LE 155 then site = 'PLS'
		if weby GE  75 AND weby LE 110 then site = 'SSRL'
	endif else begin
		if weby LT 70 then site = 'AXIS2000'
	endelse
endif
site = strtrim(site, 2)
; print, 'Contacting XRM web site: ', site

CASE site OF

'ALS': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting ALS web site . . . '
	spawn, net_command + ' http://beamline1102.als.lbl.gov/', /noshell
   end

'APS': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting APS web site . . . '
	spawn, net_command + ' http://www.aps.anl.gov/Xray_Science_Division/Xray_Microscopy_and_Imaging/', /noshell
  end

'Bessy': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting Bessy web site . . . '
	spawn, net_command + ' http://www.helmholtz-berlin.de/forschung/grossgeraete/mikroskopie/arbeitsgebiete/roentgenoptische-methoden-und-instrumentierung_en.html', /noshell
  end

'CLS': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting CLS web site . . . '
	spawn, net_command + ' http://exshare.lightsource.ca/sm/Pages/SM-Home.aspx', /noshell
  end

'Elettra': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting ELETTRA web site . . . '
	spawn, net_command + ' http://www.elettra.trieste.it/beamlines/TWINMIC/', /noshell
  end

'ESRF': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting ESRF web site . . . '
	spawn, net_command + 'http://www.esrf.eu/UsersAndScience/Experiments/Imaging/ID21/', /noshell
  end

'NSLS': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting NSLS web site . . . '
	spawn, net_command + ' http://xray1.physics.sunysb.edu/', /noshell
   end

'PLS': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting PLS web site . . . '
	spawn, net_command + ' http://www-ph.postech.ac.kr/~u7spem/', /noshell
   end

'SSRL': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting SSRL web site . . . '
	spawn, net_command + ' http://www-ssrl.slac.stanford.edu/dichroism/microscopy.html', /noshell
   end

'AXIS2000': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting aXis2000 web site . . . '
	spawn, net_command + ' http://unicorn.mcmaster.ca/aXis2000.html', /noshell
   end

   else: print, 'This web site is unknown'

ENDCASE

end
