;+ 
;NAME: 
;	CHKFILEBLOCKS.PRO 
; 
;LAST CHANGED: ----------------------------------- 11-nov-00 
; 
;PURPOSE: 
;	CHKFILEBLOCKS - determines block structure of a text string 
; 
;CATEGORY: 
;	STAND ALONE: utilities 
; 
;CALLING SEQUENCE: 
;	Result = CHKFILEBLOCKS(FILNENAME) 
; 
;CALLED FROM AXIS: 
;	many procedures 
; 
;ROUTINES 
;	function CHKFILEBLOCKS, FNAME 
;	looks in FILE (fname), counts the number of "blocks" of data, where 
; a block is a (r x c) block of numbers. If there are no blocks found, 
; returns a scalar 0, else returns a (b, 2)-dim array, where b is the 
; block index, (b,0) is the number of rows, (b,1) is the number of columns 
; and (b,2) is the starting row in the file (counting from 0) 
; 
;COMMON BLOCKS: none 
; 
;----------------- 
; FILE ROUTINES -- eli's text format 
;----------------- 
;file structure- 
;line 0: number of items 
;line 1: string=name of first item 
;line 2: size(item) 
;line 3: item, space-delimited 
;line 4: string=name of next item 
;    : 
;    : 
; 
;MODIFICATION HISTORY: 
; (25-may-99 aph) activated print option in textread1 to work with ascii read-in 
; (26-feb-00 aph) AXIS standard documentation 
; (11-nov-00 cgz) migrated from former FILE.PRO
;- 
; ******************************************************************************* 

function chkFileBlocks,fname 
  ;looks in fname, counts the number of "blocks" of data, where 
  ;a block is a (r x c) block of numbers. If there are no blocks found, 
  ;returns a scalar 0, else returns a (b, 2)-dim array, where b is the 
  ;block index, (b,0) is the number of rows, (b,1) is the number of columns 
  ;and (b,2) is the starting row in the file (counting from 0) 
  on_error,2 
  bcnt=-1 
  col=-1 
  row=0 
  barr=intarr(100,3) 
  s='' 
  lcnt=-1 
  openr, unit, fname, /GET_LUN 
  while(not eof(unit)) do begin 
;print,lcnt 
    ;get a line from the file 
    lcnt=lcnt+1 
    readf,unit,s 
    fa=parseString(s) & sfa=size(fa) 
    if sfa(0) gt 0 then begin 
      ;line contains numbers 
      if sfa(1) ne col then begin 
        ;new block size found 
	;setup next block 
        row=1 
        col=sfa(1) 
        bcnt=bcnt+1 
	barr(bcnt,0)=row 
	barr(bcnt,1)=col 
        barr(bcnt,2)=lcnt 
      endif else begin 
	;continuation of previous block 
	row=row+1 
        barr(bcnt,0)=row 
      endelse 
    endif else begin 
      ;non-numerical line found, indicates end of block and maybe new one 
      if(col gt 0) then begin 
 	;end of previous block 
        barr(bcnt,0)=row 
        barr(bcnt,1)=col 
      endif 
      col=-1 
      row=0 
    endelse 
  endwhile 
  if (bcnt ge 0) then ans=barr(0:bcnt,*) else ans=0 
  FREE_LUN, unit 
  return,ans 
end 
 
