; Copyright (c) 1998-2006 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	LITHO_SAVE
;
;LAST CHANGED: ----------------------------------- 22-Feb-06
;
;PURPOSE:
;	This function writes an image as a set of (x,y,t) triplets
; for all non-zero pixels for use as input to STXM_control
; for lthography
;
;CATEGORY:
;	STAND ALONE: utility
;   called from aXis2000 as write~litho
;
;CALLING SEQUENCE:
;	Result = LITHO_SAVE(tmp [, NOF=nof, file=file])
;
;CALLED FROM AXIS:
;	Read->Images->AXIS
;
;INPUTS:
;	TMP - AXIS 2d structure
;
;KEYWORDS:
;	FILE - filename to write
;
;OUTPUTS:
;	RESULT = filename (a blank string if the user cancels)
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;;MODIFICATION HISTORY:
; (04-aug-05 aph) developed from axb_save
; (18-aug-05 aph) add row, column indicators and overall size flag
; (03-Nov-05 aph) add header to indicate Xrange, Yrange and step size
; (22-feb-06 aph) increased number of digits saved for step
;-

function litho_save, tmp, file = file
@axis_com
on_error,2

IF n_tags(tmp) EQ 0 THEN RETURN, 0      ; check that tmp is a 2d structure
IF tmp.t NE '2d' then RETURN, 0

; check if requested file exists; if so launch overwrite dialog
IF keyword_set(file) then begin
	check_flag = 1
	if widget_info(/active) EQ 1 then begin
		if overwrite_all EQ 1 then check_flag = 0
	endif
	if check_flag EQ 1 then begin
		test = findfile(file)
  		if test(0) EQ file then begin
  			if widget_info(/active) EQ 1 then $
		    	t = file_overwrite(group = axis_ID, val = 1) else $
		    	t = file_overwrite(val = 1)
		    if t EQ 0 then file = pickfile2(/write, fltr='*.xyt', $
		                      LFILE = file, title = 'Alternate file name')
		    if t EQ 2 then overwrite_all = 1
		endif
	endif
ENDIF ELSE BEGIN			; filename was not supplied
	fltr='*.xyt'
	if keyword_set(nof) then fltr='*'
	file = pickfile2(/write, filter=fltr, /Lpath, $
	       defpath = WritePath) ;, get_path=WritePath)
	if file EQ '' then return, file
ENDELSE
t = ax_name(file)
file = t(0)+t(1)+'.xyt'
fileshort = t(1)+'.xyt'
; ----- write the structure in (x,y,t) format
openw, iunit, file, /get_lun
; write the header

printf, iunit, '<xyt-header type="no_energy">'
Xrange = tmp.x(n_elements(tmp.x)-1) - tmp.x(0)
Yrange = tmp.y(n_elements(tmp.y)-1) - tmp.y(0)
step = tmp.x(1) - tmp.x(0)

text = '<X-range= "' + string(Xrange, format='(f7.3)')
text = text + '"  Y-range = "' + string(Yrange, format='(f7.3)')
text = text + '"  step = "' + string(step, format='(f8.5)')
text = text + '">'
printf, iunit, text
printf, iunit, "</xyt-header>"

npoints=0
for j = 0, n_elements(tmp.y)-1 do begin
	for i = 0, n_elements(tmp.x)-1 do begin
		if tmp.d(i,j) GT 0 then begin
			printf, iunit, tmp.x(i), tmp.y(j), tmp.d(i,j), fix(j), fix(i)
			npoints=npoints+1
		endif
	endfor
endfor

axis_log, 'wrote ' + string(npoints) + ' points to litho file: ' + fileshort
axis_log, 'Full size of image is ' + string(tmp.x(n_elements(tmp.x)-1)) + $
            ' by '+ string(tmp.y(n_elements(tmp.y)-1))
close, iunit
free_lun, iunit
return, file
END