
EXTRA CD=DE from stack_list.pro  pre-Oct 6, 2016 versions

; ==========  PRE OCTOBER 6, 2016 CODE =======================
; --- FIRST, we will asume it is a Zimba format stacklist file

n_files = n_elements(filename_list)-1
IF (n_files EQ 0) THEN goto, bailout

; ------- CHECK IF FILENAMES are accessible. -----
; assume first line is the path (Zimba format)
first_file = filename_list(0) + filename_list(1)
ftest = findfile(first_file, count=ctest)

; ------ If found, define path and check with second filename --
IF ctest GT 0 then begin
	t = ax_name(filename_list(0))
	if t(0) NE '' then sl_path = t(0) else sl_path = DefPath
	print, 'Path to the files is ', sl_path
	t = ax_name(filename_list(1))
	fnew = sl_path + t(1) + '.' + t(2)
	ftest = findfile(fnew, count=dtest)
	if dtest EQ 0 then check = 0
ENDIF ELSE check = 0

IF check EQ 0 then BEGIN
; -------- the combination of the first and second lines in the stacklist file is not a valid file.
; - either the first line is an invalid path
; .......... or the file format is NOT Zimba (so first line is likely a filename ot blank)
; ....................or the file does not exist

; ------------------------- check if it is a zimba format file --------
 	axis_log, 'first file: ' + first_file + '  was not found'
	axis_log, 'Checking alternate locations'

	t = ax_name(list_filename)	; check if files are in same area as list_filename
	File_Path = t(0)
; PRINT, 'check if files are in same area as list_filename ', File_Path
	fname = filename_list(1)
	t = ax_name(fname)
	fname = t(1) + '.' + t(2)
	fnew = File_Path + fname
	axis_log, 'Path to ' + filename_list(0) + ' is incorrect. Trying . . . ' + fnew
	ftest = findfile(fnew,count=dtest)

	if dtest GT 0 then begin
		sl_path = File_Path
	endif else begin
		axis_log, ' Invalid Path. Select a file from the directory containing the data'
		ftest = pickfile2(/read,filter ='*.*')
		t = ax_name(ftest)
		File_Path = t(0)
		fnew = File_Path + fname
		axis_log, 'Checking that ' + fname + ' is in directory ' + File_Path
		ftest = findfile(fnew,count=etest)
		if etest EQ 0 then goto, bailout
		sl_path = File_Path
	endelse
; -------- check that we have correct information
 print, 'sl_path= ', sl_path
 for i=1, n_elements(filename_list)-1 do print, filename_list(i)

ENDIF

;------  sl_path SHOULD BE correct  - so revise filename_list to zimba format
; making sure each name transferred to the final filename_list exists
n_files = 0
bad_count = 0
t_list = strarr(2)
t_list(0) = sl_path
FOR i = 1, n_elements(filename_list)-1 DO BEGIN
	if strlen(filename_list(i)) GT 1 then begin	; this cures problem if there are extra blank lines
		print, 'checking for existence of ',filename_list(i)
		filename_list(i) = sl_path + filename_list(i)
		ftest = file_search(filename_list(i),count=etest)
		if etest EQ 0 then begin
			print, i, '  Removing ', filename_list(i), ' from list'
			bad_count = bad_count + 1
		endif else begin
			t_list(n_files+1) = filename_list(i)
			t_list=[t_list, ' '] 		; increment the new filename_list by 1 element
			n_files = n_files + 1
		endelse
	endif
ENDFOR
IF bad_count GT 0 then begin
	print, 'There were ', bad_count,' invalid filenames'
	print, 'Cannot find some files in ', list_filename
endif
; ----- force filename_list to have Zimba format ---------
filename_list = t_list

; ---- and rewrite -----
 openw, iunit, list_filename, /get_lun
for i = 0, n_files do printf, iunit, filename_list(i)
close, iunit & free_lun, iunit
t=ax_name(list_filename)
print, 'wrote revised SL data in Zimba format to ' + t(1) + '.' + t(2)
check = 1
; -------- check that we have correct information
print, 'OUTPUT to filename_list just before return'
 print, 'sl_path= ', sl_path
 for i=1, n_elements(filename_list)-1 do print, filename_list(i)
return, check

bailout:
axis_log, 'Cannot find data files. Ending.'
check = 0
return, check

END
