; Copyright (c) 1998-2009 C. Zimba & A.P. Hitchcock  All rights reserved
;+
; NAME:
;	ZSTACK_COLOR.PRO
;	
; LAST CHANGED: -----------------  27-Jul-09 (aph)
; 
; AUTHORS:
;	Carl G. Zimba (NIST)
;
; PURPOSE:
;	Establish color table and color_index variables for ZSTACK suite
;	Called by ZSTACK_ANALYZE.PRO
;
; CATEGORY:
;	Data analysis.
;
; CALLING SEQUENCE:
;	zstack_color
;	
; INPUTS:
;	NONE
;	
; KEYWORD PARAMETERS:
;	show = set to show 16 x 16 grid of color table
;	
; OUTPUTS: 
; 	NONE
; 	
; COMMON BLOCKS:
;	zstack_color_common
;		bottom_color_index			:	index of lowermost color of gradient colorscale
;		top_color_index				:	index of uppermost color of gradient colorscale
;		black_color_index			:	index of black color
;		white_color_index			:	index of white color
;		plot_bkgd_color_index			:	color index for plot background, either black or white
;		plot_axes_color_index			:	color index for plot axes, either whilte or black
;		image_border_color_index		:	color index for image border in zstack_buildlist and zstack_profile dialog windows
;		dragbox_color_index			:	color index for dragbox used to define subregion for alignment
;		corr_ctr_color_index			:	color index for crosshair showing center of correlation function
;		corr_max_color_index			:	color index for crosshair showing maximum of correlation function
;		x_shift_color_index			:	color index for plotting of x-shift
;		y_shift_color_index			:	color index for plotting of y-shift
;		shift_cursor_color_index		:	color index for cursor in shift plot, indicating file number
;		tune_fiducial_color_index		:	color index for fiducial points in closeup of shifted image in zstack_tune dialog window
;		spectra_color_index			:	color indices (14) for plotting of spectra
;		spectra_cursor_color_index		:	color index for cursor in spectra plot, indicating x-ray energy
;		profile_color_index			:	color index for plotting of intensity profile and cursor in profile image indicating row or column
;		profile_cursor_color_index		:	color index for cursor in profile image, indicating x-ray energy
;		profile_spectrum_color_index	:	color index for plotting of profile spectrum
;		test1_color_index			:	color index #1 for testing
;		test2_color_index			:	color index #2 for testing
;		test3_color_index			:	color index #3 for testing
; SIDE EFFECTS:
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Called by ZSTACK_ANALYZE.PRO
; EXAMPLE:
;
; MODIFICATION HISTORY:
; (17-Jul-99 cgz) Modified color table arrangement
;		Moved "hard" colors used for plotting to bottom of color table (i.e., color indices 0-16)
;			and "grayscale" to top of color table (i.e., color indices 16-255)
;		Also put in conditional tests for less than and more than 256 colors
; (30-mar-02 aph) made plot display black on white
; (27-Jul-09 aph) change to external common
;-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO zstack_color, show=show, no_load=no_load
;print,'zstack_color'

@bsif_common
@zstack_common
@zstack_analyze_common
@zstack_build_list_common
@zstack_align_common
@zstack_tune_common
@zstack_spectra_common
@zstack_profile_common
@zstack_save_common
@zstack_display_common
@zstack_color_common

IF keyword_set(show) THEN BEGIN
	device,Get_Visual_Name=thisName, Get_Visual_Depth=thisDepth
	print,thisName,thisDepth,!d.n_colors
ENDIF
IF (!d.n_colors GE 256) THEN BEGIN
	device,decomposed=0
	bottom_color_index	= 16
	top_color_index		= 255
ENDIF ELSE BEGIN
	device,decomposed=0
	bottom_color_index	= 16
	top_color_index		= !d.n_colors - 1
ENDELSE
IF NOT(keyword_set(no_load)) THEN BEGIN
	loadct, 0, ncolors = top_color_index - bottom_color_index, bottom = bottom_color_index
			; load Black & White Linear color table for imaging
	; Construct a color scale for plots
	tvlct,	[  0,  50, 255,   0,   0, 255, 255,  51, 255, 255, 112, 219, 255,   0, 255, 255], $
			[  0, 125,  43, 220, 255,   0, 255, 255, 187, 127, 219, 112, 127, 200, 171, 255], $
			[  0, 255,   0,   0, 255, 255,   0,   0,   0, 127, 147, 219,   0, 255, 127, 255], 0
	indexvec =	[  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15]
	;		'Black', 'Blue', 'Red', 'Green', 'Magenta', 'Cyan', 'Yellow', 'Lime',
	;		'Gold', 'Pink', 'Aquamarine', 'Orchid', 'Pumpkin', 'Sky', 'Beige' 'White', ]
	; Construct a color scale for plots
	;	using colors derived from McIDAS (Man computer Interactive Data Access System
	;	at University of Wisconsin-Madison Space Science and Engineering Center)
	;tvlct,		[  0, 255,   0, 255,   0, 255,   0,   0, 255, 255, 112, 219, 127,   0, 255, 255], $
	;			[  0,   0, 255, 255, 255,   0,   0,   0, 187, 127, 219, 112, 127, 163, 171, 255], $
	;			[  0, 255, 255,   0,   0,   0, 255, 115,   0, 127, 147, 219, 127, 255, 127, 255], 0
	;indexvec =	[  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15]
	;			'Black', 'Magenta', 'Cyan', 'Yellow', 'Green', 'Red', 'Blue', 'Navy',
	;			'Gold', 'Pink', 'Aquamarine', 'Orchid', 'Gray', 'Sky', 'Beige' 'White', ]
ENDIF
black_color_index			= 0
white_color_index			= 15
plot_bkgd_color_index			= 15
plot_axes_color_index			= 0
image_border_color_index		= 8
image_blgd_color_index		= 0
dragbox_color_index			= 2
corr_ctr_color_index			= 2
corr_max_color_index			= 1
x_shift_color_index			= 2
y_shift_color_index			= 6
shift_cursor_color_index		= 1
tune_fiducial_color_index		= 5
spectra_color_index			= [1,2,3,4,5,6,7,8,9,10,11,12,13,14,1]
	; first one is ALWAYS for i0
spectra_cursor_color_index		= 1
profile_color_index			= 6
profile_cursor_color_index		= 2
profile_spectrum_color_index	= 15
test1_color_index			= 3
test2_color_index			= 11
test3_color_index			= 5
;move zstack names and indices to zstack_color_common
zstack_color_def_names = [	'Image Background', $
					'Image Border', $
					'Plot Background', $
					'Plot Axes', $
					'Dragbox', $
					'Corr Fn Center', $
					'Corr Fn Maximum', $
					'X Shifts', $
					'Y Shifts', $
					'Shift Plot Cursor', $
					'Fiducial Marks', $
					'Spectra Plot Cursor', $
					'Profile Line', $
					'Profile Spectrum'	]	; ,$	]
;					'Test Color 1', $
;					'Test Color 2', $
;					'Test Color 3'		]
zstack_color_def_indices = [	image_blgd_color_index, $
						image_border_color_index, $
						plot_bkgd_color_index, $
						plot_axes_color_index, $
						dragbox_color_index, $
						corr_ctr_color_index, $
						corr_max_color_index, $
						x_shift_color_index, $
						y_shift_color_index, $
						shift_cursor_color_index, $
						tune_fiducial_color_index, $
						spectra_cursor_color_index, $
						profile_color_index, $
						profile_cursor_color_index, $
						profile_spectrum_color_index, $
						test1_color_index, $
						test2_color_index, $
						test3_color_index	]
IF keyword_set(show) THEN cindex
;tvlct,r,g,b,/get
;colormat = intarr(16,4)
;colormat[*,0] = r[240:255]
;colormat[*,1] = g[240:255]
;colormat[*,2] = b[240:255]
;colormat[*,3] = indexvec
;print,colormat
return
END