;+ 
;NAME: 
;	MATH.PRO 
; 
;LAST CHANGED: ----------------------------------- 15-nov-00 
; 
;PURPOSE: 
;	This is a set of array functions 
;	DIMEN		- determines dimension of array
;	NCOLS		- determines number of columns in array
;	NROWS		- determines number of rows in array
; 
;CATEGORY: 
;	STAND ALONE: utilities 
; 
;CALLING SEQUENCE: 
;	Result = DIMEN(ARRAY) 
;	Result = NCOLS(ARRAY) 
;	Result = NROWS(ARRAY) 
; 
;CALLED FROM AXIS: 
;	many procedures 
; 
;ROUTINES 
;	function DIMEN, ARRAY 
;	returns the size of the nth (starting from 0) dimension of ARRAY
; 
;	function NCOLS, ARRAY 
; 	returns the number of columns of ARRAY 
; 
;	function NROWS, ARRAY 
;	returns the number of rows of ARRAY
; 
;COMMON BLOCKS: none 
; 
;MODIFICATION HISTORY: 
; (08-nov-00 cgz) AXIS standard documentation 
; (08-nov-00 cgz) created MATH procedure, 
;			to be used to compile other functions when called from AXIS startup
; (08-nov-00 cgz) migrated INTERP and INTERSPLINE to separate files as functions
; (08-nov-00 cgz) eliminated MEAN function, superceded by IDL primitive MEAN
;		can probably eliminate some of these small functions
;		why have dimen, ncols, nrows when these can be handled by IDL primitive
; (15-nov-00 cgz) replaced calls of DIMEN, NCOLS, and NROWS in all other AXIS functiosn and procedures
;		DIMEN : LOADSPEM, PARSEBYTES, RD_SPEM
;		NCOLS : GEN_READ, INTERP, LN_LOAD, MISC, PLOT2D, READ_A_N, READ_ALS, 
;				READ_NUMBERS, SPLOT2D, SPLOT3D, SPLOTA
;		NROWS : LN_LOAD, PLOT2D, READ_A_N, READ_ALS
;		MATH.PRO is now obsolete and can be eliminated
;- 
; ******************************************************************************* 

function dimen,arr,n
  sz=size(arr)
  return,sz(n+1)
end

function ncols,arr
  return,dimen(arr,0)
end

function nrows,arr
  return,dimen(arr,1)
end

Pro math
;	print,'Math functions compiled'
	; used to compile only (08nov00 cgz)
	dummy = [1,2,3]
	out = dimen(dummy, 0)
	out = ncols(dummy)
	out = nrows(dummy)

return	;, 'Math functions compiled'
end

