; Copyright (c) 1998-2021 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_FIX_ROLLOVER
;
;LAST CHANGED: ----------------------------------- 24-Jun-21 (aph)
;
;PURPOSE:
;	This function modifies one or a sequence of *.nc image files
; to replace all values below 0 with (that value + 65,535.)
; This repairs a roll-over issue in conversion of some image files
; typically, those which are read as unsigned integers rather than signed ones
;
;CATEGORY:
;	AXIS: image analysis
;
;CALLING SEQUENCE:
; for functions:
;	Result = AX_FIX_ROLLOVER()
;
;CALLED FROM AXIS:
;	->Images->Fix rollover

;INPUTS: none
;
;KEYWORDS:
;	ONE		array to which fix_rollover will be applied
;
;OUTPUTS:
;	repaired files are written to disk.
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;MODIFICATION HISTORY:
; (04-Jul-00 aph) first version
; (04-Jan-15 aph) add keyword, one, an option to process 1 file
; (24-Jun-21 aph) change to use *.axb files; allow user to select multiple files; adapt for roll over by 2pi (phase)
;-
FUNCTION ax_fix_rollover, one=one, pi=pi

@axis_com
@bsif_com
on_error,2

; ----------- fix roll_over in current image displayed in aXis2000 ;  done in axis2000
IF keyword_set(one) then begin
;	neg_ind = where(one LT 0, count)
;	if count GT 0 then begin
;       	one(neg_ind) = one(neg_ind)+ 65535.
;	endif
;	return, one

ENDIF ELSE BEGIN
; ----- original version processed a set of *.nc files		; changed to *.axb files (25-Jun-21 aph)


;	WIDGET_CONTROL, Uprompt, BAD_ID = BadID, SET_VALUE='pick first file of sequence'
;	file1=PICKFILE2(/Read, FILTER='*.nc', /LPATH, DEFPATH=defpath)
;	if strlen(file1) GT 0 THEN BEGIN
;	 WIDGET_CONTROL, Uprompt, BAD_ID = BadID, SET_VALUE='pick last file of sequence'
;	 file2=PICKFILE2(/Read, FILTER='*.nc', /LPATH, DEFPATH=defpath)

; ----- use dialog_pickfile(/multiple) to get list of all files to process
	filelist = Dialog_Pickfile(/Read, FILTER='*.axb', /multiple, PATH=defpath, get_Path = DefPath)
;	print, filelist
	if n_elements(filelist) LE 1 then begin
		axis_log, 'image~fix_rollover~many requires at least 2 images'
		return, 0
	endif
; assumes last 3 numbers before the '.' are a sequence number
;	dot = strpos(filelist(0),'.')
;	fileroot=strmid(filelist(0), 0, dot-3)
;	first = fix(strmid(filelist(0),dot-3,3))
;	last  = fix(strmid(filelist(n_elements(filelist)-1),dot-3,3))

; allow any extension by picking up ext from pickfile choice (aph 14-feb-98)
;	t = ax_name(filelist(0)
;	ext = t(2)
;	mask = 100

	if keyword_set(pi) then begin
		low_limit = -3.124
		roll_over = 6.283 		; 2pi = 6.28318530718
	endif else begin
		low_limit = 0
		roll_over = 65535.
	endelse
	for i = 0, n_elements(filelist)-1 do begin
;		WIDGET_CONTROL, /hourglass
;		num = strmid(strtrim(string(1000+i),2),1,3)
;		file = fileroot+num+'.'+ext
;			tmp = read_bnl(file)		; changed to *.axb files
		tmp = axb_load(file=filelist(i), /silent)
		count = 1
		countall=0
 		WHILE count GT 0  DO begin				; multiple roll-overs can occur !
 			neg_ind = where(tmp.d LT low_limit, count)
 			if count GT 0 then begin
 				countall = countall + count
		       	tmp.d(neg_ind) = float(tmp.d(neg_ind)) + roll_over
;	 	     	tmp.d(1,1) = tmp.d(1,1) +1e-6*tmp.d(1,1)   ; kluge to force REAL *,nc file !
	 	    endif
  		ENDWHILE
  		print, filelist(i), ' fixed ', countall, ' roll overs'

		tf=axb_save(tmp, file=filelist(i), /silent, /overwrite)	; OVERWRITE input file
		t=ax_name(tf)
;		WIDGET_CONTROL, Uprompt, BAD_ID = BadID, $
;		    SET_VALUE='Rollover fixed image ' + string(t(1) + '.' + t(2))
	endfor
	return, 1
ENDELSE

end
