; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
;+ 
;NAME: 
;	PLOT3D.PRO 
; 
;LAST CHANGED: ----------------------------------- 15-apr-00 
; 
;PURPOSE: 
;	This generates a shade_surface 3d plot of an image. 
; 
;CATEGORY: 
;	STAND ALONE image processing 
; 
;ROUTINES: 
;	PLOT3D, G_data, xx, yy, xylabels, AZ=zang, _extra=e 
;			xylabels=['xlabel','ylabel'] 
; 
;CALLED FROM AXIS: 
;	->via splot3d routine exclusively 
; 
;INPUTS: 
;	G_data	(z) data to plot 
;	xx		(X) - values 
;	yy		(Y) - values 
;	xylabels  labels 
 
;KEYWORDS: 
;	AZ			- Z-angle plot log(G-data) 
;	CHARSIZE	- specify character size for labels 
 
;OUTPUTS: generates a window if run stand-alone 
; 
;COMMON BLOCKS: 
;	@AXIS_COM	standard set of common blocks 
; 
;MODIFICATION HISTORY: 
; 12/2/95  jdd fixed labels in plot3d 
; 6/15/96  jdd move SPLOT stuff to separate procedure 
; ----------- AXIS modifications ------- 
; (15-apr-00 aph) AXIS standard documentation 
;- 
 
pro PLOT3D, G_data, xx, yy, labels, AZ=zang, CHARSIZE=cs, _extra=e 
on_error,2 
 
;if keyword_set(ix) then xra=rotate(xra,2) 
;if keyword_set(iy) then yra=rotate(yra,2) 
 
 xt=' ' 
 yt=' ' 
 CASE n_elements( labels ) OF 
 1: begin 
 	xt=labels(0) & yt=labels(0) 
    end 
 2: begin 
 	xt=labels(0) & yt=labels(1) 
    end 
 ELSE: 
 ENDCASE 
 
csz=2. 
if (keyword_set(cs) eq 1) then csz=cs 
 
za=30. 
if (keyword_set(zang) eq 1) then za=float(zang) 
za = ((za MOD 360.) +360.) MOD 360. 
iz = floor(za/90.) 
;iz = ( (floor(za/90.) MOD 4) +4) MOD 4 
 
CASE iz OF 
1: begin 
     data1=rotate(G_data, 1) 
     x1=rotate(yy,2) 
     y1=xx 
     za1=za-90. 
     xra=[max(x1),min(x1)] 
     yra=[min(y1),max(y1)] 
     xt2=yt & yt2=xt 
   end 
0: begin 
     data1=G_data 
     x1=xx 
     y1=yy 
     za1=za 
     xra=[min(x1),max(x1)] 
     yra=[min(y1),max(y1)] 
     xt2=xt & yt2=yt 
   end 
3: begin 
     data1=rotate(G_data, 3 ) 
     x1=yy 
     y1=rotate(xx,2) 
     za1=za-270. 
     xra=[min(x1),max(x1)] 
     yra=[max(y1),min(y1)] 
     xt2=yt & yt2=xt 
   end 
2: begin 
     data1=rotate(G_data, 2 ) 
     x1=rotate(xx,2) 
     y1=rotate(yy,2) 
     za1=za-180. 
     xra=[max(x1),min(x1)] 
     yra=[max(y1),min(y1)] 
     xt2=xt & yt2=yt 
   end 
ENDCASE 
print, iz, za, za1 
;don't allow IDL default to round limits 
;xra=[min(x1),max(x1)] 
;yra=[min(y1),max(y1)] 
 
shade_surf, data1, x1, y1, az=za1, $ 
   charsize=csz, zstyle=4+1, xminor=1, yminor=1, $ 
   xrange=xra, yrange=yra, xstyle=1, ystyle=1, $ 
   xtitle=xt2, ytitle=yt2, $ 
   background=255, color=0, _extra=e 
 
end 
