; Copyright (c) 1998-2025 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_ZOOM_CUT
;
;LAST CHANGED: ----------------------------------- 31-Dec-24 (aph) from 07-Nov-2023
;
;PURPOSE:
;	This procedure cuts out a region from an AXIS image
; based on numerical limits, given either in data-units (typically microns) or pixels.
;
;CATEGORY:
;	AXIS: image analysis
;
;CALLING SEQUENCE:
;	AX_ZOOM_CUT, limits=limits
;
;CALLED FROM AXIS:
;	Zoom->Images->Numerical
;
;INPUTS: mode - either 'data'  or 'pixels' ==> used to define the units
;
;KEYWORDS:
;	LIMITS  [xmin,xmax,ymin,ymax] in data units or pixel units
;	MESH	[x-pixels, y-pixels] - number of pixels
;	NO_PLOT  if set, do not plot

;
;OUTPUTS:
;	Modified image placed in buffer 0.
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;MODIFICATION HISTORY:
; (15-nov-99 aph) isolated from axis_c
; (01-jan-00 aph) AXIS standard documentation
; (17-apr-01 aph) added E to output structure
; (29-dec-01 aph) changed to procedure; set up for macro operation
; (31-dec-01 aph) add keyword MESH = [number of x, y pixels] - to ensure equal size outputs
; (23-feb-06 aph) add no_plot keyword to allow use for zooming
; (28-Aug-22 aph) put tag at end of header
; (07-Nov-23 aph) add mode as required keyword
;                   use cll, cur common variable to store either data or pixel units
; (31-Dec-24 aph) save data units seperately than pixel units
; -

Pro ax_zoom_cut, mode, limits=limits, mesh = mesh, no_plot=no_plot
@axis_com
on_error,2

;Get the data for this buffer, check if there is any
HANDLE_VALUE, Data(CurBuf), tmp
IF n_tags(tmp) EQ 0 THEN RETURN
IF tmp.t NE '2d' then begin
	WIDGET_CONTROL, Uprompt, SET_VALUE='Zoom.images: not for spectra'
	RETURN
ENDIF

	SetGraf,'MainImg'     ; restore image (x,y) scaling parameters

; use the mode variable to identify the units (data or pixels)   ; (7-Nov-23 added)
; if want to incorporate in to a macro, use cll or cur to  provide limits and mode in the call

	if keyword_set(limits) then begin
		cll(0) = limits(0) & cll(1) = limits(2)
		cur(0) = limits(1) & cur(1) = limits(3)
	endif
;
; ------------- if pll or pur are not defined set to 0
	if n_elements(pll) EQ 0 then begin
		pll=intarr(2) & pur=intarr(2)
		pll(0) = 0   &  pll(1) = 0
		pur(0) = 0 	 &  pur(1) = 0
	endif

CASE mode OF

'data': BEGIN

	ll = fltarr(2)	& ur = fltarr(2)
; ------  set limits in DATA UNITS from either the values given in limits, or by asking user
	ll(0) = get_num(prompt='X-min',val=cll(0), group=axis_ID)
	ur(0) = get_num(prompt='X-max',val=cur(0), group=axis_ID)
	ll(1) = get_num(prompt='Y-min',val=cll(1), group=axis_ID)
	ur(1) = get_num(prompt='Y-max',val=cur(1), group=axis_ID)

	cll(0) = ll(0)  &  cll(1) = ll(1)         ; save limits
	cur(0) = ur(0)  &  cur(1) = ur(1)
	Ilo = DIndex(ll(0),ll(1),tmp)
	Ihi = DIndex(ur(0),ur(1),tmp)
	zoom_tag = ' Zd'
END

'pixels': BEGIN
; --------  set limits in PIXELS from either the values given in pixels, or by asking user
	Ilo = fltarr(2)  &   Ihi  = fltarr(2)
	Ilo(0) = get_num(prompt='pixel-X-min', val=pll(0), group=axis_ID)
	Ihi(0) = get_num(prompt='pixel-X-max', val=pur(0), group=axis_ID)
	Ilo(1) = get_num(prompt='pixel-Y-min', val=pll(1), group=axis_ID)
	Ihi(1) = get_num(prompt='pixel-Y-max', val=pur(1), group=axis_ID)

    pll(0) = Ilo(0)  &  pll(1) = Ilo(1)    ; save pixel limits in  variables different from data limits
	pur(0) = Ihi(0)  &  pur(1) = Ihi(1)
	zoom_tag = ' Zp'
END

ELSE: axis_log, 'Please choose either "data" or "pixels'

ENDCASE

;Set the zoom
;!x.range(0) = Ilo(0) & !x.range(1) = Ihi(0)
;!y.range(0) = Ilo(1) & !y.range(1) = Ihi(1)
; Ilo = DIndex(ll(0),ll(1),tmp)
; Ihi = DIndex(ur(0),ur(1),tmp)
;		print, 'Zoom range '
;		print, 'Data X ', ll(0), ur(0)
;		print, 'Data Y ', ll(1), ur(1)
;		print, 'Device X ', Ilo(0), Ihi(0)
;		print, 'Device Y ', Ilo(1), Ihi(1)
xn = tmp.x(Ilo(0):Ihi(0))	; cut out the zoomed data from tmp
yn = tmp.y(Ilo(1):Ihi(1))
dn = tmp.d(Ilo(0):Ihi(0),Ilo(1):Ihi(1))
tmp = create_struct('t','2d','x',xn,'y',yn,'d',dn, $
	'xl',tmp.xl,'yl',tmp.yl,'dl',tmp.dl + zoom_tag, 'E', tmp.e)


if keyword_Set(mesh) then tmp = ax_interp(tmp, mesh=mesh)

; write to buffer 0
CurBuf = 0
HANDLE_VALUE, Data(CurBuf), tmp, /set
Label(CurBuf) = tmp.dl


if NOT keyword_Set(no_plot) then  PlotBuf,CurBuf, Zvalues=Zrng

return
end
