; Copyright (c) 1995, ALS SpectroMicroscopy Facility, er, jdd 
;+ 
;NAME: 
;	READSTRBIG 
; 
;LAST CHANGED: ----------------------------------- 14-nov-00 
; 
;PURPOSE: 
;	This function reads all data up to the next end of line character 
; from an identified logical unit into a string of arbitrary size. 
; It is equivalent to readf,unit,s where s is a string 
; The function gets around 32K buffer limit to load lines up to 64K long 
; It also recognizes  multi-OP-system end of line characters 
; 10 (unix), 1010 (?), 1013 (DOS), 13 (mac), 1313 (mac,text) 
; 
;CATEGORY: 
;	STAND ALONE: utility (als) 
; 
;CALLING SEQUENCE: 
;	Result = READSTRBIG(unit) 
; 
;CALLED FROM AXIS: 
;	->ALS file read in routines 
; 
;INPUTS: 
;	UNIT - logical unit to read 
; 
;KEYWORDS: 
;	BYTE - read in treated as byte-coded characters 
; 
;OUTPUTS: 
;	The result is a string. If not successfully read, a blank string is returned. 
; 
;COMMON BLOCKS: none 
; 
;MODIFICATION HISTORY: 
; (xx-mmm-96  er) created 
; (27-feb-00 aph) AXIS standard documentation 
; (14-nov-00 cgz) Replaced call of CHR function by explicit STRING(BYTE())
;- 
 
;function readStringBig 
;equivalent to readf,unit,s where s is a string 
;gets around 32K buffer limit to load lines up to 64K long 
;also handles 1010, 1013, 13, 1313 end of line characters 
 
function readStringBig,unit,byte=byt 
  on_error,2 
  s=0B 
  s2='' 
  i=long(0) 
  done=0 
 
  while not(eof(unit) ) and (not done) do begin 
     ;possible end-of-line character sequences: 
     ;  13=mac 
     ;  10=unix 
     ;  13,13=mac after "fetching" as text 
     ;  10,13=DOS 
     ;  10,10=unknown, but this should take care of it 
     if (s eq 10) or (s eq 13) then begin 
        ;see if following character is 13B -- if so, discard, else back up one character 
        point_lun,-1*unit,cur_pos 
        readu,unit,s 
        if (not eof(unit)) then begin 
          if (s ne 13) and (s ne 10) then begin 
            ;print,'here' 
            point_lun,unit,cur_pos 
          endif 
        endif 
        done=1 
     endif 
     if (s ne 0) and (not done) then begin 
       if keyword_set(byt) then begin 
         if (i eq 0) then s2=[s] else s2=[s2,s] 
;       endif else s2=s2+chr(s) 
       endif else s2=s2+string(byte(s))
     endif 
     i=i+1 
     if not done then readu,unit,s 
  endwhile 
  return,s2 
end 
 
;pro testRead 
;  on_error,2 
;  f=pickfile2() 
;  unit=2 
;  openr,unit,f 
;  while not eof(unit) do begin 
;  	s=readStringBig(unit) 
;  	print,s 
;  endwhile 
;  close,unit 
;end