; Copyright (c) 1998-2016 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		STACK_READ_LIST
;
;LAST CHANGED: ----------------------------------- 	19 Dec 2016
;
; PURPOSE:
;	This procedure
;
; CATEGORY:
;	Image display.
;
; CALLING SEQUENCE:
; for procedures:
;	STACK_READ_LIST, FILE=FILE, TYPE=TYPE,
;
; INPUTS: only keywords
;
; KEYWORDS:
;	FILE
;   TYPE
;
; OUTPUTS:
;	No explicit outputs.   A new window is created if necessary
;
; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;
;
; SIDE EFFECTS:
;
; MODIFICATION HISTORY:
; (19-Dec-16 aph) code extracted from stack_process.pro and adapted to pad to smae sizes if needed
;-


PRO STACK_READ_LIST, FILE=FILE, TYPE=TYPE
@axis_com
@bsif_com
@stack_process_com

COMMON volume_data, image_stack

; get stack list filename if not provided

; -- adapt to read a set of *.axb images ------  (24-nov-11  aph)
	print,'first file should be: ',  filename_list(0)
	t=ax_name(filename_list(0))
	img_type = t(2)
	print, 'Image type is ', img_type

;	if img_type NE 'nc' OR img_type NE 'axb' then begin
;		axis_log, 'sl file lists image types that cannot be read ' + img_type
;		return
;	endif
; ------- read in 1 image to establish array sizes
	CASE img_type OF
		'nc': read_stxm,filename_list(0),sd,khz
		'axb': BEGIN
			print, 'reading *.axb file ',filename_list(0)
		    tmp = axb_load(file=filename_list(0), /silent)
		    n_cols = n_elements(tmp.x) & n_rows = n_elements(tmp.y)
		  end
	ENDCASE

	image_stack = fltarr(n_cols,n_rows,n_elements(filename_list))
	ev = fltarr(n_elements(filename_list))
	filename_ev_msec_list = strarr(n_elements(filename_list))

;	print, 'filename_list'
;	print, filename_list
	FOR i=0,(n_elements(filename_list)-1) DO BEGIN

		CASE img_type OF
		'nc': BEGIN
		    read_stxm,filename_list(i),sd,khz
		    ev(i) = 12398.52/sd.wavelength
		    image_stack(0:(n_cols-1),0:(n_rows-1),i) = khz
		    dwell = sd.dwell_time
			end
		'axb': BEGIN
			print, 'reading *.axb file ',filename_list(i)
			tmp = axb_load(file=filename_list(i), /silent)
		    ev(i) = tmp.e
		    sd.wavelength = 12398.52/ev(i)
		    n_cols = n_elements(tmp.x) & n_rows = n_elements(tmp.y)
		    x_start = tmp.x(0) & x_stop = tmp.x(n_elements(tmp.x)-1)
		    y_start = tmp.y(0) & y_stop = tmp.y(n_elements(tmp.y)-1)
		    image_stack(0:(n_cols-1),0:(n_rows-1),i) = tmp.d
		    d_pos =  strpos(tmp.xl, 'dwell =')
		    if d_pos GT 0 then begin
		    	t_string = strmid(tmp.xl,d_pos+7)
		    	t = strsplit(t_string, ' ', /extract)
		    	dwell = float(t(0))
		    endif else dwell = 1.
		    sd.dwell_time = dwell
		    end
		ENDCASE
	; APH (16-apr-98) - modified to dump PATH info
	; ********        filename_list(i)changed to filenm *********
		if !VERSION.OS_FAMILY EQ 'unix' then sep = '/' else sep = '\'
		filenm =  string(filename_list(i))
		filenm=strmid(filenm,rstrpos(filenm,sep)+1,strlen(filenm))
		filenm = strmid(filenm,0,strpos(filenm,'.'))
	    filename_ev_msec_list(i) = filenm  + ' : '+$
	        strtrim(string(ev(i),format='(f10.2)'),2)+' eV '+$
	        strtrim(string(dwell,format='(f7.2)'),2)+' msec'
	; APH - end of changes
	ENDFOR
ENDIF

