;+ 
; 
; Copyright (c) 1999, Adam Hitchcock  All rights reserved. 
;	Unauthorized reproduction prohibited. 
; 
; NAME: 
;	READ_CRYO 
; 
; PURPOSE: 
;	This function reads a cryo-STXM image file, converts it to NetCDF format, then reads that file into 
;   the standard 2d structure used internally in AXIS (ALS format) 
; 
; CATEGORY: 
;	Data analysis / conversion: 
; 
; CALLING SEQUENCE: 
; 
;	Result = READ_CRYO() 
; 
; INPUTS: 
; 
; KEYWORD PARAMETERS: 
;	FILE:  provides filename and thus pickfile dialog not launched (/silent) 
; 
; OUTPUTS: 
;	RESULT is a 2d image in AXIS 2d data structure 
;   s = {t:'2d', x:x, y:y, d:d, xl:x_label, yl: y_label, dl: data_label} 
; 
; 
; COMMON BLOCKS: 
;	@axis_com 
; 
; 
; PROCEDURE: 
;	uses cryo_to_stxm routine to convert to *.nc, then uses read_bnl routine to read into axis 
; 
; EXAMPLE: 
 
;	Can be used as stand-alone (in which case a structure is returned 
;	 or as part of AXIS widget. 
; 
;		tmp = read_cryo() 
; 
; MODIFICATION HISTORY: 
; (15-sep-99) Written by: Adam Hitchcock - based on Jacobsen cryo_to_stxm routine. 
; (18-sep-99 aph) auto-correct *.nc file for no NaN or inf data 
; (17-Oct-99 aph) improve header. change name to READ_CRYO (was rd_cryo) 
;- 
 
 
Function READ_cryo, File = File 
 
on_error,2 
@axis_com
@bsif_com
 
null='' 
 
if NOT keyword_set(file) then begin 
	sxm_file = pickfile2(/read,FILTER='*.sxm', /LPATH, DEFPATH=defpath) 
	if sxm_file EQ '' then return, null 
endif else sxm_file = file 
 
; ------------- convert from sxm to NetCDF format and write 
cryo_to_stxm, sxm_file 
 
; ----------- read the NetCDF file 
t = ax_name(sxm_file) 
nc_file = t(0) + t(1) + '.nc' 
print, sxm_file, ' converted to NetCDF file ', nc_file 
 
s = read_bnl(nc_file) 
 
; ----------- replace NaN values with 0. 
bad_data = where(finite(s.d) EQ 0,count) 
if count gt 0 then begin 
	s.d(bad_data) = 0. 
	print, 'nc_cryo: WARNING - NaN or Inf pixels set to 0' 
endif 
 
; ----------- re-write nc file without NaN values 
file=sav_nsls(s, file=nc_file) 
 
return, s 
 
END 
