; Copyright (c) 1998-2024 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	READ_NANOMAX_PTYCHO.PRO
;;
;LAST CHANGED: ----------------------------------- 	04 Apr 2024 (aph)

; PURPOSE:
;	This function reads an image from a single NanoMAX h5 file inthe PROCESS folder
;
; CATEGORY:
;	    Runs stand alone or inside aXis2000.
;
; CALLING SEQUENCE:
;	RESULT = READ_NANOMAX_PTYCHO(file = file, path=path, silent = silent, verbose=verbose, group = group)
;
; INPUTS:
;	FILE	filename.
;
; KEYWORDS:
;	KEY1:  none
;
; OUTPUTS:
;
;
; COMMON BLOCKS:
; AXIS_COM    standard set of common blocks
; stack_process_com
; COMMON volume_data, image_stack
; bsif_com


; MODIFICATION HISTORY:
; (27-Mar-24 aph) first version
; (04-Apr-24 aph) verified it works on images in procerss, but NOT in raw

;-


FUNCTION  read_nanomax_ptycho, file = file, path=path, silent = silent, verbose=verbose, group = group
@axis_com
@stack_process_com
COMMON volume_data, image_stack
@bsif_com

on_error,2

null = 0

; ------------ select NanoMAX  *.h5 file(s)

if NOT keyword_set(file) then begin
    file = dialog_pickfile(title='Select NanoMAX  *.h5 file',filter=['*.h5'], path=DefPath, get_path=folder_path)
	DefPath=folder_path    ; --- force path for writing to be the source folder
endif
t = ax_name(file)
DefPath=t(0)
if NOT keyword_set(silent) then print, 'default path set to  ', DefPath

; ----------- single image read-in -------
if strlen(file) EQ 0 then RETURN, null
if NOT keyword_set(silent) then print, 'NanoMAX_ptycho_data_file = ' ,file
t =ax_name(file)
fileshort = t(1)



a = h5_parse(file, /read_data)

; --------- get dimensions of image from the header string
; ----------- TYPICAL string      npointflyscan  sx   -8   0   40   sy   0.4   4.0   18   0.1
;hdr =  a.entry.description._data
;h =strsplit(hdr,/extract)
;;' print, 'HEADER   ', h
;type = h(0)
;xmin = float(h(2))
;xmax = float(h(3))
;nx =   fix(h(4))+1
;ymin = float(h(6))
;ymax = float(h(7))
;ny =   fix(h(8))+1
;; print, 'Dwell (s) ', h(9)
;dwell = float(h(9))
; -- verify
if NOT keyword_set(silent) then print, 'Opening file ', fileshort



; ------------ generate (x,y), energies, and dwell values from *.h5 file


; nx = get_num(prompt='Number of x-points ', val = nx)  ;,  group = Axis_ID)
; ny = get_num(prompt='Number of y-points ', val = ny)  ; ,  group = Axis_ID)
;energy = get_num(prompt='Photon energy ', val = energy)  ;  group = Axis_ID)


energy = a.scan._data
x = a.x._data
nx = n_elements(x)
y = a.y._data
ny = n_elements(y)

d = a.stxm_map_eiger._data

x_start = x(0)
x_stop  = x(nx-1)
; x_step = (xmax - xmin) /(nx-1)
; x = findgen(nx)*x_step + xmin
y_start = y(0)
y_stop  = y(ny-1)
n_rows = nx
n_cols = ny
xl = '  ' +  string(energy) + ' eV.  '
yl = ' '

; flip
d = rotate(d, 7)
y = reverse(y)

img = {t:'2d', x:x, y:y, xl:xl, yl:yl, e:energy, d:d, dl:fileshort}


return, img

end