; Copyright (c) 1998-2025 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		AX_ISEELS_DISPLAY
;
;LAST CHANGED: ----------------------------------- 	26 Aug 2025 (aph, from 26 Aug 2025, 01 May 2025 (aph)
;
; PURPOSE:
;	This  is a widget that reads an ISEELS data file  (*.os or *.txt)
;   displays a standard view of the header and the data
;	and optionally saves a png of the on-screen display

; CATEGORY:
;	stand alone or called from aXis2000
;
; CALLING SEQUENCE:
;	AX_ISEELS_DISPLAY, file=file, raw=raw, os=os, itype=itype, flat_table=flat_table, plot=plot, save=save
;
; REQUIRED INPUTS: none.
;
; KEYWORDS:
;	FILE:	file name
;   ITYPE:	type of data base file (not implemented since auto analysis was implemented)
;   PLOT:   plot spectra
;	SAVE:	write png of the displayed header and plots
;

; AX_ISEELS_DISPLAY_EVENT ROUTINES:
; AX_IS_CAPTURE			use Gadwin Print_Screen to save or print file (not working; from Fanning)
; AX_IS_SAVE			save display page as png (not working)
; AX_IS_DISMISS			close widget

; OUTPUT
;	save as a png file
;
; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;	AX_IS_COM 	common for ax_iseels_Display specific data
;;
; SIDE EFFECTS:
;	A window is created/destroyed.
;
; MODIFICATION HISTORY:
; (10-Oct-16 aph) first version
; (20-Oct-16 aph) direct to print - did not work
; (25-Oct-16 my)  ring the changes
; (27-Oct-16 aph) modify for auto-use with a wrapper to feed ax_iseels_display filenames
; (02-Nov-16 aph) removed trailing zeros in type 2 ; strip path from filename in display
; (07-Nov-16 aph) desensitize to case  [E(Ev) works as well as E(eV)]
; (01-May-25 aph) modify to capture essential info from header
; (11-May-25 aph) add html code at the filename and ask user if they want that
; (06-Aug-25 aph) attempted to get save working
; (26-Aug-25 aph) save lastpath
; (28-Sep-25 aph) replace 'index' with 'flat_table' in subroutine call 
;             (the work 'index' is used other places and is in some common blocks [axis_com, xrf_com, but hyphenated  ]
;-



; =============================
pro  ax_IS_save, Event
@axis_com
@AX_IS_COM

;win2lpr, sys = GR_dev, pr = PRINT_dev, Size=5

	PRINT, 'ax_is_display  ', ax_is_display
	wset,ax_IS_display
    bytimg = tvrd(0,0)
    t = ax_name(ax_is_file)
    filename = t(0)+t(1) +'.png'
    help, bytimg
    write_png,filename,bytimg
    print,'Wrote PNG image file "'+filename+'"'

end

; =============================
pro  ax_IS_capture, Event
@axis_com
@AX_IS_COM

     Widget_Control, event.id, Get_UValue=defaultFilename
      IF N_Elements(defaultFilename) EQ 0 THEN defaultFilename='capture.jpg'

      ; Ask for confirmation of the name of the output file.
;      filename = Dialog_Pickfile(Title='Save Application Window As...', $
;        Get_Path=theDir, Filter='*.jpg', /Write, File=defaultFilename)
;      IF filename EQ "" THEN RETURN

	  theDir = 'C:\'
	  theFilename = 'capture.jpg'

      ; Make sure the window containing the button is the active window
      ; so it can be captured.
      Widget_Control, event.id, Input_Focus=1

      ; Capture the window.
  ;    theFilename = StrMid(filename, StrLen(theDir))

;      text = "C:\Program Files\Gadwin\Gadwin PrintScreen\printscreen32.exe " + $

      text = "C:\aXis2000\printscreen32.exe" + " /print='yes'"  + $
;                       "/dir='" + theDir + "' /file='" + theFilename + "' " + $
                       " /nosplash /justnow /askfname='no' " ; + $   ; /exit
;                       "/notaskbar='yes' /preview='no'"  + $  ; /print='1'"
;                         " /image='1'" ;  /autoname='no'"   ; /cptarea='0'

;-----------------------  TRIALS ------------
; "C:\aXis2000\printscreen32.exe /print='yes' /dir='C:\' /file='capture.jpg'/nosplash /justnow /askfname='no' /notaskbar='yes' /preview='no'/image='1' /cptarea='0' /autoname='no'"

;	text = "C:\aXis2000\printscreen32.exe /nosplash  /justnow /askfname='yes' /notaskbar='yes' /preview='no' /print='yes "


; "C:\Program Files\PrintScreen\printscreen.exe  /dir = 'C:\' /file='capture.jpg' /justnow /cptarea='0' "
; -----------------------------------------
	print, '"' + text + '"'
	SPAWN,  text  ; '"' + text + '"' ; /NoShell,
end


; =============================
pro  ax_IS_dismiss, Event
@axis_com
@AX_IS_COM

WIDGET_CONTROL, Event.Top, /DESTROY

end


; ========================================================

;
pro ax_IS_display_event, Event
@axis_com
@AX_IS_COM

 wWidget =  Event.top

  case Event.id of

      Widget_Info(wWidget, FIND_BY_UNAME='WID_BUTTON_dismiss'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        ax_IS_dismiss, Event
    end

      Widget_Info(wWidget, FIND_BY_UNAME='WID_BUTTON_save'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        ax_IS_save, Event
    end

      Widget_Info(wWidget, FIND_BY_UNAME='WID_BUTTON_capture'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        ax_IS_capture, Event
    end

    else:
  endcase

end

; ========================================================

pro ax_IS_display, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_
@axis_com
@AX_IS_COM

  ax_IS_plot = Widget_Base( GROUP_LEADER=wGroup, UNAME='ax_IS_plot'  $
      ,XOFFSET=5 ,YOFFSET=5, SCR_XSIZE=760 ,SCR_YSIZE=650 $
      ,TITLE='IDL' ,SPACE=3 ,XPAD=3 ,YPAD=3)
  WID_DRAW_RAW = Widget_Draw(ax_IS_plot, UNAME='WID_DRAW_RAW'  $
      ,XOFFSET=11 ,YOFFSET=320 ,SCR_XSIZE=360 ,SCR_YSIZE=300)
  WID_DRAW_OS = Widget_Draw(ax_IS_plot, UNAME='WID_DRAW_OS'  $
      ,XOFFSET=380 ,YOFFSET=320 ,SCR_XSIZE=360 ,SCR_YSIZE=300)

;top of display
t = ax_name(ax_is_file)
t_name = t(1) + '.' + t(2)
  WID_TEXT_filename = Widget_Text(ax_IS_plot, UNAME='WID_TEXT_filename' ,XOFFSET=60  $
      ,YOFFSET=10, YSIZE=1,  SCR_XSIZE=200, value = t_name, /editable )  ; XSIZE=200,

  WID_BUTTON_dismiss = Widget_Button(ax_IS_plot, UNAME='WID_BUTTON_dismiss'  $
      ,XOFFSET=600 ,YOFFSET=10,SCR_XSIZE=76,  SCR_YSIZE=26  $
      ,/ALIGN_CENTER ,VALUE='Dismiss')

  WID_TEXT_header = Widget_Text(ax_IS_plot, UNAME='WID_TEXT_header' ,XOFFSET=10  $
      ,YOFFSET=40 ,YSIZE=200, XSIZE=120, /editable, /wrap )
  WID_LABEL_RAW = Widget_Label(ax_IS_plot, UNAME='WID_LABEL_RAW'  $
      ,XOFFSET=53 ,YOFFSET=170 ,SCR_XSIZE=125 ,SCR_YSIZE=20  $
      ,/ALIGN_LEFT ,VALUE='Raw spectrum (counts)')
  WID_LABEL_OS = Widget_Label(ax_IS_plot, UNAME='WID_LABEL_OS'  $
      ,XOFFSET=440 ,YOFFSET=171  $
      ,/ALIGN_LEFT ,VALUE='Oscillator strength spectrum (0.01 eV^-1)')


;IF keyword_set(ax_is_auto) then begin
  WID_BUTTON_capture = Widget_Button(ax_IS_plot, UNAME='WID_BUTTON_capture'  $
      ,XOFFSET=300 ,YOFFSET=580  ,SCR_XSIZE=95 ,SCR_YSIZE=32  $
      ,/ALIGN_CENTER ,VALUE='Capture Window')
;ENDIF



;  WID_BUTTON_capture = Widget_Button(ax_IS_plot, UNAME='WID_BUTTON_capture'  $
;      ,XOFFSET=30 ,YOFFSET=580 $ ; ,SCR_XSIZE=95 ,SCR_YSIZE=32  $
;      ,/ALIGN_CENTER ,VALUE='Capture Window')

  ;WID_BUTTON_capture = Widget_Button(ax_IS_display, Value='Capture Window', $
;	Event_Pro='CaptureWindow', UNAME='WID_BUTTON_capture', UValue='selectimage.jpg' $
;	,XOFFSET=390 ,YOFFSET=580,/ALIGN_CENTER )  ; ,SCR_XSIZE=95 ,SCR_YSIZE=32

; ---------- print filename and header
  widget_control,WID_TEXT_header, set_value = header  ; , /append
;  for i = 1, n_elements(header)-1 do begin
;  	print, header(i)
; 	widget_control,WID_TEXT_header, set_value = '      ' + header(i) ; , /append
;  endfor

; ----- check for alternate data to the standard E,Raw,OS format
;print, header(n_elements(header)-3)
;print, header(n_elements(header)-2)

; identify the type of iseels data base file
; TYPE 1		E, raw, OS
;	*--------------------------------------------------------------
;	* No. of Spectra: 2    name1- 0afc2    name2- 0afc.os
;	*   E (eV)        Raw data             Osc. Str. per atom (E-2)
;

; TYPE 2		E, raw, E	OS
;	*--------------------------------------------------------------
;	* N. of Spectra: 2    name1- 0aac.     name2- 0aac.os
;	*   E (eV)        Mass Abs. Coeff.   E (eV) Osc. Str. per atom (E-2)

;
; TYPE 3		E, raw  	OS		OS-smoothed
;	*--------------------------------------------------------------
;	* No. of Spectra: 3     name1- 0vlo    name2- 0vlo.os  name3- 0vlo.oss
;	*   E (eV)        Raw data      Osc. Str. per atom (E-2)   smoothed

;
; TYPE 4      E, raw  (raw-modified)	OS
; 	*--------------------------------------------------------------
;	* No. of Spectra: 3     WE NEED AN EXAMPLE OF THIS ONE
;	*   E (eV)        Raw data    Raw data modified   Osc. Str. per atom (E-2)

type = 1
txt = strlowcase(header(n_elements(header)-2))
IF strpos(txt,'(ev)', strpos(txt, '(ev)')+1) GT 0 then type = 2
IF strpos(txt,'smooth') GT 0 then type = 3
IF strpos(txt,'raw', strpos(txt, 'raw')+2) GT 0 then type = 4
;print, 'check text: ', txt
;print, 'Type = ', type

Widget_Control, /REALIZE, ax_IS_plot

; ----------- get info needed to access the draw_window (only after REALIZE !)
widget_control, WID_DRAW_RAW, GET_value=AX_IS_RAW
widget_control, WID_DRAW_OS, GET_value=AX_IS_OS

CASE Type OF

1: BEGIN
; ---------- plot raw data
	t=ax_name(ax_is_file)
	fileshort = t(1)
	sr={t:'1d', x:ax_is_energy, d:ax_is_Data(0,*), fn:ax_is_Data(0,*), $
	     x_label:'Energy Loss (eV)', dn:fileshort}
	wset,AX_IS_RAW
;	splot, sr
	plot, ax_is_energy, ax_is_Data(0,*),background=255, color=0

;  ---------- plot OS data
	sr={t:'1d', x:ax_is_energy, d:ax_is_Data(1,*), fn:ax_is_Data(1,*), $
	     x_label:'Energy Loss (eV)', dn:fileshort}
	wset,AX_IS_OS
;	splot, sr
	plot, ax_is_energy, ax_is_Data(1,*),background=255, color=0

   END

2:  BEGIN		;  	E, raw, E	OS
; ---------- plot raw data
	t=ax_name(ax_is_file)
	fileshort = t(1)
	sr={t:'1d', x:ax_is_energy, d:ax_is_Data(0,*), fn:ax_is_Data(0,*), $
	     x_label:'Energy Loss (eV)', dn:fileshort}
	wset,AX_IS_RAW
;	splot, sr
	plot, ax_is_energy, ax_is_Data(0,*),background=255, color=0

	t = size(ax_is_Data(2,*))
	t_end = t(4)
	for i = t(4)-1, 0, -1 do begin
		if ax_is_Data(2,i) EQ 0. then t_end = t_end-1
	endfor
	tmp1 = ax_is_Data(1,0:t_end-1)
	tmp2 = ax_is_Data(2,0:t_end-1)
;	print, 'last non-zero value is ', t_end-1, tmp2(n_elements(tmp2)-1)

;  ---------- plot OS data
	sr={t:'1d', x:ax_is_Data(1,*), d:ax_is_Data(2,*), fn:ax_is_Data(2,*), $
	     x_label:'Energy Loss (eV)', dn:fileshort}
	wset,AX_IS_OS
;	splot, sr
	plot, tmp1, tmp2,background=255, color=0
;	plot, ax_is_Data(1,*), ax_is_Data(2,*),background=255, color=0

   END

3: BEGIN	;    E, raw  	OS		OS-smoothed
; ---------- plot raw data
	t=ax_name(ax_is_file)
	fileshort = t(1)
	sr={t:'1d', x:ax_is_energy, d:ax_is_Data(0,*), fn:ax_is_Data(0,*), $
	     x_label:'Energy Loss (eV)', dn:fileshort}
	wset,AX_IS_RAW
;	splot, sr
	plot, ax_is_energy, ax_is_Data(0,*),background=255, color=0

;  ---------- plot OS data
	sr={t:'1d', x:ax_is_energy, d:ax_is_Data(1,*), fn:ax_is_Data(1,*), $
	     x_label:'Energy Loss (eV)', dn:fileshort}
	wset,AX_IS_OS
;	splot, sr
	plot, ax_is_energy, ax_is_Data(1,*),background=255, color=0

;  ---------- over-plot OS smoothed  data
	wset,AX_IS_OS
	oplot, ax_is_energy, ax_is_Data(2,*), color = 0, thick=2

   END

4: BEGIN		;    E, raw  (raw-modified)	OS
; ---------- plot raw data
	t=ax_name(ax_is_file)
	fileshort = t(1)
	sr={t:'1d', x:ax_is_energy, d:ax_is_Data(0,*), fn:ax_is_Data(0,*), $
	     x_label:'Energy Loss (eV)', dn:fileshort}
	wset,AX_IS_RAW
;	splot, sr
	plot, ax_is_energy, ax_is_Data(0,*),background=255, color=0

;  ---------- over-plot modified Raw data
	wset,AX_IS_RAW
	oplot, ax_is_energy, ax_is_Data(1,*), color = 0, thick=2

;  ---------- plot OS data
	sr={t:'1d', x:ax_is_energy, d:ax_is_Data(2,*), fn:ax_is_Data(1,*), $
	     x_label:'Energy Loss (eV)', dn:fileshort}
	wset,AX_IS_OS
;	splot, sr
	plot, ax_is_energy, ax_is_Data(2,*),background=255, color=0

   END

ENDCASE

  XManager, 'ax_IS_display', ax_IS_plot ,  /NO_BLOCK

end

;===============================
function ax_iseels_display, file=file, raw=raw, os=os, flat_table=flat_table, plot=plot, add_html=add_html,   $
     save=save, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_	; ax_is_auto= ax_is_auto,
@ax_IS_com
@axis_com
on_error, 2

if not keyword_set(file) then begin
	file = dialog_pickfile(title='Select ISEELS database file(s)', filter='*.*', /read, /multiple)
endif
t = ax_name(file(0))
lpath=t(0)
print, ' setting last path to ', lpath

n_files= n_elements(file)

for i = 0, n_files-1 do begin

	ax_is_file = file(i)
	if findfile(ax_is_file) EQ '' then goto, nofile

	read_xas,ax_is_file, ax_is_energy, ax_is_data, header, /iseels


	; ------- generate the flat_table as a *.csv file (NB ensure NO comma's in the *.os files !!
	;if flat_table keyword set, extract and return the required information as text string
	;  name, formula, alpha formula, edge filename, citation
	if keyword_set(flat_table) then begin
		table=strarr(7)
		t = header(4)
		name = strtrim(strmid(t,7,strlen(t)-1),2)
		print, 'Name: ', name
		table(0)=name
		t = header(3)
		formula = strtrim(strmid(t,10,strlen(t)-1),2)
		print, 'Formula: ', formula
		table(1)=formula
		t = header(6)
		alpha_formula = strtrim(strmid(t,17,strlen(t)-1),2)
		print, 'alpha Formula: ', alpha_formula
		table(2)=alpha_formula
		t = header(5)
		edge = strtrim(strmid(t,8,strlen(t)-1),2)
		print, 'edge: ', edge
		table(3)= edge
		t = header(8)

		if keyword_set(add_html) then begin
			datafile = strtrim(strmid(t,11,strlen(t)-1),2)
			datafile_html = '<a href="data/' + datafile + '">' + datafile + '</a>
			print, 'filename:& html:  ', datafile_html
			table(4)= datafile_html

		endif else begin
				datafile = strtrim(strmid(t,11,strlen(t)-1),2)
				print, 'filename: ', datafile
				table(4)= datafile
		endelse
	;	----------------------------------------------------

		t = header(9)
		ref_code = strtrim(strmid(t,13,strlen(t)-1),2)
		print, 'Ref. Code: ', ref_code
		table(5)= ref_code
		t = header(11)
		reference = strtrim(strmid(t,12,strlen(t)-1),2)
		print, 'Reference: ', reference
		table(6)= reference
		; return as a single CSV string
		index_string = ''
		for i = 0,5 do begin
			index_string = index_string + table(i) + ','
		endfor
		index_string = index_string + table(6)
		return, index_string

	endif

	if ax_is_data(0,0) EQ 0 then begin
		t = size(ax_is_data)
		print, 'size of ax_is_data ', t
		tmp = fltarr(t(1),t(2)-1)
		tmp = ax_is_data(*,1:t(2)-1)
		ax_is_data = tmp
		ax_is_energy = ax_is_energy(1:n_elements(ax_is_energy)-1)
	endif


	t= ax_name(ax_IS_file)
	print, 'ISEELS data file ', t(1) +'.' + t(2)

	if keyword_Set(plot) then begin
; --------- generate display page
		t = ax_name(ax_is_file)
	    filename = t(0)+t(1) +'.png'
		ax_IS_display, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_
	endif
	list = file(0:i)
endfor

return, list

; ---------- error recovery if file does not exist
nofile:
; close,lun
; free_lun,lun
print,'Could not read file "'+file+'
return, header


end
