; Copyright (c) 1998-2010 A.P. Hitchcock  All rights reserved
;+
;NAME:
;  GENEXTRAP.PRO
;
;LAST CHANGED: ----------------------------------- 21-Jul-06
;
; PURPOSE:
;	For XSpecSim - extrapolates a spectrum from known points to unkown points
;
; CATEGORY:
;	spectral processing; XSpecSim utility
;
; CALLING SEQUENCE:
;	RESULT = GENEXTRAP (EN=EN, SPECDATA=SPECDATA)
;
; INPUTS: none
;
; KEYWORDS:
; 	SpecData	2d array of energy and spectral data from OD of sample
;	En			1d Array of new energy scale
;
; OUTPUTS: 	none
;
; COMMON BLOCKS: none
;
; RESTRICTIONS: none
;
; MODIFICATION HISTORY:
; (21-Jul-06 jso) first version
; (19-Jul-10 aph) AXIS standard header added; "data" variable changed to SpecData
;-

function GenExtrap, En=En, SpecData=SpecData

	ans = fltarr(N_elements(En))
	for i = 0, N_elements(En)-1 do begin
		Ans[i]=averageval(arr=SpecData,Val=En[i])
	EndFor

return, ans
End