/*
 * Decompiled with CFR 0.152.
 */
package txmreader;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public final class TxmImage {
    private final int ImageWidth;
    private final int ImageHeight;
    private final float PixelSize;
    private final float[][] pixels;
    private final int ScanSize;
    private final float[][] FastScanAxisPosition;
    private final float[][] SlowScanAxisPosition;
    private final float Angles;
    private final float Energy;
    private final float ExpTimes;
    private final int HorizontalBin;
    private final int VerticalBin;
    private final float PixelSizeX;
    private final float PixelSizeY;
    private final float XPosition;
    private final float YPosition;
    private final float ZPosition;
    private final int TotalAxis;
    private final float[] MotorPositions;
    private final String[] AxisNames;

    private static int readInt(DirectoryEntry dir, String file) throws IOException {
        DocumentEntry document = (DocumentEntry)dir.getEntry(file);
        try (DocumentInputStream stream = new DocumentInputStream(document);){
            int n = stream.readInt();
            return n;
        }
    }

    private static float readFloat(DirectoryEntry dir, String file) throws IOException {
        return Float.intBitsToFloat(TxmImage.readInt(dir, file));
    }

    private static float[] readFloat(DirectoryEntry dir, String file, int n) throws IOException {
        DocumentEntry document = (DocumentEntry)dir.getEntry(file);
        float[] a = new float[n];
        try (DocumentInputStream stream = new DocumentInputStream(document);){
            int i = 0;
            while (i < n) {
                a[i] = Float.intBitsToFloat(stream.readInt());
                ++i;
            }
        }
        return a;
    }

    private static float[][] readFloat(DirectoryEntry dir, String file, int n, int m) throws IOException {
        DocumentEntry document = (DocumentEntry)dir.getEntry(file);
        float[][] a = new float[n][m];
        try (DocumentInputStream stream = new DocumentInputStream(document);){
            int i = 0;
            while (i < n) {
                int j = 0;
                while (j < m) {
                    a[i][j] = Float.intBitsToFloat(stream.readInt());
                    ++j;
                }
                ++i;
            }
        }
        return a;
    }

    public static List<TxmImage> ReadImages(String filename) throws IOException {
        ArrayList<TxmImage> list = new ArrayList<TxmImage>();
        try (FileInputStream filestream = new FileInputStream(filename);){
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)filestream);
            DirectoryEntry ImageInfo = (DirectoryEntry)fs.getRoot().getEntry("ImageInfo");
            int ImageHeight = TxmImage.readInt(ImageInfo, "ImageHeight");
            int NoOfImages = TxmImage.readInt(ImageInfo, "ImagesTaken");
            int ImageWidth = TxmImage.readInt(ImageInfo, "ImageWidth");
            float PixelSize = TxmImage.readFloat(ImageInfo, "PixelSize");
            float PixelSizeX = TxmImage.readFloat(ImageInfo, "PixelSizeX");
            float PixelSizeY = TxmImage.readFloat(ImageInfo, "PixelSizeY");
            float[] Angles = TxmImage.readFloat(ImageInfo, "Angles", NoOfImages);
            float[] ExpTimes = TxmImage.readFloat(ImageInfo, "ExpTimes", NoOfImages);
            float Energy = TxmImage.readFloat(ImageInfo, "Energy");
            int HorizontalBin = TxmImage.readInt(ImageInfo, "HorizontalBin");
            int VerticalBin = TxmImage.readInt(ImageInfo, "VerticalalBin");
            float[] XPosition = TxmImage.readFloat(ImageInfo, "XPosition", NoOfImages);
            float[] YPosition = TxmImage.readFloat(ImageInfo, "YPosition", NoOfImages);
            float[] ZPosition = TxmImage.readFloat(ImageInfo, "ZPosition", NoOfImages);
            DirectoryEntry FastAndSlowScanAxisPosition = (DirectoryEntry)fs.getRoot().getEntry("FastAndSlowScanAxisPosition");
            float[][] FastScanAxisPosition = TxmImage.readFloat(FastAndSlowScanAxisPosition, "FastScanAxisPosition", ImageHeight, ImageWidth);
            float[][] SlowScanAxisPosition = TxmImage.readFloat(FastAndSlowScanAxisPosition, "SlowScanAxisPosition", ImageHeight, ImageWidth);
            int ScanSize = TxmImage.readInt(FastAndSlowScanAxisPosition, "ScanSize");
            DirectoryEntry PositionInfo = (DirectoryEntry)fs.getRoot().getEntry("PositionInfo");
            int TotalAxis = TxmImage.readInt(PositionInfo, "TotalAxis");
            DocumentEntry document = (DocumentEntry)PositionInfo.getEntry("AxisNames");
            String[] AxisNames = new String[TotalAxis];
            try (DocumentInputStream stream = new DocumentInputStream(document);){
                int i = 0;
                while (i < TotalAxis) {
                    byte[] buf = new byte[25];
                    stream.readFully(buf, 0, 25);
                    AxisNames[i] = new String(buf).trim();
                    ++i;
                }
            }
            float[][] MotorPositions = TxmImage.readFloat(PositionInfo, "MotorPositions", NoOfImages, TotalAxis);
            DirectoryEntry Images = (DirectoryEntry)fs.getRoot().getEntry("ImageData1");
            int i = 1;
            while (i <= NoOfImages) {
                float[][] pixels = TxmImage.readFloat(Images, "Image" + i, ImageHeight, ImageWidth);
                list.add(new TxmImage(ImageWidth, ImageHeight, PixelSize, pixels, ScanSize, FastScanAxisPosition, SlowScanAxisPosition, Angles[i - 1], Energy, ExpTimes[i - 1], HorizontalBin, VerticalBin, PixelSizeY, PixelSizeX, XPosition[i - 1], YPosition[i - 1], ZPosition[i - 1], TotalAxis, MotorPositions[i - 1], AxisNames));
                ++i;
            }
        }
        return list;
    }

    private TxmImage(int ImageWidth, int ImageHeight, float PixelSize, float[][] pixels, int ScanSize, float[][] FastScanAxisPosition, float[][] SlowScanAxisPosition, float Angles, float Energy, float ExpTimes, int HorizontalBin, int VerticalBin, float PixelSizeX, float PixelSizeY, float XPosition, float YPosition, float ZPosition, int TotalAxis, float[] MotorPositions, String[] AxisNames) {
        this.ImageWidth = ImageWidth;
        this.ImageHeight = ImageHeight;
        this.PixelSize = PixelSize;
        this.pixels = pixels;
        this.ScanSize = ScanSize;
        this.FastScanAxisPosition = FastScanAxisPosition;
        this.SlowScanAxisPosition = SlowScanAxisPosition;
        this.Angles = Angles;
        this.Energy = Energy;
        this.ExpTimes = ExpTimes;
        this.HorizontalBin = HorizontalBin;
        this.VerticalBin = VerticalBin;
        this.PixelSizeX = PixelSizeX;
        this.PixelSizeY = PixelSizeY;
        this.XPosition = XPosition;
        this.YPosition = YPosition;
        this.ZPosition = ZPosition;
        this.TotalAxis = TotalAxis;
        this.MotorPositions = MotorPositions;
        this.AxisNames = AxisNames;
    }

    public int getImageWidth() {
        return this.ImageWidth;
    }

    public int getImageHeight() {
        return this.ImageHeight;
    }

    public float getPixelSize() {
        return this.PixelSize;
    }

    public float[][] getPixels() {
        return this.pixels;
    }

    public int getScanSize() {
        return this.ScanSize;
    }

    public float[][] getFastScanAxisPosition() {
        return this.FastScanAxisPosition;
    }

    public float[][] getSlowScanAxisPosition() {
        return this.SlowScanAxisPosition;
    }

    public float getAngles() {
        return this.Angles;
    }

    public float getEnergy() {
        return this.Energy;
    }

    public float getExpTimes() {
        return this.ExpTimes;
    }

    public int getHorizontalBin() {
        return this.HorizontalBin;
    }

    public int getVerticalBin() {
        return this.VerticalBin;
    }

    public float getPixelSizeX() {
        return this.PixelSizeX;
    }

    public float getPixelSizeY() {
        return this.PixelSizeY;
    }

    public float getXPosition() {
        return this.XPosition;
    }

    public float getYPosition() {
        return this.YPosition;
    }

    public float getZPosition() {
        return this.ZPosition;
    }

    public float getTotalAxis() {
        return this.TotalAxis;
    }

    public float[] getMotorPositions() {
        return this.MotorPositions;
    }

    public String[] getAxisNames() {
        return this.AxisNames;
    }
}

