; Copyright (c) 1998-2015 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_COLORBAR
;
;LAST CHANGED: ----------------------------------- 02-Aug-15
;
;PURPOSE:
;	This procedure displays a vertical color bar according to current gamma
; The low and high limits are displayed in AXIS separately.
;
;CATEGORY:
;	AXIS: utility
;
;CALLING SEQUENCE:
; 	AX_COLORBAR [, destroy ]

;CALLED FROM AXIS:
;	(from PlotBuf)
;
;INPUTS: none
;
;KEYWORDS:
;	DESTROY - remove the colorbar (if not displaying an image)
;
;OUTPUTS: none
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;PROCEDURE:
;	Uses IDL colorbar procedure but adapted to AXIS widget
; by positioning the bar in a draw window set up by AXIS
;
;MODIFICATION HISTORY:
; (12-nov-99 aph) first verion adapted from examples in Fanning's colorbar_define.pro
; (31-dec-99 aph) AXIS standard documentation
; (07-apr-00 cgz) Added ncolors option to call of colorbar.
;				This gives the correct presentation of the gray-scale color bar
; (30-dec-00 aph) aborted attemt to add limits; shift to abut image
; (07-oct-01 aph) modify to fill sub-wdget; axis2000 modified to add Z-limits to bar
; (13-Oct-05 aph) trap out cases where limits are equal and make them slightly different
; (11-dec-11 aph) handle cases where the data is all zero
; (02-Aug-15 aph) change colorbar to colorbar_dwf to avoid confusion with post8.0 COLORBAR routine
;-

PRO ax_colorbar, destroy = destroy

@axis_com
on_error,2

; a version using Fanning object classes is commented out in this
; must link with codes in \axis_dev\fanning to get the other parts
; ------------ OBJECT VERSION (IDL 5.2 & later)
;   colorbar = Obj_New("COLORBAR", vertical = 1, Title='', Major=1, Format='(I4)')
;   Window
;   colorbar->Draw
;   colorbar->SetProperty, position = [0.7,0.2,0.73,0.5], Range=[0,100], /Erase, /Draw
;   Obj_Destroy, colorbar

; ------------ the hacker's version

wset, ColorbarPlot

if keyword_set(destroy) then begin
	erase,ax_white_color_index
endif else begin
;
; -------- check for aberrant case when all data is same value (min = max) or zero
;
	IF Zrng(0) EQ Zrng(1) then begin
		if Zrng(0) EQ 0 then del = 0.002 else del = Zrng(0)/1000.
		Zrng(0) = Zrng(0) - del/2.
		Zrng(1) = Zrng(1) + del/2.
	ENDIF
	erase, ax_white_color_index
	colorbar_dwf, /vertical, color=ax_black_color_index, $
	   format = '(g9.2)', charsize = 0.5, $
	   bottom = ax_low_color_index, top = ax_top_color_index, $
	   ncolors = ax_top_color_index - ax_low_color_index, $
	   position = [0.0,0.0,1.,1.], ticklen = 0.0, $
	   division = 1, range = Zrng
;	colorbar_dwf, position = [0.05,0.05,0.55,0.55], color=ax_black_color_index, $
;	   format = '(g9.2)', charsize = 0.05, bottom = ax_low_color_index, $
;	   top = ax_top_color_index, ncolors = ax_top_color_index - ax_low_color_index, $
;	   /vertical, /right, division = 1, range = Zrng, title=''
endelse
wset, MainImg

end


